/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.maps;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.IntSet;
import io.anuke.arc.collection.StringMap;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.util.Log;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Gamemode;
import io.anuke.mindustry.game.Rules;
import io.anuke.mindustry.io.JsonIO;
import io.anuke.mindustry.maps.filters.GenerateFilter;
import io.anuke.mindustry.type.Publishable;

public class Map
implements Comparable<Map>,
Publishable {
    public final boolean custom;
    public final StringMap tags;
    public final FileHandle file;
    public final int version;
    public boolean workshop;
    public int width;
    public int height;
    public Texture texture;
    public int build;
    public IntSet teams = new IntSet();
    public int spawns = 0;

    public Map(FileHandle file, int width, int height, StringMap tags, boolean custom, int version, int build) {
        this.custom = custom;
        this.tags = tags;
        this.file = file;
        this.width = width;
        this.height = height;
        this.version = version;
        this.build = build;
    }

    public Map(FileHandle file, int width, int height, StringMap tags, boolean custom, int version) {
        this(file, width, height, tags, custom, version, -1);
    }

    public Map(FileHandle file, int width, int height, StringMap tags, boolean custom) {
        this(file, width, height, tags, custom, -1);
    }

    public Map(StringMap tags) {
        this(Vars.customMapDirectory.child(tags.get("name", "unknown")), 0, 0, tags, true);
    }

    public int getHightScore() {
        return Core.settings.getInt("hiscore" + this.file.nameWithoutExtension(), 0);
    }

    public Texture safeTexture() {
        return this.texture == null ? (Texture)Core.assets.get("sprites/error.png") : this.texture;
    }

    public FileHandle previewFile() {
        return Vars.mapPreviewDirectory.child((this.workshop ? this.file.parent().name() : this.file.nameWithoutExtension()) + ".png");
    }

    public FileHandle cacheFile() {
        return Vars.mapPreviewDirectory.child(this.file.nameWithoutExtension() + "-cache.dat");
    }

    public void setHighScore(int score) {
        Core.settings.put("hiscore" + this.file.nameWithoutExtension(), score);
        Vars.data.modified();
    }

    public Rules applyRules(Gamemode mode) {
        Rules out = new Rules();
        mode.apply(out);
        return this.rules(out);
    }

    public Rules rules() {
        return this.rules(new Rules());
    }

    public Rules rules(Rules base) {
        try {
            Rules result = JsonIO.read(Rules.class, base, this.tags.get("rules", "{}"));
            if (result.spawns.isEmpty()) {
                result.spawns = Vars.defaultWaves.get();
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Rules();
        }
    }

    public Array<GenerateFilter> filters() {
        if (this.tags.getInt("build", -1) < 83 && this.tags.getInt("build", -1) != -1 && this.tags.get("genfilters", "").isEmpty()) {
            return Array.with(new GenerateFilter[0]);
        }
        return Vars.maps.readFilters(this.tags.get("genfilters", ""));
    }

    public String author() {
        return this.tag("author");
    }

    public String description() {
        return this.tag("description");
    }

    public String name() {
        return this.tag("name");
    }

    public String tag(String name) {
        return this.tags.containsKey(name) && !((String)this.tags.get(name)).trim().isEmpty() ? (String)this.tags.get(name) : Core.bundle.get("unknown");
    }

    public boolean hasTag(String name) {
        return this.tags.containsKey(name);
    }

    @Override
    public String getSteamID() {
        return (String)this.tags.get("steamid");
    }

    @Override
    public void addSteamID(String id) {
        this.tags.put("steamid", id);
        Vars.ui.editor.editor.getTags().put("steamid", id);
        try {
            Vars.ui.editor.save();
        }
        catch (Exception e) {
            Log.err(e);
        }
        Events.fire(new EventType.MapPublishEvent());
    }

    @Override
    public void removeSteamID() {
        this.tags.remove("steamid");
        Vars.ui.editor.editor.getTags().remove("steamid");
        try {
            Vars.ui.editor.save();
        }
        catch (Exception e) {
            Log.err(e);
        }
    }

    @Override
    public String steamTitle() {
        return this.name();
    }

    @Override
    public String steamDescription() {
        return this.description();
    }

    @Override
    public String steamTag() {
        return "map";
    }

    @Override
    public FileHandle createSteamFolder(String id) {
        return null;
    }

    @Override
    public FileHandle createSteamPreview(String id) {
        return null;
    }

    @Override
    public Array<String> extraTags() {
        Gamemode mode = Gamemode.attack.valid(this) ? Gamemode.attack : Gamemode.survival;
        return Array.with(mode.name());
    }

    @Override
    public boolean prePublish() {
        this.tags.put("author", Vars.player.name);
        Vars.ui.editor.editor.getTags().put("author", this.tags.get("author"));
        Vars.ui.editor.save();
        return true;
    }

    @Override
    public int compareTo(Map map) {
        int work = -Boolean.compare(this.workshop, map.workshop);
        if (work != 0) {
            return work;
        }
        int type = -Boolean.compare(this.custom, map.custom);
        if (type != 0) {
            return type;
        }
        int modes = Boolean.compare(Gamemode.pvp.valid(this), Gamemode.pvp.valid(map));
        if (modes != 0) {
            return modes;
        }
        return this.name().compareTo(map.name());
    }

    public String toString() {
        return "Map{file='" + this.file + '\'' + ", custom=" + this.custom + ", tags=" + this.tags + '}';
    }
}

