/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.io;

import io.anuke.arc.graphics.Color;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.entities.traits.BuilderTrait;
import io.anuke.mindustry.entities.traits.ShooterTrait;
import io.anuke.mindustry.entities.type.BaseUnit;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.entities.units.UnitCommand;
import io.anuke.mindustry.game.Rules;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.io.JsonIO;
import io.anuke.mindustry.net.Administration;
import io.anuke.mindustry.net.Packets;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.type.Mech;
import io.anuke.mindustry.type.UnitType;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Pos;
import io.anuke.mindustry.world.Tile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TypeIO {
    public static void writePlayer(ByteBuffer buffer, Player player) {
        if (player == null) {
            buffer.putInt(-1);
        } else {
            buffer.putInt(player.id);
        }
    }

    public static Player readPlayer(ByteBuffer buffer) {
        int id = buffer.getInt();
        return id == -1 ? null : Vars.playerGroup.getByID(id);
    }

    public static void writeUnit(ByteBuffer buffer, Unit unit) {
        if (unit.getGroup() == null) {
            buffer.put((byte)-1);
            return;
        }
        buffer.put((byte)unit.getGroup().getID());
        buffer.putInt(unit.getID());
    }

    public static Unit readUnit(ByteBuffer buffer) {
        byte gid = buffer.get();
        if (gid == -1) {
            return null;
        }
        int id = buffer.getInt();
        return (Unit)Vars.entities.get(gid).getByID(id);
    }

    public static void writeShooter(ByteBuffer buffer, ShooterTrait trait) {
        buffer.put((byte)trait.getGroup().getID());
        buffer.putInt(trait.getID());
    }

    public static ShooterTrait readShooter(ByteBuffer buffer) {
        byte gid = buffer.get();
        int id = buffer.getInt();
        return (ShooterTrait)Vars.entities.get(gid).getByID(id);
    }

    public static void writeBullet(ByteBuffer buffer, Bullet bullet) {
        buffer.putInt(bullet.getID());
    }

    public static Bullet readBullet(ByteBuffer buffer) {
        int id = buffer.getInt();
        return Vars.bulletGroup.getByID(id);
    }

    public static void writeBaseUnit(ByteBuffer buffer, BaseUnit unit) {
        buffer.put((byte)unit.getTeam().ordinal());
        buffer.putInt(unit.getID());
    }

    public static BaseUnit readBaseUnit(ByteBuffer buffer) {
        byte tid = buffer.get();
        int id = buffer.getInt();
        return Vars.unitGroups[tid].getByID(id);
    }

    public static void writeTile(ByteBuffer buffer, Tile tile) {
        buffer.putInt(tile == null ? Pos.get(-1, -1) : tile.pos());
    }

    public static Tile readTile(ByteBuffer buffer) {
        return Vars.world.tile(buffer.getInt());
    }

    public static void writeBlock(ByteBuffer buffer, Block block) {
        buffer.putShort(block.id);
    }

    public static Block readBlock(ByteBuffer buffer) {
        return Vars.content.block(buffer.getShort());
    }

    public static void writeRequests(ByteBuffer buffer, BuilderTrait.BuildRequest[] requests) {
        buffer.putShort((short)requests.length);
        for (BuilderTrait.BuildRequest request : requests) {
            buffer.put(request.breaking ? (byte)1 : 0);
            buffer.putInt(Pos.get(request.x, request.y));
            if (request.breaking) continue;
            buffer.putShort(request.block.id);
            buffer.put((byte)request.rotation);
            buffer.put(request.hasConfig ? (byte)1 : 0);
            buffer.putInt(request.config);
        }
    }

    public static BuilderTrait.BuildRequest[] readRequests(ByteBuffer buffer) {
        int reqamount = buffer.getShort();
        BuilderTrait.BuildRequest[] reqs = new BuilderTrait.BuildRequest[reqamount];
        for (int i = 0; i < reqamount; ++i) {
            BuilderTrait.BuildRequest currentRequest;
            byte type = buffer.get();
            int position = buffer.getInt();
            if (Vars.world.tile(position) == null) continue;
            if (type == 1) {
                currentRequest = new BuilderTrait.BuildRequest(Pos.x(position), Pos.y(position));
            } else {
                short block = buffer.getShort();
                byte rotation = buffer.get();
                boolean hasConfig = buffer.get() == 1;
                int config = buffer.getInt();
                currentRequest = new BuilderTrait.BuildRequest(Pos.x(position), Pos.y(position), rotation, Vars.content.block(block));
                if (hasConfig) {
                    currentRequest.configure(config);
                }
            }
            reqs[i] = currentRequest;
        }
        return reqs;
    }

    public static void writeKick(ByteBuffer buffer, Packets.KickReason reason) {
        buffer.put((byte)reason.ordinal());
    }

    public static Packets.KickReason readKick(ByteBuffer buffer) {
        return Packets.KickReason.values()[buffer.get()];
    }

    public static void writeRules(ByteBuffer buffer, Rules rules) {
        String string = JsonIO.write(rules);
        byte[] bytes = string.getBytes(Vars.charset);
        buffer.putInt(bytes.length);
        buffer.put(bytes);
        TypeIO.writeString(buffer, JsonIO.write(rules));
    }

    public static Rules readRules(ByteBuffer buffer) {
        int length = buffer.getInt();
        byte[] bytes = new byte[length];
        buffer.get(length);
        String string = new String(bytes, Vars.charset);
        return JsonIO.read(Rules.class, string);
    }

    public static void writeTeam(ByteBuffer buffer, Team reason) {
        buffer.put((byte)reason.ordinal());
    }

    public static Team readTeam(ByteBuffer buffer) {
        return Team.all[buffer.get()];
    }

    public static void writeUnitCommand(ByteBuffer buffer, UnitCommand reason) {
        buffer.put((byte)reason.ordinal());
    }

    public static UnitCommand readUnitCommand(ByteBuffer buffer) {
        return UnitCommand.all[buffer.get()];
    }

    public static void writeAction(ByteBuffer buffer, Packets.AdminAction reason) {
        buffer.put((byte)reason.ordinal());
    }

    public static Packets.AdminAction readAction(ByteBuffer buffer) {
        return Packets.AdminAction.values()[buffer.get()];
    }

    public static void writeEffect(ByteBuffer buffer, Effects.Effect effect) {
        buffer.putShort((short)effect.id);
    }

    public static Effects.Effect readEffect(ByteBuffer buffer) {
        return Effects.getEffect(buffer.getShort());
    }

    public static void writeUnitType(ByteBuffer buffer, UnitType effect) {
        buffer.putShort(effect.id);
    }

    public static UnitType readUnitType(ByteBuffer buffer) {
        return (UnitType)Vars.content.getByID(ContentType.unit, buffer.getShort());
    }

    public static void writeColor(ByteBuffer buffer, Color color) {
        buffer.putInt(Color.rgba8888(color));
    }

    public static Color readColor(ByteBuffer buffer) {
        return new Color(buffer.getInt());
    }

    public static void writeMech(ByteBuffer buffer, Mech mech) {
        buffer.put((byte)mech.id);
    }

    public static Mech readMech(ByteBuffer buffer) {
        return (Mech)Vars.content.getByID(ContentType.mech, buffer.get());
    }

    public static void writeLiquid(ByteBuffer buffer, Liquid liquid) {
        buffer.putShort(liquid == null ? (short)-1 : (short)liquid.id);
    }

    public static Liquid readLiquid(ByteBuffer buffer) {
        short id = buffer.getShort();
        return id == -1 ? null : Vars.content.liquid(id);
    }

    public static void writeBulletType(ByteBuffer buffer, BulletType type) {
        buffer.putShort(type.id);
    }

    public static BulletType readBulletType(ByteBuffer buffer) {
        return (BulletType)Vars.content.getByID(ContentType.bullet, buffer.getShort());
    }

    public static void writeItem(ByteBuffer buffer, Item item) {
        buffer.putShort(item == null ? (short)-1 : (short)item.id);
    }

    public static Item readItem(ByteBuffer buffer) {
        short id = buffer.getShort();
        return id == -1 ? null : Vars.content.item(id);
    }

    public static void writeString(ByteBuffer buffer, String string) {
        if (string != null) {
            byte[] bytes = string.getBytes(Vars.charset);
            buffer.putShort((short)bytes.length);
            buffer.put(bytes);
        } else {
            buffer.putShort((short)-1);
        }
    }

    public static String readString(ByteBuffer buffer) {
        short slength = buffer.getShort();
        if (slength != -1) {
            byte[] bytes = new byte[slength];
            buffer.get(bytes);
            return new String(bytes, Vars.charset);
        }
        return null;
    }

    public static void writeBytes(ByteBuffer buffer, byte[] bytes) {
        buffer.putShort((short)bytes.length);
        buffer.put(bytes);
    }

    public static byte[] readBytes(ByteBuffer buffer) {
        short length = buffer.getShort();
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return bytes;
    }

    public static void writeTraceInfo(ByteBuffer buffer, Administration.TraceInfo trace) {
        TypeIO.writeString(buffer, trace.ip);
        TypeIO.writeString(buffer, trace.uuid);
        buffer.put(trace.modded ? (byte)1 : 0);
        buffer.put(trace.mobile ? (byte)1 : 0);
    }

    public static Administration.TraceInfo readTraceInfo(ByteBuffer buffer) {
        return new Administration.TraceInfo(TypeIO.readString(buffer), TypeIO.readString(buffer), buffer.get() == 1, buffer.get() == 1);
    }

    public static void writeStringData(DataOutput buffer, String string) throws IOException {
        if (string != null) {
            byte[] bytes = string.getBytes(Vars.charset);
            buffer.writeShort((short)bytes.length);
            buffer.write(bytes);
        } else {
            buffer.writeShort(-1);
        }
    }

    public static String readStringData(DataInput buffer) throws IOException {
        short slength = buffer.readShort();
        if (slength != -1) {
            byte[] bytes = new byte[slength];
            buffer.readFully(bytes);
            return new String(bytes, Vars.charset);
        }
        return null;
    }
}

