/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.io;

import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.StringMap;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.io.CounterInputStream;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.core.Version;
import io.anuke.mindustry.ctype.Content;
import io.anuke.mindustry.ctype.MappableContent;
import io.anuke.mindustry.entities.EntityGroup;
import io.anuke.mindustry.entities.traits.Entity;
import io.anuke.mindustry.entities.traits.SaveTrait;
import io.anuke.mindustry.game.Rules;
import io.anuke.mindustry.game.Stats;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.game.Teams;
import io.anuke.mindustry.io.JsonIO;
import io.anuke.mindustry.io.SaveFileReader;
import io.anuke.mindustry.io.SaveMeta;
import io.anuke.mindustry.maps.Map;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.type.TypeID;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.WorldContext;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class SaveVersion
extends SaveFileReader {
    public int version;
    protected int lastReadBuild;

    public SaveVersion(int version) {
        this.version = version;
    }

    public SaveMeta getMeta(DataInput stream) throws IOException {
        stream.readInt();
        StringMap map = this.readStringMap(stream);
        return new SaveMeta(map.getInt("version"), map.getLong("saved"), map.getLong("playtime"), map.getInt("build"), (String)map.get("mapname"), map.getInt("wave"), JsonIO.read(Rules.class, map.get("rules", "{}")), map);
    }

    @Override
    public final void write(DataOutputStream stream) throws IOException {
        this.write(stream, new StringMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void read(DataInputStream stream, CounterInputStream counter, WorldContext context) throws IOException {
        this.region("meta", stream, counter, this::readMeta);
        this.region("content", stream, counter, this::readContentHeader);
        try {
            this.region("map", stream, counter, in -> this.readMap((DataInput)in, context));
            this.region("entities", stream, counter, this::readEntities);
        }
        finally {
            Vars.content.setTemporaryMapper(null);
        }
    }

    public final void write(DataOutputStream stream, StringMap extraTags) throws IOException {
        this.region("meta", stream, out -> this.writeMeta((DataOutput)out, extraTags));
        this.region("content", stream, this::writeContentHeader);
        this.region("map", stream, this::writeMap);
        this.region("entities", stream, this::writeEntities);
    }

    public void writeMeta(DataOutput stream, StringMap tags) throws IOException {
        this.writeStringMap(stream, StringMap.of("saved", Time.millis(), "playtime", Vars.headless ? 0L : Vars.control.saves.getTotalPlaytime(), "build", Version.build, "mapname", Vars.world.getMap() == null ? "unknown" : Vars.world.getMap().name(), "wave", Vars.state.wave, "wavetime", Float.valueOf(Vars.state.wavetime), "stats", JsonIO.write(Vars.state.stats), "rules", JsonIO.write(Vars.state.rules), "mods", JsonIO.write(Vars.mods.getModStrings().toArray(String.class)), "width", Vars.world.width(), "height", Vars.world.height()).merge(tags));
    }

    public void readMeta(DataInput stream) throws IOException {
        StringMap map = this.readStringMap(stream);
        Vars.state.wave = map.getInt("wave");
        Vars.state.wavetime = map.getFloat("wavetime", Vars.state.rules.waveSpacing);
        Vars.state.stats = JsonIO.read(Stats.class, map.get("stats", "{}"));
        Vars.state.rules = JsonIO.read(Rules.class, map.get("rules", "{}"));
        if (Vars.state.rules.spawns.isEmpty()) {
            Vars.state.rules.spawns = Vars.defaultWaves.get();
        }
        this.lastReadBuild = map.getInt("build", -1);
        String[] mods = JsonIO.read(String[].class, map.get("mods", "[]"));
        Map worldmap = Vars.maps.byName(map.get("mapname", "\\\\\\"));
        Vars.world.setMap(worldmap == null ? new Map(StringMap.of("name", map.get("mapname", "Unknown"), "width", 1, "height", 1)) : worldmap);
    }

    public void writeMap(DataOutput stream) throws IOException {
        Tile nextTile;
        int j;
        int consecutives;
        Tile tile;
        int i;
        stream.writeShort(Vars.world.width());
        stream.writeShort(Vars.world.height());
        for (i = 0; i < Vars.world.width() * Vars.world.height(); ++i) {
            tile = Vars.world.rawTile(i % Vars.world.width(), i / Vars.world.width());
            stream.writeShort(tile.floorID());
            stream.writeShort(tile.overlayID());
            consecutives = 0;
            for (j = i + 1; j < Vars.world.width() * Vars.world.height() && consecutives < 255 && (nextTile = Vars.world.rawTile(j % Vars.world.width(), j / Vars.world.width())).floorID() == tile.floorID() && nextTile.overlayID() == tile.overlayID(); ++consecutives, ++j) {
            }
            stream.writeByte(consecutives);
            i += consecutives;
        }
        for (i = 0; i < Vars.world.width() * Vars.world.height(); ++i) {
            tile = Vars.world.rawTile(i % Vars.world.width(), i / Vars.world.width());
            stream.writeShort(tile.blockID());
            if (tile.entity != null) {
                this.writeChunk(stream, true, out -> {
                    out.writeByte(tile.entity.version());
                    tile.entity.write((DataOutput)out);
                });
                continue;
            }
            consecutives = 0;
            for (j = i + 1; j < Vars.world.width() * Vars.world.height() && consecutives < 255 && (nextTile = Vars.world.rawTile(j % Vars.world.width(), j / Vars.world.width())).blockID() == tile.blockID(); ++consecutives, ++j) {
            }
            stream.writeByte(consecutives);
            i += consecutives;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMap(DataInput stream, WorldContext context) throws IOException {
        int width = stream.readUnsignedShort();
        int height = stream.readUnsignedShort();
        boolean generating = context.isGenerating();
        if (!generating) {
            context.begin();
        }
        try {
            int newy;
            int newx;
            int j;
            int consecutives;
            int y;
            int x;
            int i;
            context.resize(width, height);
            for (i = 0; i < width * height; ++i) {
                x = i % width;
                y = i / width;
                short floorid = stream.readShort();
                short oreid = stream.readShort();
                consecutives = stream.readUnsignedByte();
                context.create(x, y, floorid, oreid, 0);
                for (j = i + 1; j < i + 1 + consecutives; ++j) {
                    newx = j % width;
                    newy = j / width;
                    context.create(newx, newy, floorid, oreid, 0);
                }
                i += consecutives;
            }
            for (i = 0; i < width * height; ++i) {
                x = i % width;
                y = i / width;
                Block block = Vars.content.block(stream.readShort());
                Tile tile = context.tile(x, y);
                tile.setBlock(block);
                if (tile.entity != null) {
                    try {
                        this.readChunk(stream, true, in -> {
                            byte version = in.readByte();
                            tile.entity.read((DataInput)in, version);
                        });
                        continue;
                    }
                    catch (Exception e) {
                        throw new IOException("Failed to read tile entity of block: " + block, e);
                    }
                }
                consecutives = stream.readUnsignedByte();
                for (j = i + 1; j < i + 1 + consecutives; ++j) {
                    newx = j % width;
                    newy = j / width;
                    context.tile(newx, newy).setBlock(block);
                }
                i += consecutives;
            }
        }
        finally {
            if (!generating) {
                context.end();
            }
        }
    }

    public void writeEntities(DataOutput stream) throws IOException {
        Array<Teams.TeamData> data = Vars.state.teams.getActive();
        stream.writeInt(data.size);
        for (Teams.TeamData team : data) {
            stream.writeInt(team.team.ordinal());
            stream.writeInt(team.brokenBlocks.size);
            for (Teams.BrokenBlock block : team.brokenBlocks) {
                stream.writeShort(block.x);
                stream.writeShort(block.y);
                stream.writeShort(block.rotation);
                stream.writeShort(block.block);
                stream.writeInt(block.config);
            }
        }
        int groups = 0;
        for (EntityGroup<?> group : Vars.entities.all()) {
            if (group.isEmpty() || !(group.all().get(0) instanceof SaveTrait)) continue;
            ++groups;
        }
        stream.writeByte(groups);
        for (EntityGroup<?> group : Vars.entities.all()) {
            if (group.isEmpty() || !(group.all().get(0) instanceof SaveTrait)) continue;
            stream.writeInt(group.size());
            for (Entity entity : group.all()) {
                SaveTrait save = (SaveTrait)entity;
                this.writeChunk(stream, true, out -> {
                    out.writeByte(save.getTypeID().id);
                    out.writeByte(save.version());
                    save.writeSave((DataOutput)out);
                });
            }
        }
    }

    public void readEntities(DataInput stream) throws IOException {
        int teamc = stream.readInt();
        for (int i = 0; i < teamc; ++i) {
            Team team = Team.all[stream.readInt()];
            Teams.TeamData data = Vars.state.teams.get(team);
            int blocks = stream.readInt();
            for (int j = 0; j < blocks; ++j) {
                data.brokenBlocks.addLast(new Teams.BrokenBlock(stream.readShort(), stream.readShort(), stream.readShort(), Vars.content.block((int)stream.readShort()).id, stream.readInt()));
            }
        }
        int groups = stream.readByte();
        for (int i = 0; i < groups; ++i) {
            int amount = stream.readInt();
            for (int j = 0; j < amount; ++j) {
                this.readChunk(stream, true, in -> {
                    byte typeid = in.readByte();
                    byte version = in.readByte();
                    SaveTrait trait = (SaveTrait)((TypeID)Vars.content.getByID((ContentType)ContentType.typeid, (int)typeid)).constructor.get();
                    trait.readSave((DataInput)in, version);
                });
            }
        }
    }

    public void readContentHeader(DataInput stream) throws IOException {
        int mapped = stream.readByte();
        MappableContent[][] map = new MappableContent[ContentType.values().length][0];
        for (int i = 0; i < mapped; ++i) {
            ContentType type = ContentType.values()[stream.readByte()];
            int total = stream.readShort();
            map[type.ordinal()] = new MappableContent[total];
            for (int j = 0; j < total; ++j) {
                String name = stream.readUTF();
                map[type.ordinal()][j] = Vars.content.getByName(type, this.fallback.get(name, name));
            }
        }
        Vars.content.setTemporaryMapper(map);
    }

    public void writeContentHeader(DataOutput stream) throws IOException {
        Array<Content>[] map = Vars.content.getContentMap();
        int mappable = 0;
        for (Array<Content> arr : map) {
            if (arr.size <= 0 || !(arr.first() instanceof MappableContent)) continue;
            ++mappable;
        }
        stream.writeByte(mappable);
        for (Array<Content> arr : map) {
            if (arr.size <= 0 || !(arr.first() instanceof MappableContent)) continue;
            stream.writeByte(arr.first().getContentType().ordinal());
            stream.writeShort(arr.size);
            for (Content c : arr) {
                stream.writeUTF(((MappableContent)c).name);
            }
        }
    }
}

