/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.io;

import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.IntMap;
import io.anuke.arc.collection.StringMap;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.util.io.CounterInputStream;
import io.anuke.arc.util.io.FastDeflaterOutputStream;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.io.SaveMeta;
import io.anuke.mindustry.io.SaveVersion;
import io.anuke.mindustry.io.versions.Save1;
import io.anuke.mindustry.io.versions.Save2;
import io.anuke.mindustry.io.versions.Save3;
import io.anuke.mindustry.world.WorldContext;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.InflaterInputStream;

public class SaveIO {
    public static final byte[] header = new byte[]{77, 83, 65, 86};
    public static final IntMap<SaveVersion> versions = new IntMap();
    public static final Array<SaveVersion> versionArray = Array.with(new Save1(), new Save2(), new Save3());

    public static SaveVersion getSaveWriter() {
        return versionArray.peek();
    }

    public static SaveVersion getSaveWriter(int version) {
        return versions.get(version);
    }

    public static void saveToSlot(int slot) {
        FileHandle file = SaveIO.fileFor(slot);
        boolean exists = file.exists();
        if (exists) {
            file.moveTo(SaveIO.backupFileFor(file));
        }
        try {
            SaveIO.write(SaveIO.fileFor(slot));
        }
        catch (Exception e) {
            if (exists) {
                SaveIO.backupFileFor(file).moveTo(file);
            }
            throw new RuntimeException(e);
        }
    }

    public static void loadFromSlot(int slot) throws SaveException {
        SaveIO.load(SaveIO.fileFor(slot));
    }

    public static DataInputStream getSlotStream(int slot) {
        return new DataInputStream(new InflaterInputStream(SaveIO.fileFor(slot).read(8192)));
    }

    public static DataInputStream getBackupSlotStream(int slot) {
        return new DataInputStream(new InflaterInputStream(SaveIO.backupFileFor(SaveIO.fileFor(slot)).read(8192)));
    }

    public static boolean isSaveValid(int slot) {
        try {
            SaveIO.getMeta(slot);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isSaveValid(FileHandle file) {
        try {
            return SaveIO.isSaveValid(new DataInputStream(new InflaterInputStream(file.read(8192))));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isSaveValid(DataInputStream stream) {
        try {
            SaveIO.getMeta(stream);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static SaveMeta getMeta(int slot) {
        try {
            return SaveIO.getMeta(SaveIO.getSlotStream(slot));
        }
        catch (Exception e) {
            return SaveIO.getMeta(SaveIO.getBackupSlotStream(slot));
        }
    }

    public static SaveMeta getMeta(DataInputStream stream) {
        try {
            SaveIO.readHeader(stream);
            int version = stream.readInt();
            SaveMeta meta = versions.get(version).getMeta(stream);
            stream.close();
            return meta;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static FileHandle fileFor(int slot) {
        return Vars.saveDirectory.child(slot + "." + "msav");
    }

    public static FileHandle backupFileFor(FileHandle file) {
        return file.sibling(file.name() + "-backup." + file.extension());
    }

    public static void write(FileHandle file, StringMap tags) {
        SaveIO.write(new FastDeflaterOutputStream(file.write(false, 8192)), tags);
    }

    public static void write(FileHandle file) {
        SaveIO.write(file, null);
    }

    public static void write(OutputStream os, StringMap tags) {
        try (DataOutputStream stream = new DataOutputStream(os);){
            stream.write(header);
            stream.writeInt(SaveIO.getVersion().version);
            if (tags == null) {
                SaveIO.getVersion().write(stream);
            } else {
                SaveIO.getVersion().write(stream, tags);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void load(FileHandle file) throws SaveException {
        SaveIO.load(file, (WorldContext)Vars.world.context);
    }

    public static void load(FileHandle file, WorldContext context) throws SaveException {
        try {
            SaveIO.load(new InflaterInputStream(file.read(8192)), context);
        }
        catch (SaveException e) {
            e.printStackTrace();
            FileHandle backup = file.sibling(file.name() + "-backup." + file.extension());
            if (backup.exists()) {
                SaveIO.load(new InflaterInputStream(backup.read(8192)), context);
            }
            throw new SaveException(e.getCause());
        }
    }

    public static void load(InputStream is, WorldContext context) throws SaveException {
        try (CounterInputStream counter = new CounterInputStream(is);
             DataInputStream stream = new DataInputStream(counter);){
            Vars.logic.reset();
            SaveIO.readHeader(stream);
            int version = stream.readInt();
            SaveVersion ver = versions.get(version);
            ver.read(stream, counter, context);
        }
        catch (Exception e) {
            throw new SaveException(e);
        }
        finally {
            Vars.content.setTemporaryMapper(null);
        }
    }

    public static SaveVersion getVersion() {
        return versionArray.peek();
    }

    public static void readHeader(DataInput input) throws IOException {
        byte[] bytes = new byte[header.length];
        input.readFully(bytes);
        if (!Arrays.equals(bytes, header)) {
            throw new IOException("Incorrect header! Expecting: " + Arrays.toString(header) + "; Actual: " + Arrays.toString(bytes));
        }
    }

    static {
        for (SaveVersion version : versionArray) {
            versions.put(version.version, version);
        }
    }

    public static class SaveException
    extends RuntimeException {
        public SaveException(Throwable throwable) {
            super(throwable);
        }
    }
}

