/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.io;

import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.collection.StringMap;
import io.anuke.arc.util.io.CounterInputStream;
import io.anuke.arc.util.io.ReusableByteOutStream;
import io.anuke.mindustry.world.WorldContext;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class SaveFileReader {
    protected final ReusableByteOutStream byteOutput = new ReusableByteOutStream();
    protected final DataOutputStream dataBytes = new DataOutputStream(this.byteOutput);
    protected final ReusableByteOutStream byteOutputSmall = new ReusableByteOutStream();
    protected final DataOutputStream dataBytesSmall = new DataOutputStream(this.byteOutputSmall);
    protected final ObjectMap<String, String> fallback = ObjectMap.of(new Object[0]);

    protected void region(String name, DataInput stream, CounterInputStream counter, IORunner<DataInput> cons) throws IOException {
        int length;
        counter.resetCount();
        try {
            length = this.readChunk(stream, cons);
        }
        catch (Throwable e) {
            throw new IOException("Error reading region \"" + name + "\".", e);
        }
        if (length != counter.count() - 4) {
            throw new IOException("Error reading region \"" + name + "\": read length mismatch. Expected: " + length + "; Actual: " + (counter.count() - 4));
        }
    }

    protected void region(String name, DataOutput stream, IORunner<DataOutput> cons) throws IOException {
        try {
            this.writeChunk(stream, cons);
        }
        catch (Throwable e) {
            throw new IOException("Error writing region \"" + name + "\".", e);
        }
    }

    public void writeChunk(DataOutput output, IORunner<DataOutput> runner) throws IOException {
        this.writeChunk(output, false, runner);
    }

    public void writeChunk(DataOutput output, boolean isByte, IORunner<DataOutput> runner) throws IOException {
        ReusableByteOutStream dout = isByte ? this.byteOutputSmall : this.byteOutput;
        dout.reset();
        runner.accept(isByte ? this.dataBytesSmall : this.dataBytes);
        int length = dout.size();
        if (!isByte) {
            output.writeInt(length);
        } else {
            if (length > Short.MAX_VALUE) {
                throw new IOException("Byte write length exceeded: " + length + " > " + Short.MAX_VALUE);
            }
            output.writeShort(length);
        }
        output.write(dout.getBytes(), 0, length);
    }

    public int readChunk(DataInput input, IORunner<DataInput> runner) throws IOException {
        return this.readChunk(input, false, runner);
    }

    public int readChunk(DataInput input, boolean isByte, IORunner<DataInput> runner) throws IOException {
        int length = isByte ? input.readUnsignedShort() : input.readInt();
        runner.accept(input);
        return length;
    }

    public void skipRegion(DataInput input) throws IOException {
        this.skipRegion(input, false);
    }

    public void skipRegion(DataInput input, boolean isByte) throws IOException {
        int skipped;
        int length = this.readChunk(input, isByte, t -> {});
        if (length != (skipped = input.skipBytes(length))) {
            throw new IOException("Could not skip bytes. Expected length: " + length + "; Actual length: " + skipped);
        }
    }

    public void writeStringMap(DataOutput stream, ObjectMap<String, String> map) throws IOException {
        stream.writeShort(map.size);
        for (ObjectMap.Entry entry : map.entries()) {
            stream.writeUTF((String)entry.key);
            stream.writeUTF((String)entry.value);
        }
    }

    public StringMap readStringMap(DataInput stream) throws IOException {
        StringMap map = new StringMap();
        int size = stream.readShort();
        for (int i = 0; i < size; ++i) {
            map.put(stream.readUTF(), stream.readUTF());
        }
        return map;
    }

    public abstract void read(DataInputStream var1, CounterInputStream var2, WorldContext var3) throws IOException;

    public abstract void write(DataOutputStream var1) throws IOException;

    protected static interface IORunner<T> {
        public void accept(T var1) throws IOException;
    }
}

