/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.io;

import io.anuke.arc.util.serialization.Json;
import io.anuke.arc.util.serialization.JsonReader;
import io.anuke.arc.util.serialization.JsonValue;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Items;
import io.anuke.mindustry.ctype.MappableContent;
import io.anuke.mindustry.game.Rules;
import io.anuke.mindustry.game.SpawnGroup;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.type.Zone;
import io.anuke.mindustry.world.Block;
import java.io.IOException;

public class JsonIO {
    private static CustomJson jsonBase = new CustomJson();
    private static Json json = new Json(){
        {
            JsonIO.apply(this);
        }

        @Override
        public void writeValue(Object value, Class knownType, Class elementType) {
            if (value instanceof MappableContent) {
                try {
                    this.getWriter().value(((MappableContent)value).name);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                super.writeValue(value, knownType, elementType);
            }
        }
    };

    public static String write(Object object) {
        return json.toJson(object, object.getClass());
    }

    public static <T> T copy(T object) {
        return (T)JsonIO.read(object.getClass(), JsonIO.write(object));
    }

    public static <T> T read(Class<T> type, String string) {
        return json.fromJson(type, string);
    }

    public static <T> T read(Class<T> type, T base, String string) {
        return jsonBase.fromBaseJson(type, base, string);
    }

    public static String print(String in) {
        return json.prettyPrint(in);
    }

    private static void apply(Json json) {
        json.setIgnoreUnknownFields(true);
        json.setElementType(Rules.class, "spawns", SpawnGroup.class);
        json.setElementType(Rules.class, "loadout", ItemStack.class);
        json.setSerializer(Zone.class, new Json.Serializer<Zone>(){

            @Override
            public void write(Json json, Zone object, Class knownType) {
                json.writeValue(object.name);
            }

            @Override
            public Zone read(Json json, JsonValue jsonData, Class type) {
                return (Zone)Vars.content.getByName(ContentType.zone, jsonData.asString());
            }
        });
        json.setSerializer(Item.class, new Json.Serializer<Item>(){

            @Override
            public void write(Json json, Item object, Class knownType) {
                json.writeValue(object.name);
            }

            @Override
            public Item read(Json json, JsonValue jsonData, Class type) {
                if (jsonData.asString() == null) {
                    return Items.copper;
                }
                Item i = (Item)Vars.content.getByName(ContentType.item, jsonData.asString());
                return i == null ? Items.copper : i;
            }
        });
        json.setSerializer(Block.class, new Json.Serializer<Block>(){

            @Override
            public void write(Json json, Block object, Class knownType) {
                json.writeValue(object.name);
            }

            @Override
            public Block read(Json json, JsonValue jsonData, Class type) {
                return (Block)Vars.content.getByName(ContentType.block, jsonData.asString());
            }
        });
        json.setSerializer(ItemStack.class, new Json.Serializer<ItemStack>(){

            @Override
            public void write(Json json, ItemStack object, Class knownType) {
                json.writeObjectStart();
                json.writeValue("item", object.item);
                json.writeValue("amount", object.amount);
                json.writeObjectEnd();
            }

            @Override
            public ItemStack read(Json json, JsonValue jsonData, Class type) {
                return new ItemStack(json.getSerializer(Item.class).read(json, jsonData.get("item"), Item.class), jsonData.getInt("amount"));
            }
        });
    }

    static class CustomJson
    extends Json {
        private Object baseObject;

        CustomJson() {
            JsonIO.apply(this);
        }

        @Override
        public <T> T fromJson(Class<T> type, String json) {
            return this.fromBaseJson(type, null, json);
        }

        public <T> T fromBaseJson(Class<T> type, T base, String json) {
            this.baseObject = base;
            return this.readValue(type, null, new JsonReader().parse(json));
        }

        @Override
        protected Object newInstance(Class type) {
            if (this.baseObject == null || this.baseObject.getClass() != type) {
                return super.newInstance(type);
            }
            return this.baseObject;
        }
    }
}

