/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.input;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.input.GestureDetector;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.math.Interpolation;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.scene.Group;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.Tmp;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.traits.BuilderTrait;
import io.anuke.mindustry.entities.traits.TargetTrait;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.input.Binding;
import io.anuke.mindustry.input.InputHandler;
import io.anuke.mindustry.input.PlaceMode;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;

public class MobileInput
extends InputHandler
implements GestureDetector.GestureListener {
    private static final float maxPanSpeed = 1.3f;
    private final float edgePan = Scl.scl(60.0f);
    private Vector2 vector = new Vector2();
    private float lastZoom = -1.0f;
    private int lineStartX;
    private int lineStartY;
    private int lastLineX;
    private int lastLineY;
    private float lineScale;
    private float crosshairScale;
    private TargetTrait lastTarget;
    private float shiftDeltaX;
    private float shiftDeltaY;
    private Array<BuilderTrait.BuildRequest> removals = new Array();
    private boolean selecting;
    private boolean lineMode;
    private PlaceMode mode = PlaceMode.none;
    private Block lastBlock;
    private BuilderTrait.BuildRequest lastPlaced;
    private boolean down = false;

    void checkTargets(float x, float y) {
        Unit unit = Units.closestEnemy(Vars.player.getTeam(), x, y, 20.0f, u -> !u.isDead());
        if (unit != null) {
            Vars.player.setMineTile(null);
            Vars.player.target = unit;
        } else {
            Tile tile = Vars.world.ltileWorld(x, y);
            if (tile != null && tile.synthetic() && Vars.state.teams.areEnemies(Vars.player.getTeam(), tile.getTeam())) {
                TileEntity entity = tile.entity;
                Vars.player.setMineTile(null);
                Vars.player.target = entity;
            } else if (tile != null && Vars.player.mech.canHeal && tile.entity != null && tile.getTeam() == Vars.player.getTeam() && tile.entity.damaged()) {
                Vars.player.setMineTile(null);
                Vars.player.target = tile.entity;
            }
        }
    }

    boolean hasRequest(Tile tile) {
        return this.getRequest(tile) != null;
    }

    boolean checkOverlapPlacement(int x, int y, Block block) {
        Tile other;
        r2.setSize(block.size * 8);
        r2.setCenter((float)(x * 8) + block.offset(), (float)(y * 8) + block.offset());
        for (BuilderTrait.BuildRequest req : this.selectRequests) {
            other = req.tile();
            if (other == null || req.breaking) continue;
            r1.setSize(req.block.size * 8);
            r1.setCenter(other.worldx() + req.block.offset(), other.worldy() + req.block.offset());
            if (!r2.overlaps(r1)) continue;
            return true;
        }
        for (BuilderTrait.BuildRequest req : Vars.player.buildQueue()) {
            other = Vars.world.tile(req.x, req.y);
            if (other == null || req.breaking) continue;
            r1.setSize(req.block.size * 8);
            r1.setCenter(other.worldx() + req.block.offset(), other.worldy() + req.block.offset());
            if (!r2.overlaps(r1)) continue;
            return true;
        }
        return false;
    }

    BuilderTrait.BuildRequest getRequest(Tile tile) {
        r2.setSize(8.0f);
        r2.setCenter(tile.worldx(), tile.worldy());
        for (BuilderTrait.BuildRequest req : this.selectRequests) {
            Tile other = req.tile();
            if (other == null) continue;
            if (!req.breaking) {
                r1.setSize(req.block.size * 8);
                r1.setCenter(other.worldx() + req.block.offset(), other.worldy() + req.block.offset());
                if (!r2.overlaps(r1)) continue;
                return req;
            }
            r1.setSize(other.block().size * 8);
            r1.setCenter(other.worldx() + other.block().offset(), other.worldy() + other.block().offset());
            if (!r2.overlaps(r1)) continue;
            return req;
        }
        return null;
    }

    void removeRequest(BuilderTrait.BuildRequest request) {
        this.selectRequests.removeValue(request, true);
        this.removals.add(request);
    }

    boolean isLinePlacing() {
        return this.mode == PlaceMode.placing && this.lineMode && Mathf.dst(this.lineStartX * 8, this.lineStartY * 8, Core.input.mouseWorld().x, Core.input.mouseWorld().y) >= 24.0f;
    }

    boolean isAreaBreaking() {
        return this.mode == PlaceMode.breaking && this.lineMode && Mathf.dst(this.lineStartX * 8, this.lineStartY * 8, Core.input.mouseWorld().x, Core.input.mouseWorld().y) >= 16.0f;
    }

    @Override
    public void buildPlacementUI(Table table) {
        table.addImage().color(Pal.gray).height(4.0f).colspan(4).growX();
        table.row();
        table.left().margin(0.0f).defaults().size(48.0f);
        table.addImageButton((Drawable)Icon.breakSmall, Styles.clearTogglePartiali, () -> {
            this.mode = this.mode == PlaceMode.breaking ? (this.block == null ? PlaceMode.none : PlaceMode.placing) : PlaceMode.breaking;
            this.lastBlock = this.block;
        }).update(l -> l.setChecked(this.mode == PlaceMode.breaking)).name("breakmode");
        table.addImageButton((Drawable)Icon.diagonalSmall, Styles.clearTogglePartiali, () -> {
            Core.settings.put("swapdiagonal", !Core.settings.getBool("swapdiagonal"));
            Core.settings.save();
        }).update(l -> l.setChecked(Core.settings.getBool("swapdiagonal")));
        table.addImageButton((Drawable)Icon.arrowSmall, Styles.clearPartiali, () -> {
            this.rotation = Mathf.mod(this.rotation + 1, 4);
        }).update(i -> i.getImage().setRotationOrigin(this.rotation * 90, 1)).visible(() -> this.block != null && this.block.rotate);
        table.addImageButton((Drawable)Icon.checkSmall, Styles.clearPartiali, () -> {
            for (BuilderTrait.BuildRequest request : this.selectRequests) {
                Tile tile = request.tile();
                if (tile == null) continue;
                if (!request.breaking) {
                    this.rotation = request.rotation;
                    Block before = this.block;
                    this.block = request.block;
                    this.tryPlaceBlock(tile.x, tile.y);
                    this.block = before;
                    continue;
                }
                this.tryBreakBlock(tile.x, tile.y);
            }
            this.removals.addAll(this.selectRequests.select(r -> !r.breaking));
            this.selectRequests.clear();
            this.selecting = false;
        }).visible(() -> !this.selectRequests.isEmpty()).name("confirmplace");
    }

    @Override
    public void buildUI(Group group) {
        group.fill(t -> {
            t.bottom().left().visible(() -> (Vars.player.isBuilding() || this.block != null || this.mode == PlaceMode.breaking || !this.selectRequests.isEmpty()) && !Vars.state.is(GameState.State.menu));
            t.addImageTextButton("$cancel", Icon.cancelSmall, () -> {
                Vars.player.clearBuilding();
                this.selectRequests.clear();
                this.mode = PlaceMode.none;
                this.block = null;
            }).width(155.0f);
        });
    }

    @Override
    public boolean isPlacing() {
        return super.isPlacing() && this.mode == PlaceMode.placing;
    }

    @Override
    public void drawBottom() {
        TargetTrait target;
        Tile tile;
        Lines.stroke(1.0f);
        for (BuilderTrait.BuildRequest request : this.removals) {
            tile = request.tile();
            if (tile == null) continue;
            request.animScale = Mathf.lerpDelta(request.animScale, 0.0f, 0.2f);
            if (request.breaking) {
                this.drawSelected(request.x, request.y, tile.block(), Pal.remove);
                continue;
            }
            request.block.drawRequest(request, this.allRequests(), true);
        }
        for (BuilderTrait.BuildRequest request : this.selectRequests) {
            tile = request.tile();
            if (tile == null) continue;
            request.animScale = !request.breaking && this.validPlace(tile.x, tile.y, request.block, request.rotation) || request.breaking && this.validBreak(tile.x, tile.y) ? Mathf.lerpDelta(request.animScale, 1.0f, 0.2f) : Mathf.lerpDelta(request.animScale, 0.6f, 0.1f);
            Tmp.c1.set(Draw.getMixColor());
            if (!request.breaking && request == this.lastPlaced && request.block != null) {
                Draw.mixcol();
                if (request.block.rotate) {
                    this.drawArrow(request.block, tile.x, tile.y, request.rotation);
                }
            }
            Draw.reset();
            this.drawRequest(request);
            if (request.breaking || request != this.lastPlaced || request.block == null) continue;
            Draw.mixcol();
            request.block.drawPlace(tile.x, tile.y, this.rotation, this.validPlace(tile.x, tile.y, request.block, this.rotation));
        }
        Draw.mixcol();
        Draw.color(Pal.accent);
        if (this.lineMode) {
            int tileX = this.tileX(Core.input.mouseX());
            int tileY = this.tileY(Core.input.mouseY());
            if (this.mode == PlaceMode.placing && this.block != null) {
                for (int i = 0; i < this.lineRequests.size; ++i) {
                    BuilderTrait.BuildRequest req = (BuilderTrait.BuildRequest)this.lineRequests.get(i);
                    if (i == this.lineRequests.size - 1 && req.block.rotate) {
                        this.drawArrow(this.block, req.x, req.y, req.rotation);
                    }
                    this.drawRequest((BuilderTrait.BuildRequest)this.lineRequests.get(i));
                }
            } else if (this.mode == PlaceMode.breaking) {
                this.drawBreakSelection(this.lineStartX, this.lineStartY, tileX, tileY);
            }
        }
        if ((target = Vars.player.target) != null && !Vars.state.isEditor()) {
            if (target != this.lastTarget) {
                this.crosshairScale = 0.0f;
                this.lastTarget = target;
            }
            this.crosshairScale = Mathf.lerpDelta(this.crosshairScale, 1.0f, 0.2f);
            Draw.color(Pal.remove);
            Lines.stroke(1.0f);
            float radius = Interpolation.swingIn.apply(this.crosshairScale);
            Lines.poly(target.getX(), target.getY(), 4, 7.0f * radius, Time.time() * 1.5f);
            Lines.spikes(target.getX(), target.getY(), 3.0f * radius, 6.0f * radius, 4, Time.time() * 1.5f);
        }
        Draw.reset();
    }

    @Override
    protected void drawRequest(BuilderTrait.BuildRequest request) {
        if (request.tile() == null) {
            return;
        }
        this.brequest.animScale = request.animScale = Mathf.lerpDelta(request.animScale, 1.0f, 0.1f);
        if (request.breaking) {
            this.drawSelected(request.x, request.y, request.tile().block(), Pal.remove);
        } else {
            request.block.drawRequest(request, this.allRequests(), this.validPlace(request.x, request.y, request.block, request.rotation));
            this.drawSelected(request.x, request.y, request.block, Pal.accent);
        }
    }

    @Override
    public boolean isBreaking() {
        return this.mode == PlaceMode.breaking;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, KeyCode button) {
        if (Vars.state.is(GameState.State.menu) || Vars.player.isDead()) {
            return false;
        }
        this.down = true;
        Tile cursor = this.tileAt(screenX, screenY);
        float worldx = Core.input.mouseWorld((float)((float)screenX), (float)((float)screenY)).x;
        float worldy = Core.input.mouseWorld((float)((float)screenX), (float)((float)screenY)).y;
        if (cursor == null || Core.scene.hasMouse(screenX, screenY)) {
            return false;
        }
        boolean bl = this.selecting = this.hasRequest(cursor) && this.isPlacing() && this.mode == PlaceMode.placing;
        if (pointer == 0 && !this.selecting && !this.tryTapPlayer(worldx, worldy) && Core.settings.getBool("keyboard")) {
            Vars.player.isShooting = true;
        }
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, KeyCode button) {
        this.lastZoom = Vars.renderer.getScale();
        if (!Core.input.isTouched()) {
            this.down = false;
        }
        if (this.lineMode) {
            int tileX = this.tileX(screenX);
            int tileY = this.tileY(screenY);
            if (this.mode == PlaceMode.placing && this.isPlacing()) {
                this.flushSelectRequests(this.lineRequests);
                Events.fire(new EventType.LineConfirmEvent());
            } else if (this.mode == PlaceMode.breaking) {
                this.removeSelection(this.lineStartX, this.lineStartY, tileX, tileY, true);
            }
            this.lineMode = false;
        } else {
            Tile tile = this.tileAt(screenX, screenY);
            if (tile == null) {
                return false;
            }
            this.tryDropItems(tile.link(), Core.input.mouseWorld((float)((float)screenX), (float)((float)screenY)).x, Core.input.mouseWorld((float)((float)screenX), (float)((float)screenY)).y);
        }
        return false;
    }

    @Override
    public boolean longPress(float x, float y) {
        if (Vars.state.is(GameState.State.menu) || this.mode == PlaceMode.none || Vars.player.isDead()) {
            return false;
        }
        Tile cursor = this.tileAt(x, y);
        if (cursor == null || Core.scene.hasMouse(x, y)) {
            return false;
        }
        this.lineStartX = cursor.x;
        this.lineStartY = cursor.y;
        this.lastLineX = cursor.x;
        this.lastLineY = cursor.y;
        this.lineMode = true;
        if (this.mode == PlaceMode.breaking) {
            Effects.effect(Fx.tapBlock, cursor.worldx(), cursor.worldy(), 1.0f);
        } else if (this.block != null) {
            this.updateLine(this.lineStartX, this.lineStartY, cursor.x, cursor.y);
            Effects.effect(Fx.tapBlock, cursor.worldx() + this.block.offset(), cursor.worldy() + this.block.offset(), (float)this.block.size);
        }
        return false;
    }

    @Override
    public boolean tap(float x, float y, int count, KeyCode button) {
        if (Vars.state.is(GameState.State.menu) || this.lineMode) {
            return false;
        }
        float worldx = Core.input.mouseWorld((float)x, (float)y).x;
        float worldy = Core.input.mouseWorld((float)x, (float)y).y;
        Tile cursor = this.tileAt(x, y);
        if (cursor == null || Core.scene.hasMouse(x, y)) {
            return false;
        }
        this.checkTargets(worldx, worldy);
        if (this.hasRequest(cursor)) {
            this.removeRequest(this.getRequest(cursor));
        } else if (this.mode == PlaceMode.placing && this.isPlacing() && this.validPlace(cursor.x, cursor.y, this.block, this.rotation) && !this.checkOverlapPlacement(cursor.x, cursor.y, this.block)) {
            this.lastPlaced = new BuilderTrait.BuildRequest(cursor.x, cursor.y, this.rotation, this.block);
            this.selectRequests.add(this.lastPlaced);
        } else if (this.mode == PlaceMode.breaking && this.validBreak(cursor.link().x, cursor.link().y) && !this.hasRequest(cursor.link())) {
            cursor = cursor.link();
            this.selectRequests.add(new BuilderTrait.BuildRequest(cursor.x, cursor.y));
        } else if (!this.canTapPlayer(worldx, worldy) && !this.tileTapped(cursor.link())) {
            this.tryBeginMine(cursor);
        }
        return false;
    }

    @Override
    public void update() {
        if (Vars.state.is(GameState.State.menu)) {
            this.selectRequests.clear();
            this.removals.clear();
            this.mode = PlaceMode.none;
        }
        if (Vars.player.isDead()) {
            this.mode = PlaceMode.none;
        }
        if (Math.abs(Core.input.axisTap(Binding.zoom)) > 0.0f && Core.input.keyDown(Binding.zoom_hold)) {
            Vars.renderer.scaleCamera(Core.input.axisTap(Binding.zoom));
        }
        if (!Core.settings.getBool("keyboard")) {
            float camSpeed = 6.0f;
            Core.camera.position.add(Tmp.v1.setZero().add(Core.input.axis(Binding.move_x), Core.input.axis(Binding.move_y)).nor().scl(Time.delta() * camSpeed));
        }
        if (Core.settings.getBool("keyboard")) {
            if (Core.input.keyRelease(Binding.select)) {
                Vars.player.isShooting = false;
            }
            if (Vars.player.isShooting && !this.canShoot()) {
                Vars.player.isShooting = false;
            }
        }
        if (this.mode == PlaceMode.none) {
            this.selecting = false;
            this.lineMode = false;
        }
        if (this.lineMode && this.mode == PlaceMode.placing && this.block == null) {
            this.lineMode = false;
        }
        if (this.block != null && this.mode == PlaceMode.none) {
            this.mode = PlaceMode.placing;
        }
        if (this.block == null && this.mode == PlaceMode.placing) {
            this.mode = PlaceMode.none;
        }
        if (this.lastBlock != this.block && this.mode == PlaceMode.breaking && this.block != null) {
            this.mode = PlaceMode.placing;
            this.lastBlock = this.block;
        }
        if (this.lineMode) {
            this.lineScale = Mathf.lerpDelta(this.lineScale, 1.0f, 0.1f);
            if (Core.input.isTouched(0)) {
                float screenX = Core.input.mouseX();
                float screenY = Core.input.mouseY();
                float panX = 0.0f;
                float panY = 0.0f;
                if (screenX <= this.edgePan) {
                    panX = -(this.edgePan - screenX);
                }
                if (screenX >= (float)Core.graphics.getWidth() - this.edgePan) {
                    panX = screenX - (float)Core.graphics.getWidth() + this.edgePan;
                }
                if (screenY <= this.edgePan) {
                    panY = -(this.edgePan - screenY);
                }
                if (screenY >= (float)Core.graphics.getHeight() - this.edgePan) {
                    panY = screenY - (float)Core.graphics.getHeight() + this.edgePan;
                }
                this.vector.set(panX, panY).scl(Core.camera.width / (float)Core.graphics.getWidth());
                this.vector.limit(1.3f);
                Core.camera.position.x += this.vector.x;
                Core.camera.position.y += this.vector.y;
            }
            int lx = this.tileX(Core.input.mouseX());
            int ly = this.tileY(Core.input.mouseY());
            if ((this.lastLineX != lx || this.lastLineY != ly) && this.isPlacing()) {
                this.lastLineX = lx;
                this.lastLineY = ly;
                this.updateLine(this.lineStartX, this.lineStartY, lx, ly);
            }
        } else {
            this.lineRequests.clear();
            this.lineScale = 0.0f;
        }
        for (int i = this.removals.size - 1; i >= 0; --i) {
            BuilderTrait.BuildRequest request = this.removals.get(i);
            if (!(request.animScale <= 1.0E-4f)) continue;
            this.removals.remove(i);
            --i;
        }
    }

    @Override
    public boolean pan(float x, float y, float deltaX, float deltaY) {
        if (Core.scene.hasDialog() || Core.settings.getBool("keyboard")) {
            return false;
        }
        float scale = Core.camera.width / (float)Core.graphics.getWidth();
        deltaX *= scale;
        deltaY *= scale;
        if (this.lineMode && !Core.input.isTouched(1) || this.droppingItem) {
            return false;
        }
        if (!this.down) {
            return false;
        }
        if (this.selecting) {
            this.shiftDeltaX += deltaX;
            this.shiftDeltaY += deltaY;
            int shiftedX = (int)(this.shiftDeltaX / 8.0f);
            int shiftedY = (int)(this.shiftDeltaY / 8.0f);
            if (Math.abs(shiftedX) > 0 || Math.abs(shiftedY) > 0) {
                for (BuilderTrait.BuildRequest req : this.selectRequests) {
                    if (req.breaking) continue;
                    req.x += shiftedX;
                    req.y += shiftedY;
                }
                this.shiftDeltaX %= 8.0f;
                this.shiftDeltaY %= 8.0f;
            }
        } else {
            Core.camera.position.x -= deltaX;
            Core.camera.position.y -= deltaY;
        }
        return false;
    }

    @Override
    public boolean panStop(float x, float y, int pointer, KeyCode button) {
        this.shiftDeltaY = 0.0f;
        this.shiftDeltaX = 0.0f;
        return false;
    }

    @Override
    public boolean zoom(float initialDistance, float distance) {
        if (Core.settings.getBool("keyboard")) {
            return false;
        }
        if (this.lastZoom < 0.0f) {
            this.lastZoom = Vars.renderer.getScale();
        }
        Vars.renderer.setScale(distance / initialDistance * this.lastZoom);
        return true;
    }
}

