/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.input;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.Eachable;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.input.GestureDetector;
import io.anuke.arc.input.InputProcessor;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Point2;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.scene.Group;
import io.anuke.arc.scene.event.Touchable;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.scene.ui.layout.WidgetGroup;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.Tmp;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.effect.ItemTransfer;
import io.anuke.mindustry.entities.traits.BuilderTrait;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Schematic;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.game.Teams;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.input.Binding;
import io.anuke.mindustry.input.PlaceUtils;
import io.anuke.mindustry.net.ValidateException;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.ui.fragments.OverlayFragment;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Build;
import io.anuke.mindustry.world.Pos;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.BuildBlock;
import java.util.Iterator;

public abstract class InputHandler
implements InputProcessor,
GestureDetector.GestureListener {
    static final float playerSelectRange = Vars.mobile ? 17.0f : 11.0f;
    static final int maxLength = 100;
    static final Vector2 stackTrns = new Vector2();
    static final Rectangle r1 = new Rectangle();
    static final Rectangle r2 = new Rectangle();
    static final float backTrns = 3.0f;
    public final OverlayFragment frag = new OverlayFragment();
    public Block block;
    public boolean overrideLineRotation;
    public int rotation;
    public boolean droppingItem;
    public Group uiGroup;
    @ArcAnnotate.Nullable
    protected Schematic lastSchematic;
    protected GestureDetector detector;
    protected PlaceLine line = new PlaceLine();
    protected BuilderTrait.BuildRequest resultreq;
    protected BuilderTrait.BuildRequest brequest = new BuilderTrait.BuildRequest();
    protected Array<BuilderTrait.BuildRequest> lineRequests = new Array();
    protected Array<BuilderTrait.BuildRequest> selectRequests = new Array();

    public static void dropItem(Player player, float angle) {
        if (Vars.net.server() && player.item().amount <= 0) {
            throw new ValidateException(player, "Player cannot drop an item.");
        }
        Effects.effect(Fx.dropItem, Color.white, player.x, player.y, angle, player.item().item);
        player.clearItem();
    }

    public static void rotateBlock(Player player, Tile tile, boolean direction) {
        if (Vars.net.server() && !Units.canInteract(player, tile)) {
            throw new ValidateException(player, "Player cannot drop an item.");
        }
        tile.rotation(Mathf.mod(tile.rotation() + Mathf.sign(direction), 4));
        if (tile.entity != null) {
            tile.entity.updateProximity();
            tile.entity.noSleep();
        }
    }

    public static void transferInventory(Player player, Tile tile) {
        if (player == null || player.timer == null || !player.timer.get(4, 40.0f)) {
            return;
        }
        if (Vars.net.server() && (player.item().amount <= 0 || player.isTransferring || !Units.canInteract(player, tile))) {
            throw new ValidateException(player, "Player cannot transfer an item.");
        }
        if (tile.entity == null) {
            return;
        }
        player.isTransferring = true;
        Item item = player.item().item;
        int amount = player.item().amount;
        int accepted = tile.block().acceptStack(item, amount, tile, player);
        player.item().amount -= accepted;
        int sent = Mathf.clamp(accepted / 4, 1, 8);
        int removed = accepted / sent;
        int[] remaining = new int[]{accepted, accepted};
        Block block = tile.block();
        Core.app.post(() -> Events.fire(new EventType.DepositEvent(tile, player)));
        for (int i = 0; i < sent; ++i) {
            boolean end = i == sent - 1;
            Time.run(i * 3, () -> {
                tile.block().getStackOffset(item, tile, stackTrns);
                ItemTransfer.create(item, player.x + Angles.trnsx(player.rotation + 180.0f, 3.0f), player.y + Angles.trnsy(player.rotation + 180.0f, 3.0f), new Vector2(tile.drawx() + InputHandler.stackTrns.x, tile.drawy() + InputHandler.stackTrns.y), () -> {
                    if (tile.block() != block || tile.entity == null || tile.entity.items == null) {
                        return;
                    }
                    tile.block().handleStack(item, removed, tile, player);
                    remaining[1] = remaining[1] - removed;
                    if (end && remaining[1] > 0) {
                        tile.block().handleStack(item, remaining[1], tile, player);
                    }
                });
                remaining[0] = remaining[0] - removed;
                if (end) {
                    player.isTransferring = false;
                }
            });
        }
    }

    public static void onTileTapped(Player player, Tile tile) {
        if (tile == null || player == null) {
            return;
        }
        if (!Units.canInteract(player, tile)) {
            return;
        }
        tile.block().tapped(tile, player);
    }

    public static void onTileConfig(Player player, Tile tile, int value) {
        if (tile == null || !Units.canInteract(player, tile)) {
            return;
        }
        tile.block().configured(tile, player, value);
    }

    public Eachable<BuilderTrait.BuildRequest> allRequests() {
        return cons -> {
            for (BuilderTrait.BuildRequest request : Vars.player.buildQueue()) {
                cons.accept(request);
            }
            for (BuilderTrait.BuildRequest request : this.selectRequests) {
                cons.accept(request);
            }
            for (BuilderTrait.BuildRequest request : this.lineRequests) {
                cons.accept(request);
            }
        };
    }

    public OverlayFragment getFrag() {
        return this.frag;
    }

    public void update() {
    }

    public float getMouseX() {
        return Core.input.mouseX();
    }

    public float getMouseY() {
        return Core.input.mouseY();
    }

    public void buildPlacementUI(Table table) {
    }

    public void buildUI(Group group) {
    }

    public void updateState() {
    }

    public void drawBottom() {
    }

    public void drawTop() {
    }

    public void drawSelected(int x, int y, Block block, Color color) {
        Draw.color(color);
        for (int i = 0; i < 4; ++i) {
            Point2 p = Geometry.d8edge[i];
            float offset = (float)(-Math.max(block.size - 1, 0)) / 2.0f * 8.0f;
            Draw.rect("block-select", (float)(x * 8) + block.offset() + offset * (float)p.x, (float)(y * 8) + block.offset() + offset * (float)p.y, (float)(i * 90));
        }
        Draw.reset();
    }

    public void drawBreaking(BuilderTrait.BuildRequest request) {
        if (request.breaking) {
            this.drawBreaking(request.x, request.y);
        } else {
            this.drawSelected(request.x, request.y, request.block, Pal.remove);
        }
    }

    public boolean requestMatches(BuilderTrait.BuildRequest request) {
        Tile tile = Vars.world.tile(request.x, request.y);
        return tile != null && tile.block() instanceof BuildBlock && ((BuildBlock.BuildEntity)tile.entity()).cblock == request.block;
    }

    public void drawBreaking(int x, int y) {
        Tile tile = Vars.world.ltile(x, y);
        if (tile == null) {
            return;
        }
        Block block = tile.block();
        this.drawSelected(x, y, block, Pal.remove);
    }

    public void useSchematic(Schematic schem) {
        this.selectRequests.addAll(Vars.schematics.toRequests(schem, Vars.world.toTile(Vars.player.x), Vars.world.toTile(Vars.player.y)));
    }

    public void rotateRequests(Array<BuilderTrait.BuildRequest> requests, int direction) {
        int ox = this.rawTileX();
        int oy = this.rawTileY();
        requests.each(req -> {
            if (req.block.posConfig) {
                int cx = Pos.x(req.config) - req.originalX;
                int cy = Pos.y(req.config) - req.originalY;
                int lx = cx;
                if (direction >= 0) {
                    cx = -cy;
                    cy = lx;
                } else {
                    cx = cy;
                    cy = -lx;
                }
                req.config = Pos.get(cx + req.originalX, cy + req.originalY);
            }
            float wx = (float)((req.x - ox) * 8) + req.block.offset();
            float wy = (float)((req.y - oy) * 8) + req.block.offset();
            float x = wx;
            if (direction >= 0) {
                wx = -wy;
                wy = x;
            } else {
                wx = wy;
                wy = -x;
            }
            req.x = Vars.world.toTile(wx - req.block.offset()) + ox;
            req.y = Vars.world.toTile(wy - req.block.offset()) + oy;
            req.rotation = Mathf.mod(req.rotation + direction, 4);
        });
    }

    public void flipRequests(Array<BuilderTrait.BuildRequest> requests, boolean x) {
        int origin = (x ? this.rawTileX() : this.rawTileY()) * 8;
        requests.each(req -> {
            float value = -((float)((x ? req.x : req.y) * 8 - origin) + req.block.offset()) + (float)origin;
            if (x) {
                req.x = (int)((value - req.block.offset()) / 8.0f);
            } else {
                req.y = (int)((value - req.block.offset()) / 8.0f);
            }
            if (req.block.posConfig) {
                int corigin = x ? req.originalWidth / 2 : req.originalHeight / 2;
                int nvalue = -((x ? Pos.x(req.config) : Pos.y(req.config)) - corigin) + corigin;
                if (x) {
                    req.originalX = -(req.originalX - corigin) + corigin;
                    req.config = Pos.get(nvalue, Pos.y(req.config));
                } else {
                    req.originalY = -(req.originalY - corigin) + corigin;
                    req.config = Pos.get(Pos.x(req.config), nvalue);
                }
            }
            if (x == (req.rotation % 2 == 0)) {
                req.rotation = Mathf.mod(req.rotation + 2, 4);
            }
        });
    }

    protected BuilderTrait.BuildRequest getRequest(int x, int y) {
        return this.getRequest(x, y, 1, null);
    }

    protected BuilderTrait.BuildRequest getRequest(int x, int y, int size, BuilderTrait.BuildRequest skip) {
        float offset = (float)((size + 1) % 2 * 8) / 2.0f;
        r2.setSize(8 * size);
        r2.setCenter((float)(x * 8) + offset, (float)(y * 8) + offset);
        this.resultreq = null;
        Predicate<BuilderTrait.BuildRequest> test = req -> {
            if (req == skip) {
                return false;
            }
            Tile other = req.tile();
            if (other == null) {
                return false;
            }
            if (!req.breaking) {
                r1.setSize(req.block.size * 8);
                r1.setCenter(other.worldx() + req.block.offset(), other.worldy() + req.block.offset());
            } else {
                r1.setSize(other.block().size * 8);
                r1.setCenter(other.worldx() + other.block().offset(), other.worldy() + other.block().offset());
            }
            return r2.overlaps(r1);
        };
        for (BuilderTrait.BuildRequest req2 : Vars.player.buildQueue()) {
            if (!test.test(req2)) continue;
            return req2;
        }
        for (BuilderTrait.BuildRequest req2 : this.selectRequests) {
            if (!test.test(req2)) continue;
            return req2;
        }
        return null;
    }

    protected void drawBreakSelection(int x1, int y1, int x2, int y2) {
        PlaceUtils.NormalizeDrawResult result = PlaceUtils.normalizeDrawArea(Blocks.air, x1, y1, x2, y2, false, 100, 1.0f);
        PlaceUtils.NormalizeResult dresult = PlaceUtils.normalizeArea(x1, y1, x2, y2, this.rotation, false, 100);
        for (int x = dresult.x; x <= dresult.x2; ++x) {
            for (int y = dresult.y; y <= dresult.y2; ++y) {
                Tile tile = Vars.world.ltile(x, y);
                if (tile == null || !this.validBreak(tile.x, tile.y)) continue;
                this.drawBreaking(tile.x, tile.y);
            }
        }
        Tmp.r1.set(result.x, result.y, result.x2 - result.x, result.y2 - result.y);
        Draw.color(Pal.remove);
        Lines.stroke(1.0f);
        for (BuilderTrait.BuildRequest req : Vars.player.buildQueue()) {
            if (req.breaking || !req.bounds(Tmp.r2).overlaps(Tmp.r1)) continue;
            this.drawBreaking(req);
        }
        for (Teams.BrokenBlock req : Vars.state.teams.get((Team)Vars.player.getTeam()).brokenBlocks) {
            Block block = Vars.content.block(req.block);
            if (!block.bounds(req.x, req.y, Tmp.r2).overlaps(Tmp.r1)) continue;
            this.drawSelected(req.x, req.y, Vars.content.block(req.block), Pal.remove);
        }
        Lines.stroke(2.0f);
        Draw.color(Pal.removeBack);
        Lines.rect(result.x, result.y - 1.0f, result.x2 - result.x, result.y2 - result.y);
        Draw.color(Pal.remove);
        Lines.rect(result.x, result.y, result.x2 - result.x, result.y2 - result.y);
    }

    protected void drawSelection(int x1, int y1, int x2, int y2, int maxLength) {
        PlaceUtils.NormalizeDrawResult result = PlaceUtils.normalizeDrawArea(Blocks.air, x1, y1, x2, y2, false, maxLength, 1.0f);
        Lines.stroke(2.0f);
        Draw.color(Pal.accentBack);
        Lines.rect(result.x, result.y - 1.0f, result.x2 - result.x, result.y2 - result.y);
        Draw.color(Pal.accent);
        Lines.rect(result.x, result.y, result.x2 - result.x, result.y2 - result.y);
    }

    protected void flushSelectRequests(Array<BuilderTrait.BuildRequest> requests) {
        for (BuilderTrait.BuildRequest req : requests) {
            if (req.block == null || !this.validPlace(req.x, req.y, req.block, req.rotation)) continue;
            BuilderTrait.BuildRequest other = this.getRequest(req.x, req.y);
            if (other != null) {
                this.selectRequests.remove(other);
            }
            this.selectRequests.add(req.copy());
        }
    }

    protected void flushRequests(Array<BuilderTrait.BuildRequest> requests) {
        for (BuilderTrait.BuildRequest req : requests) {
            if (req.block == null || !this.validPlace(req.x, req.y, req.block, req.rotation)) continue;
            BuilderTrait.BuildRequest copy = req.copy();
            if (copy.hasConfig && copy.block.posConfig) {
                copy.config = Pos.get(Pos.x(copy.config) + copy.x - copy.originalX, Pos.y(copy.config) + copy.y - copy.originalY);
            }
            Vars.player.addBuildRequest(copy);
        }
    }

    protected void drawRequest(BuilderTrait.BuildRequest request) {
        this.drawRequest(request.x, request.y, request.block, request.rotation);
    }

    protected void drawRequest(int x, int y, Block block, int rotation) {
        this.brequest.set(x, y, rotation, block);
        this.brequest.animScale = 1.0f;
        block.drawRequest(this.brequest, this.allRequests(), this.validPlace(x, y, block, rotation));
    }

    protected void removeSelection(int x1, int y1, int x2, int y2) {
        this.removeSelection(x1, y1, x2, y2, false);
    }

    protected void removeSelection(int x1, int y1, int x2, int y2, boolean flush) {
        PlaceUtils.NormalizeResult result = PlaceUtils.normalizeArea(x1, y1, x2, y2, this.rotation, false, 100);
        for (int x = 0; x <= Math.abs(result.x2 - result.x); ++x) {
            for (int y = 0; y <= Math.abs(result.y2 - result.y); ++y) {
                int wy;
                int wx = x1 + x * Mathf.sign(x2 - x1);
                Tile tile = Vars.world.ltile(wx, wy = y1 + y * Mathf.sign(y2 - y1));
                if (tile == null) continue;
                if (!flush) {
                    this.tryBreakBlock(wx, wy);
                    continue;
                }
                if (!this.validBreak(tile.x, tile.y) || this.selectRequests.contains((BuilderTrait.BuildRequest)((Object)((Predicate<BuilderTrait.BuildRequest>)r -> r.tile() != null && r.tile().link() == tile)))) continue;
                this.selectRequests.add(new BuilderTrait.BuildRequest(tile.x, tile.y));
            }
        }
        Tmp.r1.set(result.x * 8, result.y * 8, (result.x2 - result.x) * 8, (result.y2 - result.y) * 8);
        Iterator<BuilderTrait.BuildRequest> it = Vars.player.buildQueue().iterator();
        while (it.hasNext()) {
            BuilderTrait.BuildRequest req = it.next();
            if (req.breaking || !req.bounds(Tmp.r2).overlaps(Tmp.r1)) continue;
            it.remove();
        }
        Iterator<Teams.BrokenBlock> broken = Vars.state.teams.get((Team)Vars.player.getTeam()).brokenBlocks.iterator();
        while (broken.hasNext()) {
            Teams.BrokenBlock req = broken.next();
            Block block = Vars.content.block(req.block);
            if (!block.bounds(req.x, req.y, Tmp.r2).overlaps(Tmp.r1)) continue;
            broken.remove();
        }
    }

    protected void updateLine(int x1, int y1, int x2, int y2) {
        this.lineRequests.clear();
        this.iterateLine(x1, y1, x2, y2, l -> {
            this.rotation = l.rotation;
            BuilderTrait.BuildRequest req = new BuilderTrait.BuildRequest(l.x, l.y, l.rotation, this.block);
            req.animScale = 1.0f;
            this.lineRequests.add(req);
        });
    }

    protected void updateLine(int x1, int y1) {
        this.updateLine(x1, y1, this.tileX(this.getMouseX()), this.tileY(this.getMouseY()));
    }

    boolean tileTapped(Tile tile) {
        tile = tile.link();
        boolean consumed = false;
        boolean showedInventory = false;
        if (tile.block().configurable && tile.interactable(Vars.player.getTeam())) {
            consumed = true;
            if (!this.frag.config.isShown() && tile.block().shouldShowConfigure(tile, Vars.player) || this.frag.config.isShown() && this.frag.config.getSelectedTile().block().onConfigureTileTapped(this.frag.config.getSelectedTile(), tile)) {
                Sounds.click.at(tile);
                this.frag.config.showConfig(tile);
            }
        } else if (!this.frag.config.hasConfigMouse()) {
            if (this.frag.config.isShown() && this.frag.config.getSelectedTile().block().onConfigureTileTapped(this.frag.config.getSelectedTile(), tile)) {
                consumed = true;
                this.frag.config.hideConfig();
            }
            if (this.frag.config.isShown()) {
                consumed = true;
            }
        }
        if (!consumed && tile.interactable(Vars.player.getTeam())) {
            Call.onTileTapped(Vars.player, tile);
        }
        if (tile.interactable(Vars.player.getTeam()) && tile.block().consumesTap) {
            consumed = true;
        } else if (tile.interactable(Vars.player.getTeam()) && tile.block().synthetic() && !consumed && tile.block().hasItems && tile.entity.items.total() > 0) {
            this.frag.inv.showFor(tile);
            consumed = true;
            showedInventory = true;
        }
        if (!showedInventory) {
            this.frag.inv.hide();
        }
        return consumed;
    }

    boolean tryTapPlayer(float x, float y) {
        if (this.canTapPlayer(x, y)) {
            this.droppingItem = true;
            return true;
        }
        return false;
    }

    boolean canTapPlayer(float x, float y) {
        return Mathf.dst(x, y, Vars.player.x, Vars.player.y) <= playerSelectRange && Vars.player.item().amount > 0;
    }

    boolean tryBeginMine(Tile tile) {
        if (this.canMine(tile)) {
            Vars.player.setMineTile(Vars.player.getMineTile() == tile ? null : tile);
            return true;
        }
        return false;
    }

    boolean canMine(Tile tile) {
        return !Core.scene.hasMouse() && tile.drop() != null && tile.drop().hardness <= Vars.player.mech.drillPower && (!tile.floor().playerUnmineable || tile.overlay().itemDrop != null) && Vars.player.acceptsItem(tile.drop()) && tile.block() == Blocks.air && Vars.player.dst(tile.worldx(), tile.worldy()) <= 70.0f;
    }

    Tile tileAt(float x, float y) {
        return Vars.world.tile(this.tileX(x), this.tileY(y));
    }

    int rawTileX() {
        return Vars.world.toTile(Core.input.mouseWorld().x);
    }

    int rawTileY() {
        return Vars.world.toTile(Core.input.mouseWorld().y);
    }

    int tileX(float cursorX) {
        Vector2 vec = Core.input.mouseWorld(cursorX, 0.0f);
        if (this.selectedBlock()) {
            vec.sub(this.block.offset(), this.block.offset());
        }
        return Vars.world.toTile(vec.x);
    }

    int tileY(float cursorY) {
        Vector2 vec = Core.input.mouseWorld(0.0f, cursorY);
        if (this.selectedBlock()) {
            vec.sub(this.block.offset(), this.block.offset());
        }
        return Vars.world.toTile(vec.y);
    }

    public boolean selectedBlock() {
        return this.isPlacing();
    }

    public boolean isPlacing() {
        return this.block != null;
    }

    public boolean isBreaking() {
        return false;
    }

    public float mouseAngle(float x, float y) {
        return Core.input.mouseWorld(this.getMouseX(), this.getMouseY()).sub(x, y).angle();
    }

    public void remove() {
        Table table;
        Core.input.removeProcessor(this);
        this.frag.remove();
        if (Core.scene != null && (table = (Table)Core.scene.find("inputTable")) != null) {
            table.clear();
        }
        if (this.detector != null) {
            Core.input.removeProcessor(this.detector);
        }
        if (this.uiGroup != null) {
            this.uiGroup.remove();
            this.uiGroup = null;
        }
    }

    public void add() {
        this.detector = new GestureDetector(20.0f, 0.5f, 0.4f, 0.15f, this);
        Core.input.addProcessor(this.detector);
        Core.input.addProcessor(this);
        if (Core.scene != null) {
            Table table = (Table)Core.scene.find("inputTable");
            if (table != null) {
                table.clear();
                this.buildPlacementUI(table);
            }
            this.uiGroup = new WidgetGroup();
            this.uiGroup.touchable(Touchable.childrenOnly);
            this.uiGroup.setFillParent(true);
            Vars.ui.hudGroup.addChild(this.uiGroup);
            this.buildUI(this.uiGroup);
            this.frag.add();
        }
        if (Vars.player != null) {
            Vars.player.isBuilding = true;
        }
    }

    public boolean canShoot() {
        return this.block == null && !Core.scene.hasMouse() && !this.onConfigurable() && !this.isDroppingItem();
    }

    public boolean onConfigurable() {
        return false;
    }

    public boolean isDroppingItem() {
        return this.droppingItem;
    }

    public void tryDropItems(Tile tile, float x, float y) {
        if (!this.droppingItem || Vars.player.item().amount <= 0 || this.canTapPlayer(x, y) || Vars.state.isPaused() || !Vars.player.timer.check(4, 40.0f)) {
            this.droppingItem = false;
            return;
        }
        this.droppingItem = false;
        ItemStack stack = Vars.player.item();
        if (tile.block().acceptStack(stack.item, stack.amount, tile, Vars.player) > 0 && tile.interactable(Vars.player.getTeam()) && tile.block().hasItems && Vars.player.item().amount > 0 && !Vars.player.isTransferring && tile.interactable(Vars.player.getTeam())) {
            Call.transferInventory(Vars.player, tile);
        } else {
            Call.dropItem(Vars.player.angleTo(x, y));
        }
    }

    public void tryPlaceBlock(int x, int y) {
        if (this.block != null && this.validPlace(x, y, this.block, this.rotation)) {
            this.placeBlock(x, y, this.block, this.rotation);
        }
    }

    public void tryBreakBlock(int x, int y) {
        if (this.validBreak(x, y)) {
            this.breakBlock(x, y);
        }
    }

    public boolean validPlace(int x, int y, Block type, int rotation) {
        return this.validPlace(x, y, type, rotation, null);
    }

    public boolean validPlace(int x, int y, Block type, int rotation, BuilderTrait.BuildRequest ignore) {
        for (BuilderTrait.BuildRequest req : Vars.player.buildQueue()) {
            if (req == ignore || req.breaking || !req.block.bounds(req.x, req.y, Tmp.r1).overlaps(type.bounds(x, y, Tmp.r2)) || type.canReplace(req.block) && Tmp.r1.equals(Tmp.r2)) continue;
            return false;
        }
        return Build.validPlace(Vars.player.getTeam(), x, y, type, rotation);
    }

    public boolean validBreak(int x, int y) {
        return Build.validBreak(Vars.player.getTeam(), x, y);
    }

    public void placeBlock(int x, int y, Block block, int rotation) {
        BuilderTrait.BuildRequest req = this.getRequest(x, y);
        if (req != null) {
            Vars.player.buildQueue().remove(req);
        }
        Vars.player.addBuildRequest(new BuilderTrait.BuildRequest(x, y, rotation, block));
    }

    public void breakBlock(int x, int y) {
        Tile tile = Vars.world.ltile(x, y);
        Vars.player.addBuildRequest(new BuilderTrait.BuildRequest(tile.x, tile.y));
    }

    public void drawArrow(Block block, int x, int y, int rotation) {
        this.drawArrow(block, x, y, rotation, this.validPlace(x, y, block, rotation));
    }

    public void drawArrow(Block block, int x, int y, int rotation, boolean valid) {
        Draw.color(!valid ? Pal.removeBack : Pal.accentBack);
        Draw.rect(Core.atlas.find("place-arrow"), (float)(x * 8) + block.offset(), (float)(y * 8) + block.offset() - 1.0f, (float)Core.atlas.find("place-arrow").getWidth() * Draw.scl, (float)Core.atlas.find("place-arrow").getHeight() * Draw.scl, (float)(rotation * 90 - 90));
        Draw.color(!valid ? Pal.remove : Pal.accent);
        Draw.rect(Core.atlas.find("place-arrow"), (float)(x * 8) + block.offset(), (float)(y * 8) + block.offset(), (float)Core.atlas.find("place-arrow").getWidth() * Draw.scl, (float)Core.atlas.find("place-arrow").getHeight() * Draw.scl, (float)(rotation * 90 - 90));
    }

    void iterateLine(int startX, int startY, int endX, int endY, Consumer<PlaceLine> cons) {
        boolean diagonal = Core.input.keyDown(Binding.diagonal_placement);
        if (Core.settings.getBool("swapdiagonal")) {
            diagonal = !diagonal;
        }
        Array<Point2> points = diagonal ? PlaceUtils.normalizeDiagonal(startX, startY, endX, endY) : PlaceUtils.normalizeLine(startX, startY, endX, endY);
        float angle = Angles.angle(startX, startY, endX, endY);
        int baseRotation = this.rotation;
        if (!this.overrideLineRotation || diagonal) {
            baseRotation = startX == endX && startY == endY ? this.rotation : (int)((angle + 45.0f) / 90.0f) % 4;
        }
        Tmp.r3.set(-1.0f, -1.0f, 0.0f, 0.0f);
        for (int i = 0; i < points.size; ++i) {
            Point2 point = points.get(i);
            if (this.block != null && Tmp.r2.setSize(this.block.size * 8).setCenter((float)(point.x * 8) + this.block.offset(), (float)(point.y * 8) + this.block.offset()).overlaps(Tmp.r3)) continue;
            Point2 next = i == points.size - 1 ? null : points.get(i + 1);
            this.line.x = point.x;
            this.line.y = point.y;
            this.line.rotation = !this.overrideLineRotation || diagonal ? (next != null ? (int)Tile.relativeTo(point.x, point.y, next.x, next.y) : baseRotation) : this.rotation;
            this.line.last = next == null;
            cons.accept(this.line);
            Tmp.r3.setSize(this.block.size * 8).setCenter((float)(point.x * 8) + this.block.offset(), (float)(point.y * 8) + this.block.offset());
        }
    }

    class PlaceLine {
        public int x;
        public int y;
        public int rotation;
        public boolean last;

        PlaceLine() {
        }
    }
}

