/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.input;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.Graphics;
import io.anuke.arc.KeyBinds;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.scene.Group;
import io.anuke.arc.scene.event.Touchable;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.ui.TextField;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.entities.traits.BuilderTrait;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Schematic;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.input.Binding;
import io.anuke.mindustry.input.InputHandler;
import io.anuke.mindustry.input.PlaceMode;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.world.Tile;

public class DesktopInput
extends InputHandler {
    private Graphics.Cursor cursorType = Graphics.Cursor.SystemCursor.arrow;
    private int selectX;
    private int selectY;
    private int schemX;
    private int schemY;
    private int lastLineX;
    private int lastLineY;
    private int schematicX;
    private int schematicY;
    private PlaceMode mode;
    private float selectScale;
    @ArcAnnotate.Nullable
    private BuilderTrait.BuildRequest sreq;
    private boolean deleting = false;

    @Override
    public void buildUI(Group group) {
        group.fill(t -> {
            t.bottom().update(() -> {
                t.getColor().a = Mathf.lerpDelta(t.getColor().a, Vars.player.isBuilding() ? 1.0f : 0.0f, 0.15f);
            });
            t.visible(() -> Core.settings.getBool("hints") && this.selectRequests.isEmpty());
            t.touchable(() -> t.getColor().a < 0.1f ? Touchable.disabled : Touchable.childrenOnly);
            t.table(Styles.black6, b -> {
                b.defaults().left();
                b.label(() -> Core.bundle.format(!Vars.player.isBuilding ? "resumebuilding" : "pausebuilding", Core.keybinds.get((KeyBinds.KeyBind)Binding.pause_building).key.name())).style(Styles.outlineLabel);
                b.row();
                b.add(Core.bundle.format("cancelbuilding", Core.keybinds.get((KeyBinds.KeyBind)Binding.clear_building).key.name())).style(Styles.outlineLabel);
                b.row();
                b.add(Core.bundle.format("selectschematic", Core.keybinds.get((KeyBinds.KeyBind)Binding.schematic_select).key.name())).style(Styles.outlineLabel);
            }).margin(10.0f);
        });
        group.fill(t -> {
            t.visible(() -> this.lastSchematic != null && !this.selectRequests.isEmpty());
            t.bottom();
            t.table(Styles.black6, b -> {
                b.defaults().left();
                b.add(Core.bundle.format("schematic.flip", Core.keybinds.get((KeyBinds.KeyBind)Binding.schematic_flip_x).key.name(), Core.keybinds.get((KeyBinds.KeyBind)Binding.schematic_flip_y).key.name())).style(Styles.outlineLabel);
                b.row();
                b.table(a -> a.addImageTextButton("$schematic.add", Icon.saveSmall, () -> Vars.ui.showTextInput("$schematic.add", "$name", "", text -> {
                    Schematic replacement = Vars.schematics.all().find(s -> s.name().equals(text));
                    if (replacement != null) {
                        Vars.ui.showConfirm("$confirm", "$schematic.replace", () -> {
                            Vars.schematics.overwrite(replacement, this.lastSchematic);
                            Vars.ui.showInfoFade("$schematic.saved");
                            Vars.ui.schematics.showInfo(replacement);
                        });
                    } else {
                        this.lastSchematic.tags.put("name", text);
                        Vars.schematics.add(this.lastSchematic);
                        Vars.ui.showInfoFade("$schematic.saved");
                        Vars.ui.schematics.showInfo(this.lastSchematic);
                    }
                })).colspan(2).size(250.0f, 50.0f).disabled(f -> this.lastSchematic == null || this.lastSchematic.file != null));
            }).margin(6.0f);
        });
    }

    @Override
    public void drawTop() {
        BuilderTrait.BuildRequest req;
        Lines.stroke(1.0f);
        int cursorX = this.tileX(Core.input.mouseX());
        int cursorY = this.tileY(Core.input.mouseY());
        if (this.mode == PlaceMode.placing && this.block != null) {
            for (int i = 0; i < this.lineRequests.size; ++i) {
                BuilderTrait.BuildRequest req2 = (BuilderTrait.BuildRequest)this.lineRequests.get(i);
                if (i == this.lineRequests.size - 1 && req2.block.rotate) {
                    this.drawArrow(this.block, req2.x, req2.y, req2.rotation);
                }
                this.drawRequest((BuilderTrait.BuildRequest)this.lineRequests.get(i));
            }
        } else if (this.mode == PlaceMode.breaking) {
            this.drawBreakSelection(this.selectX, this.selectY, cursorX, cursorY);
        } else if (this.isPlacing()) {
            if (this.block.rotate) {
                this.drawArrow(this.block, cursorX, cursorY, this.rotation);
            }
            Draw.color();
            this.drawRequest(cursorX, cursorY, this.block, this.rotation);
            this.block.drawPlace(cursorX, cursorY, this.rotation, this.validPlace(cursorX, cursorY, this.block, this.rotation));
        }
        if (this.mode == PlaceMode.none && !this.isPlacing() && (req = this.getRequest(cursorX, cursorY)) != null) {
            this.drawSelected(req.x, req.y, req.breaking ? req.tile().block() : req.block, Pal.accent);
        }
        for (BuilderTrait.BuildRequest request : this.selectRequests) {
            request.animScale = 1.0f;
            this.drawRequest(request);
        }
        if (this.sreq != null) {
            boolean valid = this.validPlace(this.sreq.x, this.sreq.y, this.sreq.block, this.sreq.rotation, this.sreq);
            if (this.sreq.block.rotate) {
                this.drawArrow(this.sreq.block, this.sreq.x, this.sreq.y, this.sreq.rotation, valid);
            }
            this.sreq.block.drawRequest(this.sreq, this.allRequests(), valid);
            this.drawSelected(this.sreq.x, this.sreq.y, this.sreq.block, this.getRequest(this.sreq.x, this.sreq.y, this.sreq.block.size, this.sreq) != null ? Pal.remove : Pal.accent);
        }
        if (Core.input.keyDown(Binding.schematic_select)) {
            this.drawSelection(this.schemX, this.schemY, cursorX, cursorY, 32);
        }
        Draw.reset();
    }

    @Override
    public void update() {
        Tile cursor;
        if (Vars.net.active() && Core.input.keyTap(Binding.player_list)) {
            Vars.ui.listfrag.toggle();
        }
        if (Core.input.keyRelease(Binding.select)) {
            Vars.player.isShooting = false;
        }
        if (!(Vars.state.is(GameState.State.menu) || !Core.input.keyTap(Binding.minimap) || Core.scene.getKeyboardFocus() != Vars.ui.minimap && Core.scene.hasDialog() || Vars.ui.chatfrag.chatOpen() || Core.scene.getKeyboardFocus() instanceof TextField)) {
            if (!Vars.ui.minimap.isShown()) {
                Vars.ui.minimap.show();
            } else {
                Vars.ui.minimap.hide();
            }
        }
        if (Vars.state.is(GameState.State.menu) || Core.scene.hasDialog()) {
            return;
        }
        if (Math.abs(Core.input.axisTap(Binding.zoom)) > 0.0f && Core.input.keyDown(Binding.zoom_hold)) {
            Vars.renderer.scaleCamera(Core.input.axisTap(Binding.zoom));
        }
        if (Vars.player.isDead()) {
            this.cursorType = Graphics.Cursor.SystemCursor.arrow;
            return;
        }
        this.pollInput();
        if (!this.isPlacing() && this.mode == PlaceMode.placing) {
            this.mode = PlaceMode.none;
        }
        if (this.mode != PlaceMode.none || this.isPlacing()) {
            this.selectRequests.clear();
            this.lastSchematic = null;
        }
        if (Vars.player.isShooting && !this.canShoot()) {
            Vars.player.isShooting = false;
        }
        if (this.isPlacing()) {
            this.cursorType = Graphics.Cursor.SystemCursor.hand;
            this.selectScale = Mathf.lerpDelta(this.selectScale, 1.0f, 0.2f);
        } else {
            this.selectScale = 0.0f;
        }
        this.rotation = Mathf.mod(this.rotation + (int)Core.input.axisTap(Binding.rotate), 4);
        if (this.sreq != null) {
            this.sreq.rotation = Mathf.mod(this.sreq.rotation + (int)Core.input.axisTap(Binding.rotate), 4);
        }
        if (!Core.input.keyDown(Binding.zoom_hold) && Math.abs((int)Core.input.axisTap(Binding.rotate)) > 0) {
            if (this.isPlacing() && this.mode == PlaceMode.placing) {
                this.updateLine(this.selectX, this.selectY);
            } else if (!this.selectRequests.isEmpty()) {
                this.rotateRequests(this.selectRequests, (int)Core.input.axisTap(Binding.rotate));
            }
        }
        if ((cursor = this.tileAt(Core.input.mouseX(), Core.input.mouseY())) != null) {
            cursor = cursor.link();
            this.cursorType = cursor.block().getCursor(cursor);
            if (this.isPlacing() || !this.selectRequests.isEmpty()) {
                this.cursorType = Graphics.Cursor.SystemCursor.hand;
            }
            if (!this.isPlacing() && this.canMine(cursor)) {
                this.cursorType = Vars.ui.drillCursor;
            }
            if (this.getRequest(cursor.x, cursor.y) != null && this.mode == PlaceMode.none) {
                this.cursorType = Graphics.Cursor.SystemCursor.hand;
            }
            if (this.canTapPlayer(Core.input.mouseWorld().x, Core.input.mouseWorld().y)) {
                this.cursorType = Vars.ui.unloadCursor;
            }
            if (!this.isPlacing() && Math.abs(Core.input.axisTap(Binding.rotate)) > 0.0f && Core.input.keyDown(Binding.rotateplaced) && cursor.block().rotate) {
                Call.rotateBlock(Vars.player, cursor, Core.input.axisTap(Binding.rotate) > 0.0f);
            }
        }
        if (!Core.scene.hasMouse()) {
            Core.graphics.cursor(this.cursorType);
        }
        this.cursorType = Graphics.Cursor.SystemCursor.arrow;
    }

    @Override
    public void useSchematic(Schematic schem) {
        this.block = null;
        this.schematicX = this.tileX(this.getMouseX());
        this.schematicY = this.tileY(this.getMouseY());
        this.selectRequests.clear();
        this.selectRequests.addAll(Vars.schematics.toRequests(schem, this.schematicX, this.schematicY));
        this.mode = PlaceMode.none;
    }

    @Override
    public boolean isBreaking() {
        return this.mode == PlaceMode.breaking;
    }

    @Override
    public void buildPlacementUI(Table table) {
        table.addImage().color(Pal.gray).height(4.0f).colspan(4).growX();
        table.row();
        table.left().margin(0.0f).defaults().size(48.0f).left();
        table.addImageButton((Drawable)Icon.wikiSmall, Styles.clearPartiali, () -> Vars.ui.schematics.show());
    }

    void pollInput() {
        if (Core.scene.getKeyboardFocus() instanceof TextField) {
            return;
        }
        Tile selected = this.tileAt(Core.input.mouseX(), Core.input.mouseY());
        int cursorX = this.tileX(Core.input.mouseX());
        int cursorY = this.tileY(Core.input.mouseY());
        int rawCursorX = Vars.world.toTile(Core.input.mouseWorld().x);
        int rawCursorY = Vars.world.toTile(Core.input.mouseWorld().y);
        if (!this.selectRequests.isEmpty()) {
            int shiftX = rawCursorX - this.schematicX;
            int shiftY = rawCursorY - this.schematicY;
            this.selectRequests.each(s -> {
                s.x += shiftX;
                s.y += shiftY;
            });
            this.schematicX += shiftX;
            this.schematicY += shiftY;
        }
        if (Core.input.keyTap(Binding.deselect)) {
            Vars.player.setMineTile(null);
        }
        if (Core.input.keyTap(Binding.clear_building)) {
            Vars.player.clearBuilding();
        }
        if (Core.input.keyTap(Binding.schematic_select) && !Vars.ui.chatfrag.chatOpen()) {
            this.schemX = rawCursorX;
            this.schemY = rawCursorY;
        }
        if (Core.input.keyTap(Binding.schematic_menu) && !Vars.ui.chatfrag.chatOpen()) {
            if (Vars.ui.schematics.isShown()) {
                Vars.ui.schematics.hide();
            } else {
                Vars.ui.schematics.show();
            }
        }
        if (Core.input.keyTap(Binding.clear_building)) {
            this.lastSchematic = null;
            this.selectRequests.clear();
        }
        if (Core.input.keyRelease(Binding.schematic_select)) {
            this.lastSchematic = Vars.schematics.create(this.schemX, this.schemY, rawCursorX, rawCursorY);
            this.useSchematic(this.lastSchematic);
            if (this.selectRequests.isEmpty()) {
                this.lastSchematic = null;
            }
        }
        if (!this.selectRequests.isEmpty()) {
            if (Core.input.keyTap(Binding.schematic_flip_x)) {
                this.flipRequests(this.selectRequests, true);
            }
            if (Core.input.keyTap(Binding.schematic_flip_y)) {
                this.flipRequests(this.selectRequests, false);
            }
        }
        if (this.sreq != null) {
            float offset = (float)((this.sreq.block.size + 2) % 2 * 8) / 2.0f;
            float x = Core.input.mouseWorld().x + offset;
            float y = Core.input.mouseWorld().y + offset;
            this.sreq.x = (int)(x / 8.0f);
            this.sreq.y = (int)(y / 8.0f);
        }
        if (this.block == null || this.mode != PlaceMode.placing) {
            this.lineRequests.clear();
        }
        if (Core.input.keyTap(Binding.pause_building)) {
            boolean bl = Vars.player.isBuilding = !Vars.player.isBuilding;
        }
        if ((cursorX != this.lastLineX || cursorY != this.lastLineY) && this.isPlacing() && this.mode == PlaceMode.placing) {
            this.updateLine(this.selectX, this.selectY);
            this.lastLineX = cursorX;
            this.lastLineY = cursorY;
        }
        if (Core.input.keyTap(Binding.select) && !Core.scene.hasMouse()) {
            BuilderTrait.BuildRequest req = this.getRequest(cursorX, cursorY);
            if (!this.selectRequests.isEmpty()) {
                this.flushRequests(this.selectRequests);
            } else if (this.isPlacing()) {
                this.selectX = cursorX;
                this.selectY = cursorY;
                this.lastLineX = cursorX;
                this.lastLineY = cursorY;
                this.mode = PlaceMode.placing;
                this.updateLine(this.selectX, this.selectY);
            } else if (req != null && !req.breaking && this.mode == PlaceMode.none && !req.initialized) {
                this.sreq = req;
            } else if (req != null && req.breaking) {
                this.deleting = true;
            } else if (selected != null) {
                if (!(this.tileTapped(selected) || this.tryTapPlayer(Core.input.mouseWorld().x, Core.input.mouseWorld().y) || Vars.player.buildQueue().size != 0 || this.droppingItem || this.tryBeginMine(selected) || Vars.player.getMineTile() != null || Vars.ui.chatfrag.chatOpen())) {
                    Vars.player.isShooting = true;
                }
            } else if (!Vars.ui.chatfrag.chatOpen()) {
                Vars.player.isShooting = true;
            }
        } else if (Core.input.keyTap(Binding.deselect) && this.block != null) {
            this.block = null;
            this.mode = PlaceMode.none;
        } else if (Core.input.keyTap(Binding.break_block) && !Core.scene.hasMouse()) {
            this.deleting = false;
            this.mode = PlaceMode.breaking;
            this.selectX = this.tileX(Core.input.mouseX());
            this.selectY = this.tileY(Core.input.mouseY());
        }
        if (Core.input.keyDown(Binding.select) && this.mode == PlaceMode.none && !this.isPlacing() && this.deleting) {
            BuilderTrait.BuildRequest req = this.getRequest(cursorX, cursorY);
            if (req != null && req.breaking) {
                Vars.player.buildQueue().remove(req);
            }
        } else {
            this.deleting = false;
        }
        if (this.mode == PlaceMode.placing && this.block != null) {
            if (!(this.overrideLineRotation || Core.input.keyDown(Binding.diagonal_placement) || this.selectX == cursorX && this.selectY == cursorY || (int)Core.input.axisTap(Binding.rotate) == 0)) {
                this.rotation = (int)((Angles.angle(this.selectX, this.selectY, cursorX, cursorY) + 45.0f) / 90.0f) % 4;
                this.overrideLineRotation = true;
            }
        } else {
            this.overrideLineRotation = false;
        }
        if (Core.input.keyRelease(Binding.break_block) || Core.input.keyRelease(Binding.select)) {
            if (this.mode == PlaceMode.placing && this.block != null) {
                this.flushRequests(this.lineRequests);
                this.lineRequests.clear();
                Events.fire(new EventType.LineConfirmEvent());
            } else if (this.mode == PlaceMode.breaking) {
                this.removeSelection(this.selectX, this.selectY, cursorX, cursorY);
            }
            if (selected != null) {
                this.tryDropItems(selected.link(), Core.input.mouseWorld().x, Core.input.mouseWorld().y);
            }
            if (this.sreq != null) {
                if (this.getRequest(this.sreq.x, this.sreq.y, this.sreq.block.size, this.sreq) != null) {
                    Vars.player.buildQueue().remove(this.sreq, true);
                }
                this.sreq = null;
            }
            this.mode = PlaceMode.none;
        }
    }

    @Override
    public boolean selectedBlock() {
        return this.isPlacing() && this.mode != PlaceMode.breaking;
    }

    @Override
    public float getMouseX() {
        return Core.input.mouseX();
    }

    @Override
    public float getMouseY() {
        return Core.input.mouseY();
    }

    @Override
    public void updateState() {
        if (Vars.state.is(GameState.State.menu)) {
            this.droppingItem = false;
            this.mode = PlaceMode.none;
            this.block = null;
            this.sreq = null;
            this.selectRequests.clear();
        }
    }
}

