/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.graphics;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.graphics.glutils.Shader;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.arc.util.Time;

public class Shaders {
    public static Shadow shadow;
    public static BlockBuild blockbuild;
    @ArcAnnotate.Nullable
    public static Shield shield;
    public static UnitBuild build;
    public static FogShader fog;
    public static MenuShader menu;
    public static SurfaceShader water;
    public static SurfaceShader tar;

    public static void init() {
        shadow = new Shadow();
        blockbuild = new BlockBuild();
        try {
            shield = new Shield();
        }
        catch (Throwable t) {
            shield = null;
            t.printStackTrace();
        }
        build = new UnitBuild();
        fog = new FogShader();
        menu = new MenuShader();
        water = new SurfaceShader("water");
        tar = new SurfaceShader("tar");
    }

    public static class LoadShader
    extends Shader {
        public LoadShader(String frag, String vert) {
            super(Core.files.internal("shaders/" + vert + ".vertex.glsl"), Core.files.internal("shaders/" + frag + ".fragment.glsl"));
        }
    }

    public static class SurfaceShader
    extends LoadShader {
        public SurfaceShader(String frag) {
            super(frag, "default");
        }

        @Override
        public void apply() {
            this.setUniformf("camerapos", Core.camera.position.x - Core.camera.width / 2.0f, Core.camera.position.y - Core.camera.height / 2.0f);
            this.setUniformf("screensize", Core.camera.width, Core.camera.height);
            this.setUniformf("time", Time.time());
        }
    }

    public static class Shield
    extends LoadShader {
        public Shield() {
            super("shield", "default");
        }

        @Override
        public void apply() {
            this.setUniformf("u_dp", Scl.scl(1.0f));
            this.setUniformf("u_time", Time.time() / Scl.scl(1.0f));
            this.setUniformf("u_offset", Core.camera.position.x - Core.camera.width / 2.0f, Core.camera.position.y - Core.camera.height / 2.0f);
            this.setUniformf("u_texsize", Core.camera.width, Core.camera.height);
        }
    }

    public static class BlockBuild
    extends LoadShader {
        public Color color = new Color();
        public float progress;
        public TextureRegion region = new TextureRegion();

        public BlockBuild() {
            super("blockbuild", "default");
        }

        @Override
        public void apply() {
            this.setUniformf("u_progress", this.progress);
            this.setUniformf("u_color", this.color);
            this.setUniformf("u_uv", this.region.getU(), this.region.getV());
            this.setUniformf("u_uv2", this.region.getU2(), this.region.getV2());
            this.setUniformf("u_time", Time.time());
            this.setUniformf("u_texsize", (float)this.region.getTexture().getWidth(), (float)this.region.getTexture().getHeight());
        }
    }

    public static class Shadow
    extends LoadShader {
        public Color color = new Color();
        public TextureRegion region = new TextureRegion();
        public float scl;

        public Shadow() {
            super("shadow", "default");
        }

        @Override
        public void apply() {
            this.setUniformf("u_color", this.color);
            this.setUniformf("u_scl", this.scl);
            this.setUniformf("u_texsize", (float)this.region.getTexture().getWidth(), (float)this.region.getTexture().getHeight());
        }
    }

    public static class UnitBuild
    extends LoadShader {
        public float progress;
        public float time;
        public Color color = new Color();
        public TextureRegion region;

        public UnitBuild() {
            super("unitbuild", "default");
        }

        @Override
        public void apply() {
            this.setUniformf("u_time", this.time);
            this.setUniformf("u_color", this.color);
            this.setUniformf("u_progress", this.progress);
            this.setUniformf("u_uv", this.region.getU(), this.region.getV());
            this.setUniformf("u_uv2", this.region.getU2(), this.region.getV2());
            this.setUniformf("u_texsize", (float)this.region.getTexture().getWidth(), (float)this.region.getTexture().getHeight());
        }
    }

    public static class FogShader
    extends LoadShader {
        public FogShader() {
            super("fog", "default");
        }
    }

    public static class MenuShader
    extends LoadShader {
        float time = 0.0f;

        public MenuShader() {
            super("menu", "default");
        }

        @Override
        public void apply() {
            this.time %= 158.0f;
            this.setUniformf("u_resolution", (float)Core.graphics.getWidth(), (float)Core.graphics.getHeight());
            this.setUniformi("u_time", (int)(this.time += Core.graphics.getDeltaTime() * 60.0f));
            this.setUniformf("u_uv", Core.atlas.white().getU(), Core.atlas.white().getV());
            this.setUniformf("u_scl", Scl.scl(1.0f));
            this.setUniformf("u_uv2", Core.atlas.white().getU2(), Core.atlas.white().getV2());
        }
    }
}

