/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.graphics;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.Blending;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.glutils.FrameBuffer;
import io.anuke.arc.util.Disposable;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.type.Player;

public class Pixelator
implements Disposable {
    private FrameBuffer buffer = new FrameBuffer(2, 2);

    public Pixelator() {
        ((Texture)this.buffer.getTexture()).setFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest);
    }

    public void drawPixelate() {
        float pre = Vars.renderer.getScale();
        float scale = Vars.renderer.getScale();
        scale = (int)scale;
        Vars.renderer.setScale(scale);
        Core.camera.width = (int)Core.camera.width;
        Core.camera.height = (int)Core.camera.height;
        boolean hadShields = Core.settings.getBool("animatedshields");
        boolean hadWater = Core.settings.getBool("animatedwater");
        Core.settings.put("animatedwater", false);
        Core.settings.put("animatedshields", false);
        Core.graphics.clear(0.0f, 0.0f, 0.0f, 1.0f);
        float px = Core.camera.position.x;
        float py = Core.camera.position.y;
        Core.camera.position.set((float)((int)px) + ((int)Core.camera.width % 2 == 0 ? 0.0f : 0.5f), (float)((int)py) + ((int)Core.camera.height % 2 == 0 ? 0.0f : 0.5f));
        int w = (int)(Core.camera.width * Vars.renderer.landScale());
        int h = (int)(Core.camera.height * Vars.renderer.landScale());
        if (!(Core.graphics.isHidden() || this.buffer.getWidth() == w && this.buffer.getHeight() == h)) {
            this.buffer.resize(w, h);
        }
        Draw.flush();
        this.buffer.begin();
        Vars.renderer.draw();
        Draw.flush();
        this.buffer.end();
        Draw.blend(Blending.disabled);
        Draw.rect(Draw.wrap((Texture)this.buffer.getTexture()), Core.camera.position.x, Core.camera.position.y, Core.camera.width, -Core.camera.height);
        Draw.blend();
        Vars.playerGroup.draw(p -> !p.isDead(), Player::drawName);
        Core.camera.position.set(px, py);
        Core.settings.put("animatedwater", hadWater);
        Core.settings.put("animatedshields", hadShields);
        Vars.renderer.setScale(pre);
    }

    public void rebind() {
        if (this.enabled()) {
            this.buffer.begin();
        }
    }

    public boolean enabled() {
        return Core.settings.getBool("pixelate");
    }

    @Override
    public void dispose() {
        this.buffer.dispose();
    }
}

