/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.graphics;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.glutils.Shader;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.graphics.Shaders;

public enum CacheLayer {
    water{

        @Override
        public void begin() {
            this.beginShader();
        }

        @Override
        public void end() {
            this.endShader(Shaders.water);
        }
    }
    ,
    tar{

        @Override
        public void begin() {
            this.beginShader();
        }

        @Override
        public void end() {
            this.endShader(Shaders.tar);
        }
    }
    ,
    normal,
    walls;


    public void begin() {
    }

    public void end() {
    }

    void beginShader() {
        if (!Core.settings.getBool("animatedwater")) {
            return;
        }
        Vars.renderer.blocks.floor.endc();
        Vars.renderer.shieldBuffer.begin();
        Core.graphics.clear(Color.clear);
        Vars.renderer.blocks.floor.beginc();
    }

    void endShader(Shader shader) {
        if (!Core.settings.getBool("animatedwater")) {
            return;
        }
        Vars.renderer.blocks.floor.endc();
        Vars.renderer.shieldBuffer.end();
        Draw.shader(shader);
        Draw.rect(Draw.wrap((Texture)Vars.renderer.shieldBuffer.getTexture()), Core.camera.position.x, Core.camera.position.y, Core.camera.width, -Core.camera.height);
        Draw.shader();
        Vars.renderer.blocks.floor.beginc();
    }
}

