/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.graphics;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.Mesh;
import io.anuke.arc.graphics.Pixmap;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.VertexAttribute;
import io.anuke.arc.graphics.glutils.FrameBuffer;
import io.anuke.arc.graphics.glutils.Shader;

public class Bloom {
    public static boolean useAlphaChannelAsMask = false;
    public int blurPasses = 1;
    private Shader tresholdShader;
    private Shader bloomShader;
    private Mesh fullScreenQuad;
    private Texture pingPongTex1;
    private Texture pingPongTex2;
    private Texture original;
    private FrameBuffer frameBuffer;
    private FrameBuffer pingPongBuffer1;
    private FrameBuffer pingPongBuffer2;
    private Shader blurShader;
    private float bloomIntensity;
    private float originalIntensity;
    private float threshold;
    private int w;
    private int h;
    private boolean blending = false;
    private boolean capturing = false;
    private float r = 0.0f;
    private float g = 0.0f;
    private float b = 0.0f;
    private float a = 1.0f;
    private boolean disposeFBO = true;

    public void resume() {
        this.bloomShader.begin();
        this.bloomShader.setUniformi("u_texture0", 0);
        this.bloomShader.setUniformi("u_texture1", 1);
        this.bloomShader.end();
        this.setSize(this.w, this.h);
        this.setThreshold(this.threshold);
        this.setBloomIntesity(this.bloomIntensity);
        this.setOriginalIntesity(this.originalIntensity);
        this.original = (Texture)this.frameBuffer.getTexture();
        this.pingPongTex1 = (Texture)this.pingPongBuffer1.getTexture();
        this.pingPongTex2 = (Texture)this.pingPongBuffer2.getTexture();
    }

    public Bloom() {
        this.initialize(Core.graphics.getWidth() / 4, Core.graphics.getHeight() / 4, null, false, false, true);
    }

    public Bloom(boolean useBlending) {
        this.initialize(Core.graphics.getWidth() / 4, Core.graphics.getHeight() / 4, null, false, useBlending, true);
    }

    public Bloom(int FBO_W, int FBO_H, boolean hasDepth, boolean useBlending, boolean use32bitFBO) {
        this.initialize(FBO_W, FBO_H, null, hasDepth, useBlending, use32bitFBO);
    }

    public Bloom(int FBO_W, int FBO_H, FrameBuffer sceneIsCapturedHere, boolean useBlending, boolean use32bitFBO) {
        this.initialize(FBO_W, FBO_H, sceneIsCapturedHere, false, useBlending, use32bitFBO);
        this.disposeFBO = false;
    }

    private void initialize(int FBO_W, int FBO_H, FrameBuffer fbo, boolean hasDepth, boolean useBlending, boolean use32bitFBO) {
        this.blending = useBlending;
        Pixmap.Format format = null;
        format = use32bitFBO ? (useBlending ? Pixmap.Format.RGBA8888 : Pixmap.Format.RGB888) : (useBlending ? Pixmap.Format.RGBA4444 : Pixmap.Format.RGB565);
        this.frameBuffer = fbo == null ? new FrameBuffer(format, Core.graphics.getWidth(), Core.graphics.getHeight(), hasDepth) : fbo;
        this.pingPongBuffer1 = new FrameBuffer(format, FBO_W, FBO_H, false);
        this.pingPongBuffer2 = new FrameBuffer(format, FBO_W, FBO_H, false);
        this.original = (Texture)this.frameBuffer.getTexture();
        this.pingPongTex1 = (Texture)this.pingPongBuffer1.getTexture();
        this.pingPongTex2 = (Texture)this.pingPongBuffer2.getTexture();
        this.fullScreenQuad = Bloom.createFullScreenQuad();
        String alpha = useBlending ? "alpha_" : "";
        this.bloomShader = Bloom.createShader("screenspace", alpha + "bloom");
        this.tresholdShader = useAlphaChannelAsMask ? Bloom.createShader("screenspace", "maskedtreshold") : Bloom.createShader("screenspace", alpha + "threshold");
        this.blurShader = Bloom.createShader("blurspace", alpha + "gaussian");
        this.setSize(FBO_W, FBO_H);
        this.setBloomIntesity(2.5f);
        this.setOriginalIntesity(0.8f);
        this.setThreshold(0.5f);
        this.bloomShader.begin();
        this.bloomShader.setUniformi("u_texture0", 0);
        this.bloomShader.setUniformi("u_texture1", 1);
        this.bloomShader.end();
    }

    public void setClearColor(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public void capture() {
        if (!this.capturing) {
            this.capturing = true;
            this.frameBuffer.begin();
            Core.gl.glClearColor(this.r, this.g, this.b, this.a);
            Core.gl.glClear(16384);
        }
    }

    public void capturePause() {
        if (this.capturing) {
            this.capturing = false;
            this.frameBuffer.end();
        }
    }

    public void captureContinue() {
        if (!this.capturing) {
            this.capturing = true;
            this.frameBuffer.begin();
        }
    }

    public void render() {
        if (this.capturing) {
            this.capturing = false;
            this.frameBuffer.end();
        }
        Core.gl.glDisable(3042);
        Core.gl.glDisable(2929);
        Core.gl.glDepthMask(false);
        this.gaussianBlur();
        if (this.blending) {
            Core.gl.glEnable(3042);
            Core.gl.glBlendFunc(770, 771);
        }
        this.pingPongTex1.bind(1);
        this.original.bind(0);
        this.bloomShader.begin();
        this.fullScreenQuad.render(this.bloomShader, 6);
        this.bloomShader.end();
    }

    private void gaussianBlur() {
        this.original.bind(0);
        this.pingPongBuffer1.begin();
        this.tresholdShader.begin();
        this.fullScreenQuad.render(this.tresholdShader, 6, 0, 4);
        this.tresholdShader.end();
        this.pingPongBuffer1.end();
        for (int i = 0; i < this.blurPasses; ++i) {
            this.pingPongTex1.bind(0);
            this.pingPongBuffer2.begin();
            this.blurShader.begin();
            this.blurShader.setUniformf("dir", 1.0f, 0.0f);
            this.fullScreenQuad.render(this.blurShader, 6, 0, 4);
            this.blurShader.end();
            this.pingPongBuffer2.end();
            this.pingPongTex2.bind(0);
            this.pingPongBuffer1.begin();
            this.blurShader.begin();
            this.blurShader.setUniformf("dir", 0.0f, 1.0f);
            this.fullScreenQuad.render(this.blurShader, 6, 0, 4);
            this.blurShader.end();
            this.pingPongBuffer1.end();
        }
    }

    public void setBloomIntesity(float intensity) {
        this.bloomIntensity = intensity;
        this.bloomShader.begin();
        this.bloomShader.setUniformf("BloomIntensity", intensity);
        this.bloomShader.end();
    }

    public void setOriginalIntesity(float intensity) {
        this.originalIntensity = intensity;
        this.bloomShader.begin();
        this.bloomShader.setUniformf("OriginalIntensity", intensity);
        this.bloomShader.end();
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
        this.tresholdShader.begin();
        this.tresholdShader.setUniformf("threshold", threshold, 1.0f / (1.0f - threshold));
        this.tresholdShader.end();
    }

    private void setSize(int FBO_W, int FBO_H) {
        this.w = FBO_W;
        this.h = FBO_H;
        this.blurShader.begin();
        this.blurShader.setUniformf("size", (float)FBO_W, (float)FBO_H);
        this.blurShader.end();
    }

    public void dispose() {
        try {
            if (this.disposeFBO) {
                this.frameBuffer.dispose();
            }
            this.fullScreenQuad.dispose();
            this.pingPongBuffer1.dispose();
            this.pingPongBuffer2.dispose();
            this.blurShader.dispose();
            this.bloomShader.dispose();
            this.tresholdShader.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Mesh createFullScreenQuad() {
        float[] verts = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 0.0f, 1.0f};
        Mesh tmpMesh = new Mesh(true, 4, 0, new VertexAttribute(1, 2, "a_position"), new VertexAttribute(16, 2, "a_texCoord0"));
        tmpMesh.setVertices(verts);
        return tmpMesh;
    }

    private static Shader createShader(String vertexName, String fragmentName) {
        String vertexShader = Core.files.internal("bloomshaders/" + vertexName + ".vertex.glsl").readString();
        String fragmentShader = Core.files.internal("bloomshaders/" + fragmentName + ".fragment.glsl").readString();
        return new Shader(vertexShader, fragmentShader);
    }
}

