/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.graphics;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.Sort;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.graphics.glutils.FrameBuffer;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Disposable;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.Tmp;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.game.Teams;
import io.anuke.mindustry.graphics.CacheLayer;
import io.anuke.mindustry.graphics.FloorRenderer;
import io.anuke.mindustry.graphics.Layer;
import io.anuke.mindustry.graphics.Shaders;
import io.anuke.mindustry.ui.Cicon;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;

public class BlockRenderer
implements Disposable {
    private static final int initialRequests = 1024;
    private static final int expandr = 9;
    private static final Color shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.71f);
    public final FloorRenderer floor = new FloorRenderer();
    private Array<BlockRequest> requests = new Array(true, 1024, BlockRequest.class);
    private int lastCamX;
    private int lastCamY;
    private int lastRangeX;
    private int lastRangeY;
    private int requestidx = 0;
    private int iterateidx = 0;
    private float brokenFade = 0.0f;
    private FrameBuffer shadows = new FrameBuffer(2, 2);
    private FrameBuffer fog = new FrameBuffer(2, 2);
    private Array<Tile> outArray = new Array();
    private Array<Tile> shadowEvents = new Array();

    public BlockRenderer() {
        for (int i = 0; i < this.requests.size; ++i) {
            this.requests.set(i, new BlockRequest());
        }
        Events.on(EventType.WorldLoadEvent.class, event -> {
            Tile tile;
            int y;
            int x;
            this.shadowEvents.clear();
            this.lastCamX = -99;
            this.lastCamY = -99;
            ((Texture)this.shadows.getTexture()).setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            this.shadows.resize(Vars.world.width(), Vars.world.height());
            this.shadows.begin();
            Core.graphics.clear(Color.white);
            Draw.proj().setOrtho(0.0f, 0.0f, this.shadows.getWidth(), this.shadows.getHeight());
            Draw.color(shadowColor);
            for (x = 0; x < Vars.world.width(); ++x) {
                for (y = 0; y < Vars.world.height(); ++y) {
                    tile = Vars.world.rawTile(x, y);
                    if (!tile.block().hasShadow) continue;
                    Fill.rect((float)tile.x + 0.5f, (float)tile.y + 0.5f, 1.0f, 1.0f);
                }
            }
            Draw.flush();
            Draw.color();
            this.shadows.end();
            ((Texture)this.fog.getTexture()).setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            this.fog.resize(Vars.world.width(), Vars.world.height());
            this.fog.begin();
            Core.graphics.clear(Color.white);
            Draw.proj().setOrtho(0.0f, 0.0f, this.fog.getWidth(), this.fog.getHeight());
            for (x = 0; x < Vars.world.width(); ++x) {
                for (y = 0; y < Vars.world.height(); ++y) {
                    tile = Vars.world.rawTile(x, y);
                    int edgeBlend = 2;
                    float rot = tile.rotation();
                    boolean fillable = tile.block().solid && tile.block().fillsTile && !tile.block().synthetic();
                    int edgeDst = Math.min(x, Math.min(y, Math.min(Math.abs(x - (Vars.world.width() - 1)), Math.abs(y - (Vars.world.height() - 1)))));
                    if (edgeDst <= edgeBlend) {
                        rot = Math.max((float)(edgeBlend - edgeDst) * (4.0f / (float)edgeBlend), fillable ? rot : 0.0f);
                    }
                    if (!(rot > 0.0f) || !fillable && edgeDst > edgeBlend) continue;
                    Draw.color(0.0f, 0.0f, 0.0f, Math.min((rot + 0.5f) / 4.0f, 1.0f));
                    Fill.rect((float)tile.x + 0.5f, (float)tile.y + 0.5f, 1.0f, 1.0f);
                }
            }
            Draw.flush();
            Draw.color();
            this.fog.end();
        });
        Events.on(EventType.TileChangeEvent.class, event -> {
            this.shadowEvents.add(event.tile);
            int avgx = (int)(Core.camera.position.x / 8.0f);
            int avgy = (int)(Core.camera.position.y / 8.0f);
            int rangex = (int)(Core.camera.width / 8.0f / 2.0f) + 2;
            int rangey = (int)(Core.camera.height / 8.0f / 2.0f) + 2;
            if (Math.abs(avgx - event.tile.x) <= rangex && Math.abs(avgy - event.tile.y) <= rangey) {
                this.lastCamX = -99;
                this.lastCamY = -99;
            }
        });
    }

    public void drawFog() {
        float ww = Vars.world.width() * 8;
        float wh = Vars.world.height() * 8;
        float x = Core.camera.position.x + 4.0f;
        float y = Core.camera.position.y + 4.0f;
        float u = (x - Core.camera.width / 2.0f) / ww;
        float v = (y - Core.camera.height / 2.0f) / wh;
        float u2 = (x + Core.camera.width / 2.0f) / ww;
        float v2 = (y + Core.camera.height / 2.0f) / wh;
        Tmp.tr1.set((Texture)this.fog.getTexture());
        Tmp.tr1.set(u, v2, u2, v);
        Draw.shader(Shaders.fog);
        Draw.rect(Tmp.tr1, Core.camera.position.x, Core.camera.position.y, Core.camera.width, Core.camera.height);
        Draw.shader();
    }

    public void drawBroken() {
        this.brokenFade = Vars.control.input.isPlacing() || Vars.control.input.isBreaking() ? Mathf.lerpDelta(this.brokenFade, 1.0f, 0.1f) : Mathf.lerpDelta(this.brokenFade, 0.0f, 0.1f);
        if (this.brokenFade > 0.001f) {
            for (Teams.BrokenBlock block : Vars.state.teams.get((Team)Vars.player.getTeam()).brokenBlocks) {
                Block b = Vars.content.block(block.block);
                if (!Core.camera.bounds(Tmp.r1).grow(16.0f).overlaps(Tmp.r2.setSize(b.size * 8).setCenter((float)(block.x * 8) + b.offset(), (float)(block.y * 8) + b.offset()))) continue;
                Draw.alpha(0.53f * this.brokenFade);
                Draw.mixcol(Color.white, 0.2f + Mathf.absin(Time.globalTime(), 6.0f, 0.2f));
                Draw.rect(b.icon(Cicon.full), (float)(block.x * 8) + b.offset(), (float)(block.y * 8) + b.offset(), b.rotate ? (float)(block.rotation * 90) : 0.0f);
            }
            Draw.reset();
        }
    }

    public void drawShadows() {
        if (!this.shadowEvents.isEmpty()) {
            Draw.flush();
            this.shadows.begin();
            Draw.proj().setOrtho(0.0f, 0.0f, this.shadows.getWidth(), this.shadows.getHeight());
            for (Tile tile : this.shadowEvents) {
                Draw.color(Color.white);
                Fill.rect((float)tile.x + 0.5f, (float)tile.y + 0.5f, 1.0f, 1.0f);
                Draw.color(!tile.block().hasShadow ? Color.white : shadowColor);
                Fill.rect((float)tile.x + 0.5f, (float)tile.y + 0.5f, 1.0f, 1.0f);
            }
            Draw.flush();
            Draw.color();
            this.shadows.end();
            this.shadowEvents.clear();
            Draw.proj(Core.camera.projection());
            Vars.renderer.pixelator.rebind();
        }
        float ww = Vars.world.width() * 8;
        float wh = Vars.world.height() * 8;
        float x = Core.camera.position.x + 4.0f;
        float y = Core.camera.position.y + 4.0f;
        float u = (x - Core.camera.width / 2.0f) / ww;
        float v = (y - Core.camera.height / 2.0f) / wh;
        float u2 = (x + Core.camera.width / 2.0f) / ww;
        float v2 = (y + Core.camera.height / 2.0f) / wh;
        Tmp.tr1.set((Texture)this.shadows.getTexture());
        Tmp.tr1.set(u, v2, u2, v);
        Draw.shader(Shaders.fog);
        Draw.rect(Tmp.tr1, Core.camera.position.x, Core.camera.position.y, Core.camera.width, Core.camera.height);
        Draw.shader();
    }

    public void processBlocks() {
        this.iterateidx = 0;
        int avgx = (int)(Core.camera.position.x / 8.0f);
        int avgy = (int)(Core.camera.position.y / 8.0f);
        int rangex = (int)(Core.camera.width / 8.0f / 2.0f) + 3;
        int rangey = (int)(Core.camera.height / 8.0f / 2.0f) + 3;
        if (avgx == this.lastCamX && avgy == this.lastCamY && this.lastRangeX == rangex && this.lastRangeY == rangey) {
            return;
        }
        this.requestidx = 0;
        int minx = Math.max(avgx - rangex - 9, 0);
        int miny = Math.max(avgy - rangey - 9, 0);
        int maxx = Math.min(Vars.world.width() - 1, avgx + rangex + 9);
        int maxy = Math.min(Vars.world.height() - 1, avgy + rangey + 9);
        for (int x = minx; x <= maxx; ++x) {
            for (int y = miny; y <= maxy; ++y) {
                Block block;
                boolean expanded = Math.abs(x - avgx) > rangex || Math.abs(y - avgy) > rangey;
                Tile tile = Vars.world.rawTile(x, y);
                if (tile == null || (block = tile.block()) == Blocks.air || block.cacheLayer != CacheLayer.normal) continue;
                if (!expanded) {
                    this.addRequest(tile, Layer.block);
                }
                if (!block.expanded && expanded) continue;
                if (block.layer != null) {
                    this.addRequest(tile, block.layer);
                }
                if (block.layer2 != null) {
                    this.addRequest(tile, block.layer2);
                }
                if (tile.entity == null || tile.entity.power == null || tile.entity.power.links.size <= 0) continue;
                for (Tile other : block.getPowerConnections(tile, this.outArray)) {
                    if (other.block().layer != Layer.power) continue;
                    this.addRequest(other, Layer.power);
                }
            }
        }
        Sort.instance().sort(this.requests.items, 0, this.requestidx);
        this.lastCamX = avgx;
        this.lastCamY = avgy;
        this.lastRangeX = rangex;
        this.lastRangeY = rangey;
    }

    public void drawBlocks(Layer stopAt) {
        int startIdx = this.iterateidx;
        while (this.iterateidx < this.requestidx) {
            BlockRequest request = this.requests.get(this.iterateidx);
            if (request.layer.ordinal() > stopAt.ordinal()) break;
            if (request.layer != Layer.power || this.iterateidx - startIdx <= 0 || request.tile.pos() != this.requests.get((int)(this.iterateidx - 1)).tile.pos()) {
                Block block = request.tile.block();
                if (request.layer == Layer.block) {
                    block.draw(request.tile);
                    if (request.tile.entity != null && request.tile.entity.damaged()) {
                        block.drawCracks(request.tile);
                    }
                    if (block.synthetic() && request.tile.getTeam() != Vars.player.getTeam()) {
                        block.drawTeam(request.tile);
                    }
                } else if (request.layer == block.layer) {
                    block.drawLayer(request.tile);
                } else if (request.layer == block.layer2) {
                    block.drawLayer2(request.tile);
                }
            }
            ++this.iterateidx;
        }
    }

    public void drawTeamBlocks(Layer layer, Team team) {
        for (int index = this.iterateidx; index < this.requestidx && (index >= this.requests.size || this.requests.get((int)index).layer.ordinal() <= layer.ordinal()); ++index) {
            BlockRequest req = this.requests.get(index);
            if (req.tile.getTeam() != team) continue;
            Block block = req.tile.block();
            if (req.layer == Layer.block) {
                block.draw(req.tile);
                continue;
            }
            if (req.layer == block.layer) {
                block.drawLayer(req.tile);
                continue;
            }
            if (req.layer != block.layer2) continue;
            block.drawLayer2(req.tile);
        }
    }

    public void skipLayer(Layer stopAt) {
        while (this.iterateidx < this.requestidx && (this.iterateidx >= this.requests.size || this.requests.get((int)this.iterateidx).layer.ordinal() <= stopAt.ordinal())) {
            ++this.iterateidx;
        }
    }

    private void addRequest(Tile tile, Layer layer) {
        BlockRequest r;
        if (this.requestidx >= this.requests.size) {
            this.requests.add(new BlockRequest());
        }
        if ((r = this.requests.get(this.requestidx)) == null) {
            r = new BlockRequest();
            this.requests.set(this.requestidx, r);
        }
        r.tile = tile;
        r.layer = layer;
        ++this.requestidx;
    }

    @Override
    public void dispose() {
        this.shadows.dispose();
        this.fog.dispose();
        this.fog = null;
        this.shadows = null;
        this.floor.dispose();
    }

    private class BlockRequest
    implements Comparable<BlockRequest> {
        Tile tile;
        Layer layer;

        private BlockRequest() {
        }

        @Override
        public int compareTo(BlockRequest other) {
            int compare = this.layer.compareTo(other.layer);
            return compare != 0 ? compare : Integer.compare(this.tile.pos(), other.tile.pos());
        }

        public String toString() {
            return this.tile.block().name + ":" + this.layer.toString();
        }
    }
}

