/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.gen;

import io.anuke.arc.Core;
import io.anuke.arc.Settings;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.mindustry.game.Rules;
import io.anuke.mindustry.game.Stats;
import io.anuke.mindustry.net.Administration;
import io.anuke.mindustry.type.Zone;
import io.anuke.mindustry.ui.dialogs.JoinDialog;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Serialization {
    public static void writeStats(DataOutput stream, Stats object) throws IOException {
        stream.writeInt(object.enemyUnitsDestroyed);
        stream.writeInt(object.wavesLasted);
        stream.writeLong(object.timeLasted);
        stream.writeInt(object.buildingsBuilt);
        stream.writeInt(object.buildingsDeconstructed);
        stream.writeInt(object.buildingsDestroyed);
    }

    public static Stats readStats(DataInput stream) throws IOException {
        Stats object = new Stats();
        object.enemyUnitsDestroyed = stream.readInt();
        object.wavesLasted = stream.readInt();
        object.timeLasted = stream.readLong();
        object.buildingsBuilt = stream.readInt();
        object.buildingsDeconstructed = stream.readInt();
        object.buildingsDestroyed = stream.readInt();
        return object;
    }

    public static void writeRules(DataOutput stream, Rules object) throws IOException {
        stream.writeBoolean(object.infiniteResources);
        stream.writeBoolean(object.waveTimer);
        stream.writeBoolean(object.waves);
        stream.writeBoolean(object.enemyCheat);
        stream.writeBoolean(object.pvp);
        stream.writeBoolean(object.unitDrops);
        stream.writeFloat(object.unitBuildSpeedMultiplier);
        stream.writeFloat(object.unitHealthMultiplier);
        stream.writeFloat(object.playerHealthMultiplier);
        stream.writeFloat(object.playerDamageMultiplier);
        stream.writeFloat(object.unitDamageMultiplier);
        stream.writeFloat(object.buildCostMultiplier);
        stream.writeFloat(object.buildSpeedMultiplier);
        stream.writeFloat(object.enemyCoreBuildRadius);
        stream.writeFloat(object.dropZoneRadius);
        stream.writeFloat(object.respawnTime);
        stream.writeFloat(object.waveSpacing);
        stream.writeFloat(object.bossWaveMultiplier);
        stream.writeFloat(object.launchWaveMultiplier);
        Core.settings.getSerializer(Zone.class).write(stream, object.zone);
        Core.settings.getSerializer(Array.class).write(stream, object.spawns);
        stream.writeBoolean(object.limitedRespawns);
        stream.writeInt(object.respawns);
        stream.writeBoolean(object.waitForWaveToEnd);
        stream.writeBoolean(object.attackMode);
        stream.writeBoolean(object.editor);
        stream.writeBoolean(object.tutorial);
        Core.settings.getSerializer(Array.class).write(stream, object.loadout);
        Core.settings.getSerializer(ObjectSet.class).write(stream, object.bannedBlocks);
    }

    public static Rules readRules(DataInput stream) throws IOException {
        Rules object = new Rules();
        object.infiniteResources = stream.readBoolean();
        object.waveTimer = stream.readBoolean();
        object.waves = stream.readBoolean();
        object.enemyCheat = stream.readBoolean();
        object.pvp = stream.readBoolean();
        object.unitDrops = stream.readBoolean();
        object.unitBuildSpeedMultiplier = stream.readFloat();
        object.unitHealthMultiplier = stream.readFloat();
        object.playerHealthMultiplier = stream.readFloat();
        object.playerDamageMultiplier = stream.readFloat();
        object.unitDamageMultiplier = stream.readFloat();
        object.buildCostMultiplier = stream.readFloat();
        object.buildSpeedMultiplier = stream.readFloat();
        object.enemyCoreBuildRadius = stream.readFloat();
        object.dropZoneRadius = stream.readFloat();
        object.respawnTime = stream.readFloat();
        object.waveSpacing = stream.readFloat();
        object.bossWaveMultiplier = stream.readFloat();
        object.launchWaveMultiplier = stream.readFloat();
        object.zone = (Zone)Core.settings.getSerializer(Zone.class).read(stream);
        object.spawns = (Array)Core.settings.getSerializer(Array.class).read(stream);
        object.limitedRespawns = stream.readBoolean();
        object.respawns = stream.readInt();
        object.waitForWaveToEnd = stream.readBoolean();
        object.attackMode = stream.readBoolean();
        object.editor = stream.readBoolean();
        object.tutorial = stream.readBoolean();
        object.loadout = (Array)Core.settings.getSerializer(Array.class).read(stream);
        object.bannedBlocks = (ObjectSet)Core.settings.getSerializer(ObjectSet.class).read(stream);
        return object;
    }

    public static void writePlayerInfo(DataOutput stream, Administration.PlayerInfo object) throws IOException {
        Core.settings.getSerializer(String.class).write(stream, object.id);
        Core.settings.getSerializer(String.class).write(stream, object.lastName);
        Core.settings.getSerializer(String.class).write(stream, object.lastIP);
        Core.settings.getSerializer(Array.class).write(stream, object.ips);
        Core.settings.getSerializer(Array.class).write(stream, object.names);
        Core.settings.getSerializer(String.class).write(stream, object.adminUsid);
        stream.writeInt(object.timesKicked);
        stream.writeInt(object.timesJoined);
        stream.writeBoolean(object.banned);
        stream.writeBoolean(object.admin);
        stream.writeLong(object.lastKicked);
    }

    public static Administration.PlayerInfo readPlayerInfo(DataInput stream) throws IOException {
        Administration.PlayerInfo object = new Administration.PlayerInfo();
        object.id = (String)Core.settings.getSerializer(String.class).read(stream);
        object.lastName = (String)Core.settings.getSerializer(String.class).read(stream);
        object.lastIP = (String)Core.settings.getSerializer(String.class).read(stream);
        object.ips = (Array)Core.settings.getSerializer(Array.class).read(stream);
        object.names = (Array)Core.settings.getSerializer(Array.class).read(stream);
        object.adminUsid = (String)Core.settings.getSerializer(String.class).read(stream);
        object.timesKicked = stream.readInt();
        object.timesJoined = stream.readInt();
        object.banned = stream.readBoolean();
        object.admin = stream.readBoolean();
        object.lastKicked = stream.readLong();
        return object;
    }

    public static void writeServer(DataOutput stream, JoinDialog.Server object) throws IOException {
        Core.settings.getSerializer(String.class).write(stream, object.ip);
        stream.writeInt(object.port);
    }

    public static JoinDialog.Server readServer(DataInput stream) throws IOException {
        JoinDialog.Server object = new JoinDialog.Server();
        object.ip = (String)Core.settings.getSerializer(String.class).read(stream);
        object.port = stream.readInt();
        return object;
    }

    public static void init() {
        Core.settings.setSerializer(Stats.class, new Settings.TypeSerializer<Stats>(){

            @Override
            public void write(DataOutput stream, Stats object) throws IOException {
                stream.writeInt(object.enemyUnitsDestroyed);
                stream.writeInt(object.wavesLasted);
                stream.writeLong(object.timeLasted);
                stream.writeInt(object.buildingsBuilt);
                stream.writeInt(object.buildingsDeconstructed);
                stream.writeInt(object.buildingsDestroyed);
            }

            @Override
            public Stats read(DataInput stream) throws IOException {
                Stats object = new Stats();
                object.enemyUnitsDestroyed = stream.readInt();
                object.wavesLasted = stream.readInt();
                object.timeLasted = stream.readLong();
                object.buildingsBuilt = stream.readInt();
                object.buildingsDeconstructed = stream.readInt();
                object.buildingsDestroyed = stream.readInt();
                return object;
            }
        });
        Core.settings.setSerializer(Rules.class, new Settings.TypeSerializer<Rules>(){

            @Override
            public void write(DataOutput stream, Rules object) throws IOException {
                stream.writeBoolean(object.infiniteResources);
                stream.writeBoolean(object.waveTimer);
                stream.writeBoolean(object.waves);
                stream.writeBoolean(object.enemyCheat);
                stream.writeBoolean(object.pvp);
                stream.writeBoolean(object.unitDrops);
                stream.writeFloat(object.unitBuildSpeedMultiplier);
                stream.writeFloat(object.unitHealthMultiplier);
                stream.writeFloat(object.playerHealthMultiplier);
                stream.writeFloat(object.playerDamageMultiplier);
                stream.writeFloat(object.unitDamageMultiplier);
                stream.writeFloat(object.buildCostMultiplier);
                stream.writeFloat(object.buildSpeedMultiplier);
                stream.writeFloat(object.enemyCoreBuildRadius);
                stream.writeFloat(object.dropZoneRadius);
                stream.writeFloat(object.respawnTime);
                stream.writeFloat(object.waveSpacing);
                stream.writeFloat(object.bossWaveMultiplier);
                stream.writeFloat(object.launchWaveMultiplier);
                Core.settings.getSerializer(Zone.class).write(stream, object.zone);
                Core.settings.getSerializer(Array.class).write(stream, object.spawns);
                stream.writeBoolean(object.limitedRespawns);
                stream.writeInt(object.respawns);
                stream.writeBoolean(object.waitForWaveToEnd);
                stream.writeBoolean(object.attackMode);
                stream.writeBoolean(object.editor);
                stream.writeBoolean(object.tutorial);
                Core.settings.getSerializer(Array.class).write(stream, object.loadout);
                Core.settings.getSerializer(ObjectSet.class).write(stream, object.bannedBlocks);
            }

            @Override
            public Rules read(DataInput stream) throws IOException {
                Rules object = new Rules();
                object.infiniteResources = stream.readBoolean();
                object.waveTimer = stream.readBoolean();
                object.waves = stream.readBoolean();
                object.enemyCheat = stream.readBoolean();
                object.pvp = stream.readBoolean();
                object.unitDrops = stream.readBoolean();
                object.unitBuildSpeedMultiplier = stream.readFloat();
                object.unitHealthMultiplier = stream.readFloat();
                object.playerHealthMultiplier = stream.readFloat();
                object.playerDamageMultiplier = stream.readFloat();
                object.unitDamageMultiplier = stream.readFloat();
                object.buildCostMultiplier = stream.readFloat();
                object.buildSpeedMultiplier = stream.readFloat();
                object.enemyCoreBuildRadius = stream.readFloat();
                object.dropZoneRadius = stream.readFloat();
                object.respawnTime = stream.readFloat();
                object.waveSpacing = stream.readFloat();
                object.bossWaveMultiplier = stream.readFloat();
                object.launchWaveMultiplier = stream.readFloat();
                object.zone = (Zone)Core.settings.getSerializer(Zone.class).read(stream);
                object.spawns = (Array)Core.settings.getSerializer(Array.class).read(stream);
                object.limitedRespawns = stream.readBoolean();
                object.respawns = stream.readInt();
                object.waitForWaveToEnd = stream.readBoolean();
                object.attackMode = stream.readBoolean();
                object.editor = stream.readBoolean();
                object.tutorial = stream.readBoolean();
                object.loadout = (Array)Core.settings.getSerializer(Array.class).read(stream);
                object.bannedBlocks = (ObjectSet)Core.settings.getSerializer(ObjectSet.class).read(stream);
                return object;
            }
        });
        Core.settings.setSerializer(Administration.PlayerInfo.class, new Settings.TypeSerializer<Administration.PlayerInfo>(){

            @Override
            public void write(DataOutput stream, Administration.PlayerInfo object) throws IOException {
                Core.settings.getSerializer(String.class).write(stream, object.id);
                Core.settings.getSerializer(String.class).write(stream, object.lastName);
                Core.settings.getSerializer(String.class).write(stream, object.lastIP);
                Core.settings.getSerializer(Array.class).write(stream, object.ips);
                Core.settings.getSerializer(Array.class).write(stream, object.names);
                Core.settings.getSerializer(String.class).write(stream, object.adminUsid);
                stream.writeInt(object.timesKicked);
                stream.writeInt(object.timesJoined);
                stream.writeBoolean(object.banned);
                stream.writeBoolean(object.admin);
                stream.writeLong(object.lastKicked);
            }

            @Override
            public Administration.PlayerInfo read(DataInput stream) throws IOException {
                Administration.PlayerInfo object = new Administration.PlayerInfo();
                object.id = (String)Core.settings.getSerializer(String.class).read(stream);
                object.lastName = (String)Core.settings.getSerializer(String.class).read(stream);
                object.lastIP = (String)Core.settings.getSerializer(String.class).read(stream);
                object.ips = (Array)Core.settings.getSerializer(Array.class).read(stream);
                object.names = (Array)Core.settings.getSerializer(Array.class).read(stream);
                object.adminUsid = (String)Core.settings.getSerializer(String.class).read(stream);
                object.timesKicked = stream.readInt();
                object.timesJoined = stream.readInt();
                object.banned = stream.readBoolean();
                object.admin = stream.readBoolean();
                object.lastKicked = stream.readLong();
                return object;
            }
        });
        Core.settings.setSerializer(JoinDialog.Server.class, new Settings.TypeSerializer<JoinDialog.Server>(){

            @Override
            public void write(DataOutput stream, JoinDialog.Server object) throws IOException {
                Core.settings.getSerializer(String.class).write(stream, object.ip);
                stream.writeInt(object.port);
            }

            @Override
            public JoinDialog.Server read(DataInput stream) throws IOException {
                JoinDialog.Server object = new JoinDialog.Server();
                object.ip = (String)Core.settings.getSerializer(String.class).read(stream);
                object.port = stream.readInt();
                return object;
            }
        });
    }
}

