/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.gen;

import io.anuke.mindustry.core.NetClient;
import io.anuke.mindustry.core.NetServer;
import io.anuke.mindustry.entities.traits.BuilderTrait;
import io.anuke.mindustry.entities.type.BaseUnit;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.input.InputHandler;
import io.anuke.mindustry.io.TypeIO;
import io.anuke.mindustry.net.Packets;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.UnitType;
import io.anuke.mindustry.ui.fragments.BlockInventoryFragment;
import io.anuke.mindustry.ui.fragments.HudFragment;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.logic.MessageBlock;
import io.anuke.mindustry.world.blocks.units.MechPad;
import java.nio.ByteBuffer;

public class RemoteReadServer {
    public static void readPacket(ByteBuffer buffer, int id, Player player) {
        if (id == 2) {
            try {
                NetServer.connectConfirm(player);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'connectConfirm'!", e);
            }
        } else if (id == 6) {
            try {
                float angle = buffer.getFloat();
                InputHandler.dropItem(player, angle);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'dropItem'!", e);
            }
        } else if (id == 8) {
            try {
                Player other = TypeIO.readPlayer(buffer);
                Packets.AdminAction action = TypeIO.readAction(buffer);
                NetServer.onAdminRequest(player, other, action);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onAdminRequest'!", e);
            }
        } else if (id == 9) {
            try {
                int snapshotID = buffer.getInt();
                float x = buffer.getFloat();
                float y = buffer.getFloat();
                float pointerX = buffer.getFloat();
                float pointerY = buffer.getFloat();
                float rotation = buffer.getFloat();
                float baseRotation = buffer.getFloat();
                float xVelocity = buffer.getFloat();
                float yVelocity = buffer.getFloat();
                Tile mining = TypeIO.readTile(buffer);
                boolean boosting = buffer.get() == 1;
                boolean shooting = buffer.get() == 1;
                boolean chatting = buffer.get() == 1;
                boolean building = buffer.get() == 1;
                BuilderTrait.BuildRequest[] requests = TypeIO.readRequests(buffer);
                float viewX = buffer.getFloat();
                float viewY = buffer.getFloat();
                float viewWidth = buffer.getFloat();
                float viewHeight = buffer.getFloat();
                NetServer.onClientShapshot(player, snapshotID, x, y, pointerX, pointerY, rotation, baseRotation, xVelocity, yVelocity, mining, boosting, shooting, chatting, building, requests, viewX, viewY, viewWidth, viewHeight);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onClientShapshot'!", e);
            }
        } else if (id == 21) {
            try {
                Tile tile = TypeIO.readTile(buffer);
                MechPad.onMechFactoryTap(player, tile);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onMechFactoryTap'!", e);
            }
        } else if (id == 22) {
            try {
                long time = buffer.getLong();
                NetClient.onPing(player, time);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onPing'!", e);
            }
        } else if (id == 32) {
            try {
                Tile tile = TypeIO.readTile(buffer);
                int value = buffer.getInt();
                InputHandler.onTileConfig(player, tile, value);
                Call.onTileConfig__forward(player.con, player, tile, value);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onTileConfig'!", e);
            }
        } else if (id == 35) {
            try {
                Tile tile = TypeIO.readTile(buffer);
                InputHandler.onTileTapped(player, tile);
                Call.onTileTapped__forward(player.con, player, tile);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onTileTapped'!", e);
            }
        } else if (id == 41) {
            try {
                BaseUnit unit = TypeIO.readBaseUnit(buffer);
                HudFragment.removeUnitEditor(player, unit);
                Call.removeUnitEditor__forward(player.con, player, unit);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'removeUnitEditor'!", e);
            }
        } else if (id == 42) {
            try {
                Tile tile = TypeIO.readTile(buffer);
                Item item = TypeIO.readItem(buffer);
                int amount = buffer.getInt();
                BlockInventoryFragment.requestItem(player, tile, item, amount);
                Call.requestItem__forward(player.con, player, tile, item, amount);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'requestItem'!", e);
            }
        } else if (id == 43) {
            try {
                Tile tile = TypeIO.readTile(buffer);
                boolean direction = buffer.get() == 1;
                InputHandler.rotateBlock(player, tile, direction);
                Call.rotateBlock__forward(player.con, player, tile, direction);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'rotateBlock'!", e);
            }
        } else if (id == 44) {
            try {
                String message = TypeIO.readString(buffer);
                NetClient.sendChatMessage(player, message);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'sendChatMessage'!", e);
            }
        } else if (id == 47) {
            try {
                Tile tile = TypeIO.readTile(buffer);
                String text = TypeIO.readString(buffer);
                MessageBlock.setMessageBlockText(player, tile, text);
                Call.setMessageBlockText__forward(player.con, player, tile, text);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'setMessageBlockText'!", e);
            }
        } else if (id == 48) {
            try {
                Team team = TypeIO.readTeam(buffer);
                HudFragment.setPlayerTeamEditor(player, team);
                Call.setPlayerTeamEditor__forward(player.con, player, team);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'setPlayerTeamEditor'!", e);
            }
        } else if (id == 49) {
            try {
                UnitType type = TypeIO.readUnitType(buffer);
                HudFragment.spawnUnitEditor(player, type);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'spawnUnitEditor'!", e);
            }
        } else if (id == 50) {
            try {
                Tile tile = TypeIO.readTile(buffer);
                InputHandler.transferInventory(player, tile);
                Call.transferInventory__forward(player.con, player, tile);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'transferInventory'!", e);
            }
        } else {
            throw new RuntimeException("Invalid read method ID: " + id + "");
        }
    }
}

