/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.gen;

import io.anuke.arc.graphics.Color;
import io.anuke.arc.util.pooling.Pools;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.core.Logic;
import io.anuke.mindustry.core.NetClient;
import io.anuke.mindustry.core.NetServer;
import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.entities.effect.ItemTransfer;
import io.anuke.mindustry.entities.effect.Lightning;
import io.anuke.mindustry.entities.effect.Puddle;
import io.anuke.mindustry.entities.traits.BuilderTrait;
import io.anuke.mindustry.entities.traits.ShooterTrait;
import io.anuke.mindustry.entities.type.BaseUnit;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.game.Rules;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.input.InputHandler;
import io.anuke.mindustry.io.TypeIO;
import io.anuke.mindustry.net.Administration;
import io.anuke.mindustry.net.Net;
import io.anuke.mindustry.net.NetConnection;
import io.anuke.mindustry.net.Packets;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.UnitType;
import io.anuke.mindustry.type.Weapon;
import io.anuke.mindustry.ui.fragments.BlockInventoryFragment;
import io.anuke.mindustry.ui.fragments.HudFragment;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Build;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.BuildBlock;
import io.anuke.mindustry.world.blocks.defense.Door;
import io.anuke.mindustry.world.blocks.logic.MessageBlock;
import io.anuke.mindustry.world.blocks.storage.CoreBlock;
import io.anuke.mindustry.world.blocks.units.MechPad;
import io.anuke.mindustry.world.blocks.units.UnitFactory;
import java.nio.ByteBuffer;

public class Call {
    private static final ByteBuffer TEMP_BUFFER = ByteBuffer.allocate(4096);

    public static synchronized void beginBreak(Team team, int x, int y) {
        if (Vars.net.server() || !Vars.net.active()) {
            Build.beginBreak(team, x, y);
        }
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = 0;
            TEMP_BUFFER.position(0);
            TypeIO.writeTeam(TEMP_BUFFER, team);
            TEMP_BUFFER.putInt(x);
            TEMP_BUFFER.putInt(y);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void beginPlace(Team team, int x, int y, Block result, int rotation) {
        if (Vars.net.server() || !Vars.net.active()) {
            Build.beginPlace(team, x, y, result, rotation);
        }
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = 1;
            TEMP_BUFFER.position(0);
            TypeIO.writeTeam(TEMP_BUFFER, team);
            TEMP_BUFFER.putInt(x);
            TEMP_BUFFER.putInt(y);
            TypeIO.writeBlock(TEMP_BUFFER, result);
            TEMP_BUFFER.putInt(rotation);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void connectConfirm() {
        if (Vars.net.client()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)2;
            TEMP_BUFFER.position(0);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void createBullet(BulletType type, float x, float y, float angle) {
        if (Vars.net.server() || !Vars.net.active()) {
            Bullet.createBullet(type, x, y, angle);
        }
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)3;
            TEMP_BUFFER.position(0);
            TypeIO.writeBulletType(TEMP_BUFFER, type);
            TEMP_BUFFER.putFloat(x);
            TEMP_BUFFER.putFloat(y);
            TEMP_BUFFER.putFloat(angle);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.udp);
        }
    }

    public static synchronized void createBullet(BulletType type, Team team, float x, float y, float angle) {
        if (Vars.net.server() || !Vars.net.active()) {
            Bullet.createBullet(type, team, x, y, angle);
        }
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)4;
            TEMP_BUFFER.position(0);
            TypeIO.writeBulletType(TEMP_BUFFER, type);
            TypeIO.writeTeam(TEMP_BUFFER, team);
            TEMP_BUFFER.putFloat(x);
            TEMP_BUFFER.putFloat(y);
            TEMP_BUFFER.putFloat(angle);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.udp);
        }
    }

    public static synchronized void createLighting(int seed, Team team, Color color, float damage, float x, float y, float rotation, int length) {
        if (Vars.net.server() || !Vars.net.active()) {
            Lightning.createLighting(seed, team, color, damage, x, y, rotation, length);
        }
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)5;
            TEMP_BUFFER.position(0);
            TEMP_BUFFER.putInt(seed);
            TypeIO.writeTeam(TEMP_BUFFER, team);
            TypeIO.writeColor(TEMP_BUFFER, color);
            TEMP_BUFFER.putFloat(damage);
            TEMP_BUFFER.putFloat(x);
            TEMP_BUFFER.putFloat(y);
            TEMP_BUFFER.putFloat(rotation);
            TEMP_BUFFER.putInt(length);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.udp);
        }
    }

    public static synchronized void dropItem(float angle) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.dropItem(Vars.player, angle);
        }
        if (Vars.net.client()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)6;
            TEMP_BUFFER.position(0);
            TEMP_BUFFER.putFloat(angle);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void launchZone() {
        Logic.launchZone();
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)7;
            TEMP_BUFFER.position(0);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onAdminRequest(Player other, Packets.AdminAction action) {
        if (Vars.net.server() || !Vars.net.active()) {
            NetServer.onAdminRequest(Vars.player, other, action);
        }
        if (Vars.net.client()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)8;
            TEMP_BUFFER.position(0);
            TypeIO.writePlayer(TEMP_BUFFER, other);
            TypeIO.writeAction(TEMP_BUFFER, action);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onClientShapshot(int snapshotID, float x, float y, float pointerX, float pointerY, float rotation, float baseRotation, float xVelocity, float yVelocity, Tile mining, boolean boosting, boolean shooting, boolean chatting, boolean building, BuilderTrait.BuildRequest[] requests, float viewX, float viewY, float viewWidth, float viewHeight) {
        if (Vars.net.client()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)9;
            TEMP_BUFFER.position(0);
            TEMP_BUFFER.putInt(snapshotID);
            TEMP_BUFFER.putFloat(x);
            TEMP_BUFFER.putFloat(y);
            TEMP_BUFFER.putFloat(pointerX);
            TEMP_BUFFER.putFloat(pointerY);
            TEMP_BUFFER.putFloat(rotation);
            TEMP_BUFFER.putFloat(baseRotation);
            TEMP_BUFFER.putFloat(xVelocity);
            TEMP_BUFFER.putFloat(yVelocity);
            TypeIO.writeTile(TEMP_BUFFER, mining);
            TEMP_BUFFER.put(boosting ? (byte)1 : 0);
            TEMP_BUFFER.put(shooting ? (byte)1 : 0);
            TEMP_BUFFER.put(chatting ? (byte)1 : 0);
            TEMP_BUFFER.put(building ? (byte)1 : 0);
            TypeIO.writeRequests(TEMP_BUFFER, requests);
            TEMP_BUFFER.putFloat(viewX);
            TEMP_BUFFER.putFloat(viewY);
            TEMP_BUFFER.putFloat(viewWidth);
            TEMP_BUFFER.putFloat(viewHeight);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.udp);
        }
    }

    public static synchronized void onConnect(NetConnection playerConnection, String ip, int port) {
        if (Vars.net.client() || !Vars.net.active()) {
            NetClient.onConnect(ip, port);
        }
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)10;
            TEMP_BUFFER.position(0);
            TypeIO.writeString(TEMP_BUFFER, ip);
            TEMP_BUFFER.putInt(port);
            packet.writeLength = TEMP_BUFFER.position();
            playerConnection.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onConstructFinish(Tile tile, Block block, int builderID, byte rotation, Team team, boolean skipConfig) {
        if (Vars.net.server() || !Vars.net.active()) {
            BuildBlock.onConstructFinish(tile, block, builderID, rotation, team, skipConfig);
        }
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)11;
            TEMP_BUFFER.position(0);
            TypeIO.writeTile(TEMP_BUFFER, tile);
            TypeIO.writeBlock(TEMP_BUFFER, block);
            TEMP_BUFFER.putInt(builderID);
            TEMP_BUFFER.put(rotation);
            TypeIO.writeTeam(TEMP_BUFFER, team);
            TEMP_BUFFER.put(skipConfig ? (byte)1 : 0);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onDeconstructFinish(Tile tile, Block block, int builderID) {
        if (Vars.net.server() || !Vars.net.active()) {
            BuildBlock.onDeconstructFinish(tile, block, builderID);
        }
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)12;
            TEMP_BUFFER.position(0);
            TypeIO.writeTile(TEMP_BUFFER, tile);
            TypeIO.writeBlock(TEMP_BUFFER, block);
            TEMP_BUFFER.putInt(builderID);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onDoorToggle(Player player, Tile tile, boolean open) {
        if (Vars.net.server() || !Vars.net.active()) {
            Door.onDoorToggle(player, tile, open);
        }
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)13;
            TEMP_BUFFER.position(0);
            TypeIO.writePlayer(TEMP_BUFFER, player);
            TypeIO.writeTile(TEMP_BUFFER, tile);
            TEMP_BUFFER.put(open ? (byte)1 : 0);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onEntitySnapshot(NetConnection playerConnection, byte groupID, short amount, short dataLen, byte[] data) {
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = (byte)2;
            packet.type = (byte)14;
            TEMP_BUFFER.position(0);
            TEMP_BUFFER.put(groupID);
            TEMP_BUFFER.putShort(amount);
            TEMP_BUFFER.putShort(dataLen);
            TypeIO.writeBytes(TEMP_BUFFER, data);
            packet.writeLength = TEMP_BUFFER.position();
            playerConnection.send(packet, Net.SendMode.udp);
        }
    }

    public static synchronized void onGameOver(Team winner) {
        Logic.onGameOver(winner);
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)15;
            TEMP_BUFFER.position(0);
            TypeIO.writeTeam(TEMP_BUFFER, winner);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onGenericShootWeapon(ShooterTrait shooter, float x, float y, float rotation, boolean left) {
        Weapon.onGenericShootWeapon(shooter, x, y, rotation, left);
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)16;
            TEMP_BUFFER.position(0);
            TypeIO.writeShooter(TEMP_BUFFER, shooter);
            TEMP_BUFFER.putFloat(x);
            TEMP_BUFFER.putFloat(y);
            TEMP_BUFFER.putFloat(rotation);
            TEMP_BUFFER.put(left ? (byte)1 : 0);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.udp);
        }
    }

    public static synchronized void onInfoMessage(String message) {
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)17;
            TEMP_BUFFER.position(0);
            TypeIO.writeString(TEMP_BUFFER, message);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onInfoMessage(NetConnection playerConnection, String message) {
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)17;
            TEMP_BUFFER.position(0);
            TypeIO.writeString(TEMP_BUFFER, message);
            packet.writeLength = TEMP_BUFFER.position();
            playerConnection.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onKick(NetConnection playerConnection, Packets.KickReason reason) {
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 1;
            packet.type = (byte)18;
            TEMP_BUFFER.position(0);
            TypeIO.writeKick(TEMP_BUFFER, reason);
            packet.writeLength = TEMP_BUFFER.position();
            playerConnection.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onKick(NetConnection playerConnection, String reason) {
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 1;
            packet.type = (byte)19;
            TEMP_BUFFER.position(0);
            TypeIO.writeString(TEMP_BUFFER, reason);
            packet.writeLength = TEMP_BUFFER.position();
            playerConnection.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onMechFactoryDone(Tile tile) {
        if (Vars.net.server() || !Vars.net.active()) {
            MechPad.onMechFactoryDone(tile);
        }
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)20;
            TEMP_BUFFER.position(0);
            TypeIO.writeTile(TEMP_BUFFER, tile);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onMechFactoryTap(Player player, Tile tile) {
        if (Vars.net.server() || !Vars.net.active()) {
            MechPad.onMechFactoryTap(player, tile);
        }
        if (Vars.net.server() || Vars.net.client()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)21;
            TEMP_BUFFER.position(0);
            if (Vars.net.server()) {
                TypeIO.writePlayer(TEMP_BUFFER, player);
            }
            TypeIO.writeTile(TEMP_BUFFER, tile);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onPing(long time) {
        if (Vars.net.client()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)22;
            TEMP_BUFFER.position(0);
            TEMP_BUFFER.putLong(time);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onPingResponse(NetConnection playerConnection, long time) {
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)23;
            TEMP_BUFFER.position(0);
            TEMP_BUFFER.putLong(time);
            packet.writeLength = TEMP_BUFFER.position();
            playerConnection.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onPlayerDeath(Player player) {
        if (Vars.net.server() || !Vars.net.active()) {
            Player.onPlayerDeath(player);
        }
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)24;
            TEMP_BUFFER.position(0);
            TypeIO.writePlayer(TEMP_BUFFER, player);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onPlayerDisconnect(int playerid) {
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)25;
            TEMP_BUFFER.position(0);
            TEMP_BUFFER.putInt(playerid);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onPlayerShootWeapon(Player player, float x, float y, float rotation, boolean left) {
        Weapon.onPlayerShootWeapon(player, x, y, rotation, left);
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)26;
            TEMP_BUFFER.position(0);
            TypeIO.writePlayer(TEMP_BUFFER, player);
            TEMP_BUFFER.putFloat(x);
            TEMP_BUFFER.putFloat(y);
            TEMP_BUFFER.putFloat(rotation);
            TEMP_BUFFER.put(left ? (byte)1 : 0);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.udp);
        }
    }

    public static synchronized void onPositionSet(NetConnection playerConnection, float x, float y) {
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)27;
            TEMP_BUFFER.position(0);
            TEMP_BUFFER.putFloat(x);
            TEMP_BUFFER.putFloat(y);
            packet.writeLength = TEMP_BUFFER.position();
            playerConnection.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onPuddleRemoved(int puddleid) {
        if (Vars.net.server() || !Vars.net.active()) {
            Puddle.onPuddleRemoved(puddleid);
        }
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)28;
            TEMP_BUFFER.position(0);
            TEMP_BUFFER.putInt(puddleid);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onRemoveFire(int fid) {
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)29;
            TEMP_BUFFER.position(0);
            TEMP_BUFFER.putInt(fid);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onSetRules(Rules rules) {
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)30;
            TEMP_BUFFER.position(0);
            TypeIO.writeRules(TEMP_BUFFER, rules);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onSetRules(NetConnection playerConnection, Rules rules) {
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)30;
            TEMP_BUFFER.position(0);
            TypeIO.writeRules(TEMP_BUFFER, rules);
            packet.writeLength = TEMP_BUFFER.position();
            playerConnection.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onStateSnapshot(NetConnection playerConnection, float waveTime, int wave, int enemies, short coreDataLen, byte[] coreData) {
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = (byte)2;
            packet.type = (byte)31;
            TEMP_BUFFER.position(0);
            TEMP_BUFFER.putFloat(waveTime);
            TEMP_BUFFER.putInt(wave);
            TEMP_BUFFER.putInt(enemies);
            TEMP_BUFFER.putShort(coreDataLen);
            TypeIO.writeBytes(TEMP_BUFFER, coreData);
            packet.writeLength = TEMP_BUFFER.position();
            playerConnection.send(packet, Net.SendMode.udp);
        }
    }

    public static synchronized void onTileConfig(Player player, Tile tile, int value) {
        InputHandler.onTileConfig(player, tile, value);
        if (Vars.net.server() || Vars.net.client()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)32;
            TEMP_BUFFER.position(0);
            if (Vars.net.server()) {
                TypeIO.writePlayer(TEMP_BUFFER, player);
            }
            TypeIO.writeTile(TEMP_BUFFER, tile);
            TEMP_BUFFER.putInt(value);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    static synchronized void onTileConfig__forward(NetConnection exceptConnection, Player player, Tile tile, int value) {
        if (Vars.net.server() || Vars.net.client()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)32;
            TEMP_BUFFER.position(0);
            if (Vars.net.server()) {
                TypeIO.writePlayer(TEMP_BUFFER, player);
            }
            TypeIO.writeTile(TEMP_BUFFER, tile);
            TEMP_BUFFER.putInt(value);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.sendExcept(exceptConnection, packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onTileDamage(Tile tile, float health) {
        if (Vars.net.server() || !Vars.net.active()) {
            TileEntity.onTileDamage(tile, health);
        }
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)33;
            TEMP_BUFFER.position(0);
            TypeIO.writeTile(TEMP_BUFFER, tile);
            TEMP_BUFFER.putFloat(health);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.udp);
        }
    }

    public static synchronized void onTileDestroyed(Tile tile) {
        if (Vars.net.server() || !Vars.net.active()) {
            TileEntity.onTileDestroyed(tile);
        }
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)34;
            TEMP_BUFFER.position(0);
            TypeIO.writeTile(TEMP_BUFFER, tile);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onTileTapped(Player player, Tile tile) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.onTileTapped(player, tile);
        }
        if (Vars.net.server() || Vars.net.client()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)35;
            TEMP_BUFFER.position(0);
            if (Vars.net.server()) {
                TypeIO.writePlayer(TEMP_BUFFER, player);
            }
            TypeIO.writeTile(TEMP_BUFFER, tile);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    static synchronized void onTileTapped__forward(NetConnection exceptConnection, Player player, Tile tile) {
        if (Vars.net.server() || Vars.net.client()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)35;
            TEMP_BUFFER.position(0);
            if (Vars.net.server()) {
                TypeIO.writePlayer(TEMP_BUFFER, player);
            }
            TypeIO.writeTile(TEMP_BUFFER, tile);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onTraceInfo(NetConnection playerConnection, Player player, Administration.TraceInfo info) {
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)36;
            TEMP_BUFFER.position(0);
            TypeIO.writePlayer(TEMP_BUFFER, player);
            TypeIO.writeTraceInfo(TEMP_BUFFER, info);
            packet.writeLength = TEMP_BUFFER.position();
            playerConnection.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onUnitDeath(BaseUnit unit) {
        if (Vars.net.server() || !Vars.net.active()) {
            BaseUnit.onUnitDeath(unit);
        }
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)37;
            TEMP_BUFFER.position(0);
            TypeIO.writeBaseUnit(TEMP_BUFFER, unit);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onUnitFactorySpawn(Tile tile, int spawns) {
        if (Vars.net.server() || !Vars.net.active()) {
            UnitFactory.onUnitFactorySpawn(tile, spawns);
        }
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)38;
            TEMP_BUFFER.position(0);
            TypeIO.writeTile(TEMP_BUFFER, tile);
            TEMP_BUFFER.putInt(spawns);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onUnitRespawn(Tile tile, Player player) {
        if (Vars.net.server() || !Vars.net.active()) {
            CoreBlock.onUnitRespawn(tile, player);
        }
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)39;
            TEMP_BUFFER.position(0);
            TypeIO.writeTile(TEMP_BUFFER, tile);
            TypeIO.writePlayer(TEMP_BUFFER, player);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onWorldDataBegin() {
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)40;
            TEMP_BUFFER.position(0);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void onWorldDataBegin(NetConnection playerConnection) {
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)40;
            TEMP_BUFFER.position(0);
            packet.writeLength = TEMP_BUFFER.position();
            playerConnection.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void removeUnitEditor(Player player, BaseUnit unit) {
        if (Vars.net.server() || !Vars.net.active()) {
            HudFragment.removeUnitEditor(player, unit);
        }
        if (Vars.net.server() || Vars.net.client()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)41;
            TEMP_BUFFER.position(0);
            if (Vars.net.server()) {
                TypeIO.writePlayer(TEMP_BUFFER, player);
            }
            TypeIO.writeBaseUnit(TEMP_BUFFER, unit);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    static synchronized void removeUnitEditor__forward(NetConnection exceptConnection, Player player, BaseUnit unit) {
        if (Vars.net.server() || Vars.net.client()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)41;
            TEMP_BUFFER.position(0);
            if (Vars.net.server()) {
                TypeIO.writePlayer(TEMP_BUFFER, player);
            }
            TypeIO.writeBaseUnit(TEMP_BUFFER, unit);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void requestItem(Player player, Tile tile, Item item, int amount) {
        if (Vars.net.server() || !Vars.net.active()) {
            BlockInventoryFragment.requestItem(player, tile, item, amount);
        }
        if (Vars.net.server() || Vars.net.client()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)42;
            TEMP_BUFFER.position(0);
            if (Vars.net.server()) {
                TypeIO.writePlayer(TEMP_BUFFER, player);
            }
            TypeIO.writeTile(TEMP_BUFFER, tile);
            TypeIO.writeItem(TEMP_BUFFER, item);
            TEMP_BUFFER.putInt(amount);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    static synchronized void requestItem__forward(NetConnection exceptConnection, Player player, Tile tile, Item item, int amount) {
        if (Vars.net.server() || Vars.net.client()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)42;
            TEMP_BUFFER.position(0);
            if (Vars.net.server()) {
                TypeIO.writePlayer(TEMP_BUFFER, player);
            }
            TypeIO.writeTile(TEMP_BUFFER, tile);
            TypeIO.writeItem(TEMP_BUFFER, item);
            TEMP_BUFFER.putInt(amount);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void rotateBlock(Player player, Tile tile, boolean direction) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.rotateBlock(player, tile, direction);
        }
        if (Vars.net.server() || Vars.net.client()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)43;
            TEMP_BUFFER.position(0);
            if (Vars.net.server()) {
                TypeIO.writePlayer(TEMP_BUFFER, player);
            }
            TypeIO.writeTile(TEMP_BUFFER, tile);
            TEMP_BUFFER.put(direction ? (byte)1 : 0);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.udp);
        }
    }

    static synchronized void rotateBlock__forward(NetConnection exceptConnection, Player player, Tile tile, boolean direction) {
        if (Vars.net.server() || Vars.net.client()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)43;
            TEMP_BUFFER.position(0);
            if (Vars.net.server()) {
                TypeIO.writePlayer(TEMP_BUFFER, player);
            }
            TypeIO.writeTile(TEMP_BUFFER, tile);
            TEMP_BUFFER.put(direction ? (byte)1 : 0);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.udp);
        }
    }

    public static synchronized void sendChatMessage(String message) {
        if (Vars.net.server() || !Vars.net.active()) {
            NetClient.sendChatMessage(Vars.player, message);
        }
        if (Vars.net.client()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)44;
            TEMP_BUFFER.position(0);
            TypeIO.writeString(TEMP_BUFFER, message);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void sendMessage(String message) {
        if (Vars.net.server() || !Vars.net.active()) {
            NetClient.sendMessage(message);
        }
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)45;
            TEMP_BUFFER.position(0);
            TypeIO.writeString(TEMP_BUFFER, message);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void sendMessage(String message, String sender, Player playersender) {
        if (Vars.net.server() || !Vars.net.active()) {
            NetClient.sendMessage(message, sender, playersender);
        }
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)46;
            TEMP_BUFFER.position(0);
            TypeIO.writeString(TEMP_BUFFER, message);
            TypeIO.writeString(TEMP_BUFFER, sender);
            TypeIO.writePlayer(TEMP_BUFFER, playersender);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void sendMessage(NetConnection playerConnection, String message, String sender, Player playersender) {
        if (Vars.net.server() || !Vars.net.active()) {
            NetClient.sendMessage(message, sender, playersender);
        }
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)46;
            TEMP_BUFFER.position(0);
            TypeIO.writeString(TEMP_BUFFER, message);
            TypeIO.writeString(TEMP_BUFFER, sender);
            TypeIO.writePlayer(TEMP_BUFFER, playersender);
            packet.writeLength = TEMP_BUFFER.position();
            playerConnection.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void setMessageBlockText(Player player, Tile tile, String text) {
        MessageBlock.setMessageBlockText(player, tile, text);
        if (Vars.net.server() || Vars.net.client()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)47;
            TEMP_BUFFER.position(0);
            if (Vars.net.server()) {
                TypeIO.writePlayer(TEMP_BUFFER, player);
            }
            TypeIO.writeTile(TEMP_BUFFER, tile);
            TypeIO.writeString(TEMP_BUFFER, text);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    static synchronized void setMessageBlockText__forward(NetConnection exceptConnection, Player player, Tile tile, String text) {
        if (Vars.net.server() || Vars.net.client()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)47;
            TEMP_BUFFER.position(0);
            if (Vars.net.server()) {
                TypeIO.writePlayer(TEMP_BUFFER, player);
            }
            TypeIO.writeTile(TEMP_BUFFER, tile);
            TypeIO.writeString(TEMP_BUFFER, text);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.sendExcept(exceptConnection, packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void setPlayerTeamEditor(Player player, Team team) {
        HudFragment.setPlayerTeamEditor(player, team);
        if (Vars.net.server() || Vars.net.client()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)48;
            TEMP_BUFFER.position(0);
            if (Vars.net.server()) {
                TypeIO.writePlayer(TEMP_BUFFER, player);
            }
            TypeIO.writeTeam(TEMP_BUFFER, team);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    static synchronized void setPlayerTeamEditor__forward(NetConnection exceptConnection, Player player, Team team) {
        if (Vars.net.server() || Vars.net.client()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)48;
            TEMP_BUFFER.position(0);
            if (Vars.net.server()) {
                TypeIO.writePlayer(TEMP_BUFFER, player);
            }
            TypeIO.writeTeam(TEMP_BUFFER, team);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.sendExcept(exceptConnection, packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void spawnUnitEditor(Player player, UnitType type) {
        if (Vars.net.server() || !Vars.net.active()) {
            HudFragment.spawnUnitEditor(player, type);
        }
        if (Vars.net.server() || Vars.net.client()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)49;
            TEMP_BUFFER.position(0);
            if (Vars.net.server()) {
                TypeIO.writePlayer(TEMP_BUFFER, player);
            }
            TypeIO.writeUnitType(TEMP_BUFFER, type);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void transferInventory(Player player, Tile tile) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.transferInventory(player, tile);
        }
        if (Vars.net.server() || Vars.net.client()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)50;
            TEMP_BUFFER.position(0);
            if (Vars.net.server()) {
                TypeIO.writePlayer(TEMP_BUFFER, player);
            }
            TypeIO.writeTile(TEMP_BUFFER, tile);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    static synchronized void transferInventory__forward(NetConnection exceptConnection, Player player, Tile tile) {
        if (Vars.net.server() || Vars.net.client()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)50;
            TEMP_BUFFER.position(0);
            if (Vars.net.server()) {
                TypeIO.writePlayer(TEMP_BUFFER, player);
            }
            TypeIO.writeTile(TEMP_BUFFER, tile);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void transferItemEffect(Item item, float x, float y, Unit to) {
        if (Vars.net.server() || !Vars.net.active()) {
            ItemTransfer.transferItemEffect(item, x, y, to);
        }
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)51;
            TEMP_BUFFER.position(0);
            TypeIO.writeItem(TEMP_BUFFER, item);
            TEMP_BUFFER.putFloat(x);
            TEMP_BUFFER.putFloat(y);
            TypeIO.writeUnit(TEMP_BUFFER, to);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.udp);
        }
    }

    public static synchronized void transferItemTo(Item item, int amount, float x, float y, Tile tile) {
        if (Vars.net.server() || !Vars.net.active()) {
            ItemTransfer.transferItemTo(item, amount, x, y, tile);
        }
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)52;
            TEMP_BUFFER.position(0);
            TypeIO.writeItem(TEMP_BUFFER, item);
            TEMP_BUFFER.putInt(amount);
            TEMP_BUFFER.putFloat(x);
            TEMP_BUFFER.putFloat(y);
            TypeIO.writeTile(TEMP_BUFFER, tile);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.tcp);
        }
    }

    public static synchronized void transferItemToUnit(Item item, float x, float y, Unit to) {
        if (Vars.net.server() || !Vars.net.active()) {
            ItemTransfer.transferItemToUnit(item, x, y, to);
        }
        if (Vars.net.server()) {
            Packets.InvokePacket packet = Pools.obtain(Packets.InvokePacket.class, Packets.InvokePacket::new);
            packet.writeBuffer = TEMP_BUFFER;
            packet.priority = 0;
            packet.type = (byte)53;
            TEMP_BUFFER.position(0);
            TypeIO.writeItem(TEMP_BUFFER, item);
            TEMP_BUFFER.putFloat(x);
            TEMP_BUFFER.putFloat(y);
            TypeIO.writeUnit(TEMP_BUFFER, to);
            packet.writeLength = TEMP_BUFFER.position();
            Vars.net.send(packet, Net.SendMode.udp);
        }
    }
}

