/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.game;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.ObjectIntMap;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.arc.function.BooleanProvider;
import io.anuke.arc.function.Function;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.ui.Button;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.util.Strings;
import io.anuke.arc.util.Tmp;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.content.Items;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.graphics.Drawf;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;

public class Tutorial {
    private static final int mineCopper = 18;
    private static final int blocksToBreak = 3;
    private static final int blockOffset = -6;
    private ObjectSet<String> events = new ObjectSet();
    private ObjectIntMap<Block> blocksPlaced = new ObjectIntMap();
    private int sentence;
    public TutorialStage stage = TutorialStage.values()[0];

    public Tutorial() {
        Events.on(EventType.BlockBuildEndEvent.class, event -> {
            if (!event.breaking) {
                this.blocksPlaced.getAndIncrement(event.tile.block(), 0, 1);
            }
        });
        Events.on(EventType.LineConfirmEvent.class, event -> this.events.add("lineconfirm"));
        Events.on(EventType.TurretAmmoDeliverEvent.class, event -> this.events.add("ammo"));
        Events.on(EventType.CoreItemDeliverEvent.class, event -> this.events.add("coreitem"));
        Events.on(EventType.BlockInfoEvent.class, event -> this.events.add("blockinfo"));
        Events.on(EventType.DepositEvent.class, event -> this.events.add("deposit"));
        Events.on(EventType.WithdrawEvent.class, event -> this.events.add("withdraw"));
        Events.on(EventType.ClientLoadEvent.class, e -> {
            for (TutorialStage stage : TutorialStage.values()) {
                stage.load();
            }
        });
    }

    public void update() {
        if (this.stage.done.get() && !this.canNext()) {
            this.next();
        } else {
            this.stage.update();
        }
    }

    public void draw() {
        if (!Core.scene.hasDialog()) {
            this.stage.draw();
        }
    }

    public void reset() {
        this.stage = TutorialStage.values()[0];
        this.stage.begin();
        this.blocksPlaced.clear();
        this.events.clear();
        this.sentence = 0;
    }

    public void next() {
        this.stage = TutorialStage.values()[Mathf.clamp(this.stage.ordinal() + 1, 0, TutorialStage.values().length)];
        this.stage.begin();
        this.blocksPlaced.clear();
        this.events.clear();
        this.sentence = 0;
    }

    public boolean canNext() {
        return this.sentence + 1 < this.stage.sentences.size;
    }

    public void nextSentence() {
        if (this.canNext()) {
            ++this.sentence;
        }
    }

    public boolean canPrev() {
        return this.sentence > 0;
    }

    public void prevSentence() {
        if (this.canPrev()) {
            --this.sentence;
        }
    }

    public static enum TutorialStage {
        intro(line -> Strings.format(line, TutorialStage.item(Items.copper), 18), () -> TutorialStage.item(Items.copper) >= 18),
        drill(() -> TutorialStage.placed(Blocks.mechanicalDrill, 1)){

            @Override
            void draw() {
                1.outline("category-production");
                1.outline("block-mechanical-drill");
                1.outline("confirmplace");
            }
        }
        ,
        blockinfo(() -> TutorialStage.event("blockinfo")){

            @Override
            void draw() {
                2.outline("category-production");
                2.outline("block-mechanical-drill");
                2.outline("blockinfo");
            }
        }
        ,
        conveyor(() -> TutorialStage.placed(Blocks.conveyor, 2) && TutorialStage.event("lineconfirm") && TutorialStage.event("coreitem")){

            @Override
            void draw() {
                3.outline("category-distribution");
                3.outline("block-conveyor");
            }
        }
        ,
        turret(() -> TutorialStage.placed(Blocks.duo, 1)){

            @Override
            void draw() {
                4.outline("category-turret");
                4.outline("block-duo");
            }
        }
        ,
        drillturret(() -> TutorialStage.event("ammo")),
        pause(() -> Vars.state.isPaused()){

            @Override
            void draw() {
                if (Vars.mobile) {
                    5.outline("pause");
                }
            }
        }
        ,
        unpause(() -> !Vars.state.isPaused()){

            @Override
            void draw() {
                if (Vars.mobile) {
                    6.outline("pause");
                }
            }
        }
        ,
        breaking(TutorialStage::blocksBroken){

            @Override
            void begin() {
                7.placeBlocks();
            }

            @Override
            void draw() {
                if (Vars.mobile) {
                    7.outline("breakmode");
                }
            }
        }
        ,
        withdraw(() -> TutorialStage.event("withdraw")){

            @Override
            void begin() {
                Vars.state.teams.get((Team)Vars.defaultTeam).cores.first().entity.items.add(Items.copper, 10);
            }
        }
        ,
        deposit(() -> TutorialStage.event("deposit")),
        waves(() -> Vars.state.wave > 2 && Vars.state.enemies() <= 0 && !Vars.spawner.isSpawning()){

            @Override
            void begin() {
                Vars.state.rules.waveTimer = true;
                Vars.logic.runWave();
            }

            @Override
            void update() {
                if (Vars.state.wave > 2) {
                    Vars.state.rules.waveTimer = false;
                }
            }
        }
        ,
        launch(() -> false){

            @Override
            void begin() {
                Vars.state.rules.waveTimer = false;
                Vars.state.wave = 5;
                Events.fire(EventType.Trigger.tutorialComplete);
                Core.settings.put("playedtutorial", true);
                Core.settings.save();
            }

            @Override
            void draw() {
                10.outline("waves");
            }
        };

        protected String line = "";
        protected final Function<String, String> text;
        protected Array<String> sentences;
        protected final BooleanProvider done;

        private TutorialStage(Function<String, String> text, BooleanProvider done) {
            this.text = text;
            this.done = done;
        }

        private TutorialStage(BooleanProvider done) {
            this((String line) -> line, done);
        }

        public String text() {
            String line;
            if (this.sentences == null) {
                this.load();
            }
            return (line = this.sentences.get(Vars.control.tutorial.sentence)).contains("{") ? this.text.get(line) : line;
        }

        void load() {
            this.line = Core.bundle.has("tutorial." + this.name() + ".mobile") && Vars.mobile ? "tutorial." + this.name() + ".mobile" : "tutorial." + this.name();
            this.sentences = Array.select(Core.bundle.get(this.line).split("\n"), s -> !s.isEmpty());
        }

        void update() {
        }

        void begin() {
        }

        void draw() {
        }

        static void placeBlocks() {
            Tile core = Vars.state.teams.get((Team)Vars.defaultTeam).cores.first();
            for (int i = 0; i < 3; ++i) {
                Vars.world.removeBlock(Vars.world.ltile(core.x + -6, core.y + i));
                Vars.world.tile(core.x + -6, core.y + i).setBlock(Blocks.scrapWall, Vars.defaultTeam);
            }
        }

        static boolean blocksBroken() {
            Tile core = Vars.state.teams.get((Team)Vars.defaultTeam).cores.first();
            for (int i = 0; i < 3; ++i) {
                if (Vars.world.tile(core.x + -6, core.y + i).block() != Blocks.scrapWall) continue;
                return false;
            }
            return true;
        }

        static boolean event(String name) {
            return Vars.control.tutorial.events.contains(name);
        }

        static boolean placed(Block block, int amount) {
            return TutorialStage.placed(block) >= amount;
        }

        static int placed(Block block) {
            return Vars.control.tutorial.blocksPlaced.get(block, 0);
        }

        static int item(Item item) {
            return Vars.state.teams.get((Team)Vars.defaultTeam).cores.isEmpty() ? 0 : Vars.state.teams.get((Team)Vars.defaultTeam).cores.first().entity.items.get(item);
        }

        static boolean toggled(String name) {
            Element element = Core.scene.findVisible(name);
            if (element instanceof Button) {
                return ((Button)element).isChecked();
            }
            return false;
        }

        static void outline(String name) {
            Element element = Core.scene.findVisible(name);
            if (element != null && !TutorialStage.toggled(name)) {
                element.localToStageCoordinates(Tmp.v1.setZero());
                float sin = Mathf.sin(11.0f, Scl.scl(4.0f));
                Lines.stroke(Scl.scl(7.0f), Pal.place);
                Lines.rect(Tmp.v1.x - sin, Tmp.v1.y - sin, element.getWidth() + sin * 2.0f, element.getHeight() + sin * 2.0f);
                float size = Math.max(element.getWidth(), element.getHeight()) + Mathf.absin(5.5f, Scl.scl(18.0f));
                float angle = Angles.angle((float)Core.graphics.getWidth() / 2.0f, (float)Core.graphics.getHeight() / 2.0f, Tmp.v1.x + element.getWidth() / 2.0f, Tmp.v1.y + element.getHeight() / 2.0f);
                Tmp.v2.trns(angle + 180.0f, size * 1.4f);
                float fs = Scl.scl(40.0f);
                float fs2 = Scl.scl(56.0f);
                Draw.color(Pal.gray);
                Drawf.tri(Tmp.v1.x + element.getWidth() / 2.0f + Tmp.v2.x, Tmp.v1.y + element.getHeight() / 2.0f + Tmp.v2.y, fs2, fs2, angle);
                Draw.color(Pal.place);
                Tmp.v2.setLength(Tmp.v2.len() - Scl.scl(4.0f));
                Drawf.tri(Tmp.v1.x + element.getWidth() / 2.0f + Tmp.v2.x, Tmp.v1.y + element.getHeight() / 2.0f + Tmp.v2.y, fs, fs, angle);
                Draw.reset();
            }
        }
    }
}

