/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.game;

import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.EnumSet;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.arc.collection.Queue;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.world.Tile;

public class Teams {
    private TeamData[] map = new TeamData[Team.all.length];

    public void add(Team team, Team ... enemies) {
        this.map[team.ordinal()] = new TeamData(team, EnumSet.of((Enum[])enemies));
    }

    public TeamData get(Team team) {
        if (this.map[team.ordinal()] == null) {
            this.add(team, (Team[])Array.with(Team.all).select(t -> t != team).toArray(Team.class));
        }
        return this.map[team.ordinal()];
    }

    public boolean isActive(Team team) {
        return team == Vars.waveTeam || this.get((Team)team).cores.size > 0;
    }

    public EnumSet<Team> enemiesOf(Team team) {
        return this.get((Team)team).enemies;
    }

    public boolean areEnemies(Team team, Team other) {
        return this.enemiesOf(team).contains(other);
    }

    public Array<TeamData> getActive() {
        return Array.select(this.map, t -> t != null);
    }

    public static class BrokenBlock {
        public final short x;
        public final short y;
        public final short rotation;
        public final short block;
        public final int config;

        public BrokenBlock(short x, short y, short rotation, short block, int config) {
            this.x = x;
            this.y = y;
            this.rotation = rotation;
            this.block = block;
            this.config = config;
        }
    }

    public static class TeamData {
        public final ObjectSet<Tile> cores = new ObjectSet();
        public final EnumSet<Team> enemies;
        public final Team team;
        public Queue<BrokenBlock> brokenBlocks = new Queue();

        public TeamData(Team team, EnumSet<Team> enemies) {
            this.team = team;
            this.enemies = enemies;
        }
    }
}

