/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.game;

import io.anuke.arc.util.serialization.Json;
import io.anuke.arc.util.serialization.JsonValue;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.UnitTypes;
import io.anuke.mindustry.entities.type.BaseUnit;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.type.StatusEffect;
import io.anuke.mindustry.type.UnitType;

public class SpawnGroup
implements Json.Serializable {
    public static final int never = Integer.MAX_VALUE;
    public UnitType type;
    public int end = Integer.MAX_VALUE;
    public int begin;
    public int spacing = 1;
    public int max = 100;
    public float unitScaling = 2.1474836E9f;
    public int unitAmount = 1;
    public StatusEffect effect;
    public ItemStack items;

    public SpawnGroup(UnitType type) {
        this.type = type;
    }

    public SpawnGroup() {
    }

    public int getUnitsSpawned(int wave) {
        if (wave < this.begin || wave > this.end || (wave - this.begin) % this.spacing != 0) {
            return 0;
        }
        return Math.min(this.unitAmount + (int)((float)((wave - this.begin) / this.spacing) / this.unitScaling), this.max);
    }

    public BaseUnit createUnit(Team team) {
        BaseUnit unit = this.type.create(team);
        if (this.effect != null) {
            unit.applyEffect(this.effect, 999999.0f);
        }
        if (this.items != null) {
            unit.addItem(this.items.item, this.items.amount);
        }
        return unit;
    }

    @Override
    public void write(Json json) {
        json.writeValue("type", this.type.name);
        if (this.begin != 0) {
            json.writeValue("begin", this.begin);
        }
        if (this.end != Integer.MAX_VALUE) {
            json.writeValue("end", this.end);
        }
        if (this.spacing != 1) {
            json.writeValue("spacing", this.spacing);
        }
        if (this.unitScaling != 2.1474836E9f) {
            json.writeValue("scaling", Float.valueOf(this.unitScaling));
        }
        if (this.unitAmount != 1) {
            json.writeValue("amount", this.unitAmount);
        }
        if (this.effect != null) {
            json.writeValue("effect", this.effect.id);
        }
    }

    @Override
    public void read(Json json, JsonValue data) {
        this.type = (UnitType)Vars.content.getByName(ContentType.unit, data.getString("type", "dagger"));
        if (this.type == null) {
            this.type = UnitTypes.dagger;
        }
        this.begin = data.getInt("begin", 0);
        this.end = data.getInt("end", Integer.MAX_VALUE);
        this.spacing = data.getInt("spacing", 1);
        this.unitScaling = data.getFloat("scaling", 2.1474836E9f);
        this.unitAmount = data.getInt("amount", 1);
        this.effect = (StatusEffect)Vars.content.getByID(ContentType.status, data.getInt("effect", -1));
    }

    public String toString() {
        return "SpawnGroup{type=" + this.type + ", end=" + this.end + ", begin=" + this.begin + ", spacing=" + this.spacing + ", max=" + this.max + ", unitScaling=" + this.unitScaling + ", unitAmount=" + this.unitAmount + ", effect=" + this.effect + ", items=" + this.items + '}';
    }
}

