/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.game;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.assets.Loadable;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.IntMap;
import io.anuke.arc.collection.IntSet;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.collection.OrderedMap;
import io.anuke.arc.collection.OrderedSet;
import io.anuke.arc.collection.StringMap;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Pixmap;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.graphics.glutils.FrameBuffer;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.ScreenUtils;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.Tmp;
import io.anuke.arc.util.io.Streams;
import io.anuke.arc.util.serialization.Base64Coder;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.entities.traits.BuilderTrait;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Schematic;
import io.anuke.mindustry.input.PlaceUtils;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Pos;
import io.anuke.mindustry.world.Tile;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class Schematics
implements Loadable {
    private static final byte[] header = new byte[]{109, 115, 99, 104};
    private static final byte version = 0;
    private static final int padding = 2;
    private static final int resolution = 32;
    private Streams.OptimizedByteArrayOutputStream out = new Streams.OptimizedByteArrayOutputStream(1024);
    private Array<Schematic> all = new Array();
    private OrderedMap<Schematic, FrameBuffer> previews = new OrderedMap();
    private FrameBuffer shadowBuffer;

    public Schematics() {
        Events.on(EventType.DisposeEvent.class, e -> {
            this.previews.each((schem, m) -> m.dispose());
            this.previews.clear();
            this.shadowBuffer.dispose();
        });
    }

    @Override
    public void loadSync() {
        this.load();
    }

    public void load() {
        this.all.clear();
        for (FileHandle file : Vars.schematicDirectory.list()) {
            this.loadFile(file);
        }
        Vars.platform.getWorkshopContent(Schematic.class).each(this::loadFile);
        this.all.sort();
        Core.app.post(() -> {
            this.shadowBuffer = new FrameBuffer(42, 42);
        });
    }

    public void overwrite(Schematic target, Schematic newSchematic) {
        if (this.previews.containsKey(target)) {
            ((FrameBuffer)this.previews.get(target)).dispose();
            this.previews.remove(target);
        }
        target.tiles.clear();
        target.tiles.addAll(newSchematic.tiles);
        target.width = newSchematic.width;
        target.height = newSchematic.height;
        newSchematic.tags.putAll(target.tags);
        newSchematic.file = target.file;
        try {
            Schematics.write(newSchematic, target.file);
        }
        catch (Exception e) {
            Log.err(e);
            Vars.ui.showException(e);
        }
    }

    private void loadFile(FileHandle file) {
        if (!file.extension().equals("msch")) {
            return;
        }
        try {
            Schematic s = Schematics.read(file);
            this.all.add(s);
            if (!s.file.parent().equals(Vars.schematicDirectory)) {
                s.tags.put("steamid", s.file.parent().name());
            }
        }
        catch (IOException e) {
            Log.err(e);
        }
    }

    public Array<Schematic> all() {
        return this.all;
    }

    public void saveChanges(Schematic s) {
        if (s.file != null) {
            try {
                Schematics.write(s, s.file);
            }
            catch (Exception e) {
                Vars.ui.showException(e);
            }
        }
    }

    public void savePreview(Schematic schematic, FileHandle file) {
        FrameBuffer buffer = this.getBuffer(schematic);
        Draw.flush();
        buffer.begin();
        Pixmap pixmap = ScreenUtils.getFrameBufferPixmap(0, 0, buffer.getWidth(), buffer.getHeight());
        file.writePNG(pixmap);
        buffer.end();
    }

    public Texture getPreview(Schematic schematic) {
        return (Texture)this.getBuffer(schematic).getTexture();
    }

    public boolean hasPreview(Schematic schematic) {
        return this.previews.containsKey(schematic);
    }

    public FrameBuffer getBuffer(Schematic schematic) {
        if (!this.previews.containsKey(schematic)) {
            Draw.blend();
            Draw.reset();
            Tmp.m1.set(Draw.proj());
            Tmp.m2.set(Draw.trans());
            FrameBuffer buffer = new FrameBuffer((schematic.width + 2) * 32, (schematic.height + 2) * 32);
            this.shadowBuffer.beginDraw(Color.clear);
            Draw.trans().idt();
            Draw.proj().setOrtho(0.0f, 0.0f, this.shadowBuffer.getWidth(), this.shadowBuffer.getHeight());
            Draw.color();
            schematic.tiles.each(t -> {
                int size = t.block.size;
                int offsetx = -(size - 1) / 2;
                int offsety = -(size - 1) / 2;
                for (int dx = 0; dx < size; ++dx) {
                    for (int dy = 0; dy < size; ++dy) {
                        int wx = t.x + dx + offsetx;
                        int wy = t.y + dy + offsety;
                        Fill.square(1.0f + (float)wx + 0.5f, 1.0f + (float)wy + 0.5f, 0.5f);
                    }
                }
            });
            this.shadowBuffer.endDraw();
            buffer.beginDraw(Color.clear);
            Draw.proj().setOrtho(0.0f, buffer.getHeight(), buffer.getWidth(), -buffer.getHeight());
            Tmp.tr1.set((Texture)this.shadowBuffer.getTexture(), 0, 0, schematic.width + 2, schematic.height + 2);
            Draw.color(0.0f, 0.0f, 0.0f, 1.0f);
            Draw.rect(Tmp.tr1, (float)buffer.getWidth() / 2.0f, (float)buffer.getHeight() / 2.0f, (float)buffer.getWidth(), (float)(-buffer.getHeight()));
            Draw.color();
            Array<BuilderTrait.BuildRequest> requests = schematic.tiles.map(t -> new BuilderTrait.BuildRequest(t.x, t.y, t.rotation, t.block).configure(t.config));
            Draw.flush();
            Draw.trans().scale(4.0f, 4.0f).translate(12.0f, 12.0f);
            requests.each(req -> {
                req.animScale = 1.0f;
                req.worldContext = false;
                req.block.drawRequestRegion((BuilderTrait.BuildRequest)req, requests::each);
            });
            requests.each(req -> req.block.drawRequestConfigTop((BuilderTrait.BuildRequest)req, requests::each));
            Draw.flush();
            Draw.trans().idt();
            buffer.endDraw();
            Draw.proj(Tmp.m1);
            Draw.trans(Tmp.m2);
            this.previews.put(schematic, buffer);
        }
        return (FrameBuffer)this.previews.get(schematic);
    }

    public Array<BuilderTrait.BuildRequest> toRequests(Schematic schem, int x, int y) {
        return schem.tiles.map(t -> new BuilderTrait.BuildRequest(t.x + x - schem.width / 2, t.y + y - schem.height / 2, t.rotation, t.block).original(t.x, t.y, schem.width, schem.height).configure(t.config)).removeAll(s -> !s.block.isVisible());
    }

    public void add(Schematic schematic) {
        this.all.add(schematic);
        try {
            FileHandle file = Vars.schematicDirectory.child(Time.millis() + "." + "msch");
            Schematics.write(schematic, file);
            schematic.file = file;
        }
        catch (Exception e) {
            Vars.ui.showException(e);
            Log.err(e);
        }
    }

    public void remove(Schematic s) {
        this.all.remove(s);
        if (s.file != null) {
            s.file.delete();
        }
        if (this.previews.containsKey(s)) {
            ((FrameBuffer)this.previews.get(s)).dispose();
            this.previews.remove(s);
        }
    }

    public Schematic create(int x, int y, int x2, int y2) {
        PlaceUtils.NormalizeResult result = PlaceUtils.normalizeArea(x, y, x2, y2, 0, false, 32);
        x = result.x;
        y = result.y;
        x2 = result.x2;
        y2 = result.y2;
        int ox = x;
        int oy = y;
        int ox2 = x2;
        int oy2 = y2;
        Array<Schematic.Stile> tiles = new Array<Schematic.Stile>();
        int minx = x2;
        int miny = y2;
        int maxx = x;
        int maxy = y;
        boolean found = false;
        for (int cx = x; cx <= x2; ++cx) {
            for (int cy = y; cy <= y2; ++cy) {
                Tile linked = Vars.world.ltile(cx, cy);
                if (linked == null || linked.entity == null || !linked.entity.block.isVisible()) continue;
                int top = linked.block().size / 2;
                int bot = linked.block().size % 2 == 1 ? -linked.block().size / 2 : -(linked.block().size - 1) / 2;
                minx = Math.min(linked.x + bot, minx);
                miny = Math.min(linked.y + bot, miny);
                maxx = Math.max(linked.x + top, maxx);
                maxy = Math.max(linked.y + top, maxy);
                found = true;
            }
        }
        if (!found) {
            return new Schematic(new Array<Schematic.Stile>(), new StringMap(), 1, 1);
        }
        x = minx;
        y = miny;
        x2 = maxx;
        y2 = maxy;
        int width = x2 - x + 1;
        int height = y2 - y + 1;
        int offsetX = -x;
        int offsetY = -y;
        IntSet counted = new IntSet();
        for (int cx = ox; cx <= ox2; ++cx) {
            for (int cy = oy; cy <= oy2; ++cy) {
                Tile tile = Vars.world.ltile(cx, cy);
                if (tile == null || tile.entity == null || counted.contains(tile.pos())) continue;
                int config = tile.entity.config();
                if (tile.block().posConfig) {
                    config = Pos.get(Pos.x(config) + offsetX, Pos.y(config) + offsetY);
                }
                tiles.add(new Schematic.Stile(tile.block(), tile.x + offsetX, tile.y + offsetY, config, tile.rotation()));
                counted.add(tile.pos());
            }
        }
        return new Schematic(tiles, new StringMap(), width, height);
    }

    public String writeBase64(Schematic schematic) {
        try {
            this.out.reset();
            Schematics.write(schematic, this.out);
            return new String(Base64Coder.encode(this.out.getBuffer(), this.out.size()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Schematic readBase64(String schematic) throws IOException {
        return Schematics.read(new ByteArrayInputStream(Base64Coder.decode(schematic)));
    }

    public static Schematic read(FileHandle file) throws IOException {
        Schematic s = Schematics.read(new DataInputStream(file.read(1024)));
        if (!s.tags.containsKey("name")) {
            s.tags.put("name", file.nameWithoutExtension());
        }
        s.file = file;
        return s;
    }

    public static Schematic read(InputStream input) throws IOException {
        for (byte b : header) {
            if (input.read() == b) continue;
            throw new IOException("Not a schematic file (missing header).");
        }
        int ver = input.read();
        if (ver != 0) {
            throw new IOException("Unknown version: " + ver);
        }
        try (DataInputStream stream = new DataInputStream(new InflaterInputStream(input));){
            short width = stream.readShort();
            short height = stream.readShort();
            StringMap map = new StringMap();
            int tags = stream.readByte();
            for (int i = 0; i < tags; ++i) {
                map.put(stream.readUTF(), stream.readUTF());
            }
            IntMap<Block> blocks = new IntMap<Block>();
            int length = stream.readByte();
            for (int i = 0; i < length; ++i) {
                Block block = (Block)Vars.content.getByName(ContentType.block, stream.readUTF());
                blocks.put(i, block == null ? Blocks.air : block);
            }
            int total = stream.readInt();
            Array<Schematic.Stile> tiles = new Array<Schematic.Stile>(total);
            for (int i = 0; i < total; ++i) {
                Block block = (Block)blocks.get(stream.readByte());
                int position = stream.readInt();
                int config = stream.readInt();
                byte rotation = stream.readByte();
                if (block == Blocks.air) continue;
                tiles.add(new Schematic.Stile(block, Pos.x(position), Pos.y(position), config, rotation));
            }
            Schematic schematic = new Schematic(tiles, map, width, height);
            return schematic;
        }
    }

    public static void write(Schematic schematic, FileHandle file) throws IOException {
        Schematics.write(schematic, file.write(false, 1024));
    }

    /*
     * WARNING - void declaration
     */
    public static void write(Schematic schematic, OutputStream output) throws IOException {
        output.write(header);
        output.write(0);
        try (DataOutputStream stream = new DataOutputStream(new DeflaterOutputStream(output));){
            void var5_9;
            stream.writeShort(schematic.width);
            stream.writeShort(schematic.height);
            stream.writeByte(schematic.tags.size);
            for (ObjectMap.Entry entry : schematic.tags.entries()) {
                stream.writeUTF((String)entry.key);
                stream.writeUTF((String)entry.value);
            }
            OrderedSet blocks = new OrderedSet();
            schematic.tiles.each(t -> blocks.add(t.block));
            stream.writeByte(blocks.size);
            boolean bl = false;
            while (var5_9 < blocks.size) {
                stream.writeUTF(((Block)blocks.orderedItems().get((int)var5_9)).name);
                ++var5_9;
            }
            stream.writeInt(schematic.tiles.size);
            for (Schematic.Stile tile : schematic.tiles) {
                stream.writeByte(blocks.orderedItems().indexOf(tile.block));
                stream.writeInt(Pos.get(tile.x, tile.y));
                stream.writeInt(tile.config);
                stream.writeByte(tile.rotation);
            }
        }
    }
}

