/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.game;

import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.IntIntMap;
import io.anuke.arc.collection.StringMap;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.type.Publishable;
import io.anuke.mindustry.world.Block;

public class Schematic
implements Publishable,
Comparable<Schematic> {
    public final Array<Stile> tiles;
    public StringMap tags;
    public int width;
    public int height;
    @ArcAnnotate.Nullable
    public FileHandle file;

    public Schematic(Array<Stile> tiles, StringMap tags, int width, int height) {
        this.tiles = tiles;
        this.tags = tags;
        this.width = width;
        this.height = height;
    }

    public Array<ItemStack> requirements() {
        IntIntMap amounts = new IntIntMap();
        this.tiles.each(t -> {
            for (ItemStack stack : t.block.requirements) {
                amounts.getAndIncrement(stack.item.id, 0, stack.amount);
            }
        });
        Array<ItemStack> stacks = new Array<ItemStack>();
        for (IntIntMap.Entry ent : amounts.entries()) {
            stacks.add(new ItemStack(Vars.content.item(ent.key), ent.value));
        }
        stacks.sort();
        return stacks;
    }

    public String name() {
        return this.tags.get("name", "unknown");
    }

    public void save() {
        Vars.schematics.saveChanges(this);
    }

    @Override
    public String getSteamID() {
        return (String)this.tags.get("steamid");
    }

    @Override
    public void addSteamID(String id) {
        this.tags.put("steamid", id);
        this.save();
    }

    @Override
    public void removeSteamID() {
        this.tags.remove("steamid");
        this.save();
    }

    @Override
    public String steamTitle() {
        return this.name();
    }

    @Override
    public String steamDescription() {
        return null;
    }

    @Override
    public String steamTag() {
        return "schematic";
    }

    @Override
    public FileHandle createSteamFolder(String id) {
        FileHandle directory = Vars.tmpDirectory.child("schematic_" + id).child("schematic.msch");
        this.file.copyTo(directory);
        return directory;
    }

    @Override
    public FileHandle createSteamPreview(String id) {
        FileHandle preview = Vars.tmpDirectory.child("schematic_preview_" + id + ".png");
        Vars.schematics.savePreview(this, preview);
        return preview;
    }

    @Override
    public int compareTo(Schematic schematic) {
        return this.name().compareTo(schematic.name());
    }

    public static class Stile {
        @ArcAnnotate.NonNull
        public Block block;
        public short x;
        public short y;
        public int config;
        public byte rotation;

        public Stile(Block block, int x, int y, int config, byte rotation) {
            this.block = block;
            this.x = (short)x;
            this.y = (short)y;
            this.config = config;
            this.rotation = rotation;
        }
    }
}

