/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.game;

import io.anuke.arc.Core;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.mindustry.game.Objective;
import io.anuke.mindustry.type.Zone;
import io.anuke.mindustry.world.Block;

public class Objectives {

    public static abstract class ZoneObjective
    implements Objective {
        @ArcAnnotate.NonNull
        public Zone zone;
    }

    public static class Launched
    extends ZoneObjective {
        public Launched(Zone zone) {
            this.zone = zone;
        }

        protected Launched() {
        }

        @Override
        public boolean complete() {
            return this.zone.hasLaunched();
        }

        @Override
        public String display() {
            return Core.bundle.format("requirement.core", this.zone.localizedName);
        }
    }

    public static class ZoneWave
    extends ZoneObjective {
        public int wave;

        public ZoneWave(Zone zone, int wave) {
            this.zone = zone;
            this.wave = wave;
        }

        protected ZoneWave() {
        }

        @Override
        public boolean complete() {
            return this.zone.bestWave() >= this.wave;
        }

        @Override
        public String display() {
            return Core.bundle.format("requirement.wave", this.wave, this.zone.localizedName);
        }
    }

    public static class Unlock
    implements Objective {
        @ArcAnnotate.NonNull
        public Block block;

        public Unlock(Block block) {
            this.block = block;
        }

        protected Unlock() {
        }

        @Override
        public boolean complete() {
            return this.block.unlocked();
        }

        @Override
        public String display() {
            return Core.bundle.format("requirement.unlock", this.block.localizedName);
        }
    }

    public static class Wave
    implements Objective {
        public int wave;

        public Wave(int wave) {
            this.wave = wave;
        }

        protected Wave() {
        }

        @Override
        public boolean complete() {
            return false;
        }

        @Override
        public String display() {
            return null;
        }
    }
}

