/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.game;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.audio.Music;
import io.anuke.arc.collection.Array;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.arc.util.Interval;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.gen.Musics;

public class MusicControl {
    private static final float finTime = 120.0f;
    private static final float foutTime = 120.0f;
    private static final float musicInterval = 10800.0f;
    private static final float musicChance = 0.6f;
    private static final float musicWaveChance = 0.5f;
    public Array<Music> ambientMusic = Array.with(new Music[0]);
    public Array<Music> darkMusic = Array.with(new Music[0]);
    private Music lastRandomPlayed;
    private Interval timer = new Interval();
    @ArcAnnotate.Nullable
    private Music current;
    private float fade;
    private boolean silenced;

    public MusicControl() {
        Events.on(EventType.ClientLoadEvent.class, e -> this.reload());
        Events.on(EventType.ContentReloadEvent.class, e -> this.reload());
        Events.on(EventType.WaveEvent.class, e -> Time.run(600.0f, () -> {
            if (Mathf.chance(0.5)) {
                this.playRandom();
            }
        }));
    }

    private void reload() {
        this.current = null;
        this.fade = 0.0f;
        this.ambientMusic = Array.with(Musics.game1, Musics.game3, Musics.game4, Musics.game6);
        this.darkMusic = Array.with(Musics.game2, Musics.game5, Musics.game7);
    }

    public void update() {
        if (Vars.state.is(GameState.State.menu)) {
            this.silenced = false;
            if (Vars.ui.deploy.isShown()) {
                this.play(Musics.launch);
            } else if (Vars.ui.editor.isShown()) {
                this.play(Musics.editor);
            } else {
                this.play(Musics.menu);
            }
        } else if (Vars.state.rules.editor) {
            this.silenced = false;
            this.play(Musics.editor);
        } else {
            this.silence();
            if (this.timer.get(10800.0f) && Mathf.chance(0.6f)) {
                this.playRandom();
            }
        }
    }

    private void playRandom() {
        if (this.isDark()) {
            this.playOnce(this.darkMusic.random(this.lastRandomPlayed));
        } else {
            this.playOnce(this.ambientMusic.random(this.lastRandomPlayed));
        }
    }

    private boolean isDark() {
        if (!Vars.state.teams.get((Team)Vars.player.getTeam()).cores.isEmpty() && Vars.state.teams.get((Team)Vars.player.getTeam()).cores.first().entity.healthf() < 0.85f) {
            return true;
        }
        if (Mathf.chance((float)(Math.log10(((float)Vars.state.wave - 17.0f) / 19.0f) + 1.0) / 4.0f)) {
            return true;
        }
        return Mathf.chance((float)Vars.state.enemies() / 70.0f + 0.1f);
    }

    private void play(@ArcAnnotate.Nullable Music music) {
        if (this.current != null) {
            this.current.setVolume(this.fade * (float)Core.settings.getInt("musicvol") / 100.0f);
        }
        if (this.silenced) {
            return;
        }
        if (this.current == null && music != null) {
            this.current = music;
            this.current.setLooping(true);
            this.fade = 0.0f;
            this.current.setVolume(0.0f);
            this.current.play();
            this.silenced = false;
        } else if (this.current == music && music != null) {
            this.fade = Mathf.clamp(this.fade + Time.delta() / 120.0f);
        } else if (this.current != null) {
            this.fade = Mathf.clamp(this.fade - Time.delta() / 120.0f);
            if (this.fade <= 0.01f) {
                this.current.stop();
                this.current = null;
                this.silenced = true;
                if (music != null) {
                    this.current = music;
                    this.fade = 0.0f;
                    this.current.setVolume(0.0f);
                    this.current.setLooping(true);
                    this.current.play();
                    this.silenced = false;
                }
            }
        }
    }

    private void playOnce(Music music) {
        if (this.current != null || music == null) {
            return;
        }
        this.lastRandomPlayed = music;
        this.fade = 1.0f;
        this.current = music;
        this.current.setVolume(1.0f);
        this.current.setLooping(false);
        this.current.setCompletionListener(m -> {
            if (this.current == m) {
                this.current = null;
                this.fade = 0.0f;
            }
        });
        this.current.play();
    }

    private void silence() {
        this.play(null);
    }
}

