/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.game;

import io.anuke.arc.Core;
import io.anuke.arc.audio.Sound;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Position;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.mindustry.Vars;

public class LoopControl {
    private ObjectMap<Sound, SoundData> sounds = new ObjectMap();

    public void play(Sound sound, Position pos, float volume) {
        if (Vars.headless) {
            return;
        }
        float baseVol = sound.calcFalloff(pos.getX(), pos.getY());
        float vol = baseVol * volume;
        SoundData data = this.sounds.getOr(sound, () -> new SoundData());
        data.volume += vol;
        data.volume = Mathf.clamp(data.volume, 0.0f, 1.0f);
        data.total += baseVol;
        data.sum.add(pos.getX() * baseVol, pos.getY() * baseVol);
    }

    public void update() {
        float avol = (float)Core.settings.getInt("ambientvol", 100) / 100.0f;
        this.sounds.each((sound, data) -> {
            float pan;
            data.curVolume = Mathf.lerpDelta(data.curVolume, data.volume * avol, 0.2f);
            boolean play = data.curVolume > 0.01f;
            float f = pan = Mathf.isZero(data.total, 1.0E-4f) ? 0.0f : sound.calcPan(data.sum.x / data.total, data.sum.y / data.total);
            if (data.soundID <= 0) {
                if (play) {
                    data.soundID = sound.loop(data.curVolume, 1.0f, pan);
                }
            } else {
                if (data.curVolume <= 0.01f) {
                    sound.stop(data.soundID);
                    data.soundID = -1;
                    return;
                }
                sound.setPan(data.soundID, pan, data.curVolume);
            }
            data.volume = 0.0f;
            data.total = 0.0f;
            data.sum.setZero();
        });
    }

    private class SoundData {
        float volume;
        float total;
        Vector2 sum = new Vector2();
        int soundID;
        float curVolume;

        private SoundData() {
        }
    }
}

