/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.game;

import io.anuke.arc.Core;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.Predicate;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.game.Rules;
import io.anuke.mindustry.maps.Map;

public enum Gamemode {
    survival(rules -> {
        rules.waveTimer = true;
        rules.waves = true;
        rules.unitDrops = true;
    }, map -> map.spawns > 0),
    sandbox(rules -> {
        rules.infiniteResources = true;
        rules.waves = true;
        rules.waveTimer = false;
        rules.respawnTime = 0.0f;
    }),
    attack(rules -> {
        rules.unitDrops = true;
        rules.attackMode = true;
    }, map -> map.teams.contains(Vars.waveTeam.ordinal())),
    pvp(rules -> {
        rules.pvp = true;
        rules.enemyCoreBuildRadius = 600.0f;
        rules.respawnTime = 600.0f;
        rules.buildCostMultiplier = 1.0f;
        rules.buildSpeedMultiplier = 1.0f;
        rules.playerDamageMultiplier = 0.33f;
        rules.playerHealthMultiplier = 0.5f;
        rules.unitBuildSpeedMultiplier = 2.0f;
        rules.unitHealthMultiplier = 3.0f;
        rules.attackMode = true;
    }, map -> map.teams.size > 1),
    editor(true, rules -> {
        rules.infiniteResources = true;
        rules.editor = true;
        rules.waves = false;
        rules.enemyCoreBuildRadius = 0.0f;
        rules.waveTimer = false;
        rules.respawnTime = 0.0f;
    });

    private final Consumer<Rules> rules;
    private final Predicate<Map> validator;
    public final boolean hidden;
    public static final Gamemode[] all;

    private Gamemode(Consumer<Rules> rules) {
        this(false, rules);
    }

    private Gamemode(boolean hidden, Consumer<Rules> rules) {
        this(hidden, rules, m -> true);
    }

    private Gamemode(Consumer<Rules> rules, Predicate<Map> validator) {
        this(false, rules, validator);
    }

    private Gamemode(boolean hidden, Consumer<Rules> rules, Predicate<Map> validator) {
        this.rules = rules;
        this.hidden = hidden;
        this.validator = validator;
    }

    public static Gamemode bestFit(Rules rules) {
        if (rules.pvp) {
            return pvp;
        }
        if (rules.editor) {
            return editor;
        }
        if (rules.attackMode) {
            return attack;
        }
        if (rules.infiniteResources) {
            return sandbox;
        }
        return survival;
    }

    public Rules apply(Rules in) {
        this.rules.accept(in);
        return in;
    }

    public boolean valid(Map map) {
        return this.validator.test(map);
    }

    public String description() {
        return Core.bundle.get("mode." + this.name() + ".description");
    }

    public String toString() {
        return Core.bundle.get("mode." + this.name() + ".name");
    }

    static {
        all = Gamemode.values();
    }
}

