/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.game;

import io.anuke.arc.util.ArcAnnotate;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.ctype.UnlockableContent;
import io.anuke.mindustry.entities.traits.BuilderTrait;
import io.anuke.mindustry.entities.type.BaseUnit;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.entities.units.UnitCommand;
import io.anuke.mindustry.game.Objective;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.type.Mech;
import io.anuke.mindustry.type.Zone;
import io.anuke.mindustry.world.Tile;

public class EventType {

    public static class PlayerLeave {
        public final Player player;

        public PlayerLeave(Player player) {
            this.player = player;
        }
    }

    public static class PlayerConnect {
        public final Player player;

        public PlayerConnect(Player player) {
            this.player = player;
        }
    }

    public static class PlayerJoin {
        public final Player player;

        public PlayerJoin(Player player) {
            this.player = player;
        }
    }

    public static class MechChangeEvent {
        public final Player player;
        public final Mech mech;

        public MechChangeEvent(Player player, Mech mech) {
            this.player = player;
            this.mech = mech;
        }
    }

    public static class ResizeEvent {
    }

    public static class UnitCreateEvent {
        public final BaseUnit unit;

        public UnitCreateEvent(BaseUnit unit) {
            this.unit = unit;
        }
    }

    public static class UnitDestroyEvent {
        public final Unit unit;

        public UnitDestroyEvent(Unit unit) {
            this.unit = unit;
        }
    }

    public static class BlockDestroyEvent {
        public final Tile tile;

        public BlockDestroyEvent(Tile tile) {
            this.tile = tile;
        }
    }

    public static class BuildSelectEvent {
        public final Tile tile;
        public final Team team;
        public final BuilderTrait builder;
        public final boolean breaking;

        public BuildSelectEvent(Tile tile, Team team, BuilderTrait builder, boolean breaking) {
            this.tile = tile;
            this.team = team;
            this.builder = builder;
            this.breaking = breaking;
        }
    }

    public static class BlockBuildEndEvent {
        public final Tile tile;
        public final Team team;
        @ArcAnnotate.Nullable
        public final Player player;
        public final boolean breaking;

        public BlockBuildEndEvent(Tile tile, @ArcAnnotate.Nullable Player player, Team team, boolean breaking) {
            this.tile = tile;
            this.team = team;
            this.player = player;
            this.breaking = breaking;
        }
    }

    public static class BlockBuildBeginEvent {
        public final Tile tile;
        public final Team team;
        public final boolean breaking;

        public BlockBuildBeginEvent(Tile tile, Team team, boolean breaking) {
            this.tile = tile;
            this.team = team;
            this.breaking = breaking;
        }
    }

    public static class ResearchEvent {
        public final UnlockableContent content;

        public ResearchEvent(UnlockableContent content) {
            this.content = content;
        }
    }

    public static class UnlockEvent {
        public final UnlockableContent content;

        public UnlockEvent(UnlockableContent content) {
            this.content = content;
        }
    }

    public static class StateChangeEvent {
        public final GameState.State from;
        public final GameState.State to;

        public StateChangeEvent(GameState.State from, GameState.State to) {
            this.from = from;
            this.to = to;
        }
    }

    public static class TileChangeEvent {
        public final Tile tile;

        public TileChangeEvent(Tile tile) {
            this.tile = tile;
        }
    }

    public static class WorldLoadEvent {
    }

    public static class GameOverEvent {
        public final Team winner;

        public GameOverEvent(Team winner) {
            this.winner = winner;
        }
    }

    public static class DepositEvent {
        public final Tile tile;
        public final Player player;

        public DepositEvent(Tile tile, Player player) {
            this.tile = tile;
            this.player = player;
        }
    }

    public static class WithdrawEvent {
    }

    public static class BlockInfoEvent {
    }

    public static class CoreItemDeliverEvent {
    }

    public static class TurretAmmoDeliverEvent {
    }

    public static class LineConfirmEvent {
    }

    public static class WaveEvent {
    }

    public static class ResetEvent {
    }

    public static class PlayEvent {
    }

    public static class DisposeEvent {
    }

    public static class ContentReloadEvent {
    }

    public static class ClientLoadEvent {
    }

    public static class ZoneConfigureCompleteEvent {
        public final Zone zone;

        public ZoneConfigureCompleteEvent(Zone zone) {
            this.zone = zone;
        }
    }

    public static class ZoneRequireCompleteEvent {
        public final Zone zoneMet;
        public final Zone zoneForMet;
        public final Objective objective;

        public ZoneRequireCompleteEvent(Zone zoneMet, Zone zoneForMet, Objective objective) {
            this.zoneMet = zoneMet;
            this.zoneForMet = zoneForMet;
            this.objective = objective;
        }
    }

    public static class PlayerChatEvent {
        public final Player player;
        public final String message;

        public PlayerChatEvent(Player player, String message) {
            this.player = player;
            this.message = message;
        }
    }

    public static class CommandIssueEvent {
        public final Tile tile;
        public final UnitCommand command;

        public CommandIssueEvent(Tile tile, UnitCommand command) {
            this.tile = tile;
            this.command = command;
        }
    }

    public static class MapPublishEvent {
    }

    public static class MapMakeEvent {
    }

    public static class LaunchEvent {
    }

    public static class LoseEvent {
    }

    public static class WinEvent {
    }

    public static enum Trigger {
        shock,
        phaseDeflectHit,
        impactPower,
        thoriumReactorOverheat,
        itemLaunch,
        fireExtinguish,
        newGame,
        tutorialComplete,
        flameAmmo,
        turretCool,
        enablePixelation,
        drown,
        exclusionDeath,
        suicideBomb,
        openWiki;

    }
}

