/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.type.base;

import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Structs;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.entities.traits.MinerTrait;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.type.base.BaseDrone;
import io.anuke.mindustry.entities.units.UnitState;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemType;
import io.anuke.mindustry.world.Pos;
import io.anuke.mindustry.world.Tile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MinerDrone
extends BaseDrone
implements MinerTrait {
    protected Item targetItem;
    protected Tile mineTile;
    public final UnitState mine = new UnitState(){

        @Override
        public void entered() {
            MinerDrone.this.target = null;
        }

        @Override
        public void update() {
            TileEntity entity = MinerDrone.this.getClosestCore();
            if (entity == null) {
                return;
            }
            MinerDrone.this.findItem();
            if (MinerDrone.this.targetItem != null && entity.block.acceptStack(MinerDrone.this.targetItem, 1, entity.tile, MinerDrone.this) == 0) {
                MinerDrone.this.clearItem();
                return;
            }
            if (((MinerDrone)MinerDrone.this).item.amount >= MinerDrone.this.getItemCapacity() || MinerDrone.this.targetItem != null && !MinerDrone.this.acceptsItem(MinerDrone.this.targetItem)) {
                MinerDrone.this.setState(MinerDrone.this.drop);
            } else {
                if (MinerDrone.this.retarget() && MinerDrone.this.targetItem != null) {
                    MinerDrone.this.target = Vars.indexer.findClosestOre(MinerDrone.this.x, MinerDrone.this.y, MinerDrone.this.targetItem);
                }
                if (MinerDrone.this.target instanceof Tile) {
                    MinerDrone.this.moveTo(((MinerDrone)MinerDrone.this).type.range / 1.5f);
                    if (MinerDrone.this.dst(MinerDrone.this.target) < ((MinerDrone)MinerDrone.this).type.range && MinerDrone.this.mineTile != MinerDrone.this.target) {
                        MinerDrone.this.setMineTile((Tile)MinerDrone.this.target);
                    }
                    if (((Tile)MinerDrone.this.target).block() != Blocks.air) {
                        MinerDrone.this.setState(MinerDrone.this.drop);
                    }
                } else if (MinerDrone.this.getSpawner() != null) {
                    MinerDrone.this.target = MinerDrone.this.getSpawner();
                    MinerDrone.this.circle(40.0f);
                }
            }
        }

        @Override
        public void exited() {
            MinerDrone.this.setMineTile(null);
        }
    };
    public final UnitState drop = new UnitState(){

        @Override
        public void entered() {
            MinerDrone.this.target = null;
        }

        @Override
        public void update() {
            if (((MinerDrone)MinerDrone.this).item.amount == 0 || ((MinerDrone)MinerDrone.this).item.item.type != ItemType.material) {
                MinerDrone.this.clearItem();
                MinerDrone.this.setState(MinerDrone.this.mine);
                return;
            }
            MinerDrone.this.target = MinerDrone.this.getClosestCore();
            if (MinerDrone.this.target == null) {
                return;
            }
            TileEntity tile = (TileEntity)MinerDrone.this.target;
            if (MinerDrone.this.dst(MinerDrone.this.target) < ((MinerDrone)MinerDrone.this).type.range) {
                if (tile.tile.block().acceptStack(((MinerDrone)MinerDrone.this).item.item, ((MinerDrone)MinerDrone.this).item.amount, tile.tile, MinerDrone.this) > 0) {
                    Call.transferItemTo(((MinerDrone)MinerDrone.this).item.item, ((MinerDrone)MinerDrone.this).item.amount, MinerDrone.this.x, MinerDrone.this.y, tile.tile);
                }
                MinerDrone.this.clearItem();
                MinerDrone.this.setState(MinerDrone.this.mine);
            }
            MinerDrone.this.circle(((MinerDrone)MinerDrone.this).type.range / 1.8f);
        }
    };

    @Override
    public UnitState getStartState() {
        return this.mine;
    }

    @Override
    public void update() {
        super.update();
        this.updateMining();
    }

    @Override
    protected void updateRotation() {
        this.rotation = this.mineTile != null && this.shouldRotate() && this.mineTile.dst(this) < this.type.range ? Mathf.slerpDelta(this.rotation, this.angleTo(this.mineTile), 0.3f) : Mathf.slerpDelta(this.rotation, this.velocity.angle(), 0.3f);
    }

    @Override
    public boolean shouldRotate() {
        return this.isMining();
    }

    @Override
    public void drawOver() {
        this.drawMining();
    }

    @Override
    public boolean canMine(Item item) {
        return this.type.toMine.contains(item);
    }

    @Override
    public float getMinePower() {
        return this.type.minePower;
    }

    @Override
    public Tile getMineTile() {
        return this.mineTile;
    }

    @Override
    public void setMineTile(Tile tile) {
        this.mineTile = tile;
    }

    @Override
    public void write(DataOutput data) throws IOException {
        super.write(data);
        data.writeInt(this.mineTile == null || !this.state.is(this.mine) ? Pos.invalid : this.mineTile.pos());
    }

    @Override
    public void read(DataInput data) throws IOException {
        super.read(data);
        this.mineTile = Vars.world.tile(data.readInt());
    }

    protected void findItem() {
        TileEntity entity = this.getClosestCore();
        if (entity == null) {
            return;
        }
        this.targetItem = Structs.findMin(this.type.toMine, Vars.indexer::hasOre, (a, b) -> -Integer.compare(entity.items.get((Item)a), entity.items.get((Item)b)));
    }
}

