/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.type.base;

import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.ai.Pathfinder;
import io.anuke.mindustry.entities.Predict;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.entities.type.BaseUnit;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.units.UnitCommand;
import io.anuke.mindustry.entities.units.UnitState;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.type.Weapon;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.Floor;
import io.anuke.mindustry.world.meta.BlockFlag;
import java.util.Iterator;

public class GroundUnit
extends BaseUnit {
    protected static Vector2 vec = new Vector2();
    protected float walkTime;
    protected float stuckTime;
    protected float baseRotation;
    public final UnitState attack = new UnitState(){

        @Override
        public void entered() {
            GroundUnit.this.target = null;
        }

        @Override
        public void update() {
            TileEntity core = GroundUnit.this.getClosestEnemyCore();
            if (core == null) {
                Tile closestSpawn = GroundUnit.this.getClosestSpawner();
                if (closestSpawn == null || !GroundUnit.this.withinDst(closestSpawn, Vars.state.rules.dropZoneRadius + 85.0f)) {
                    GroundUnit.this.moveToCore(Pathfinder.PathTarget.enemyCores);
                }
            } else {
                float dst = GroundUnit.this.dst(core);
                if (dst < GroundUnit.this.getWeapon().bullet.range() / 1.1f) {
                    GroundUnit.this.target = core;
                }
                if (dst > GroundUnit.this.getWeapon().bullet.range() * 0.5f) {
                    GroundUnit.this.moveToCore(Pathfinder.PathTarget.enemyCores);
                }
            }
        }
    };
    public final UnitState rally = new UnitState(){

        @Override
        public void update() {
            Tile target = GroundUnit.this.getClosest(BlockFlag.rally);
            if (target != null && GroundUnit.this.dst(target) > 80.0f) {
                GroundUnit.this.moveToCore(Pathfinder.PathTarget.rallyPoints);
            }
        }
    };
    public final UnitState retreat = new UnitState(){

        @Override
        public void entered() {
            GroundUnit.this.target = null;
        }

        @Override
        public void update() {
            GroundUnit.this.moveAwayFromCore();
        }
    };

    @Override
    public void onCommand(UnitCommand command) {
        this.state.set(command == UnitCommand.retreat ? this.retreat : (command == UnitCommand.attack ? this.attack : (command == UnitCommand.rally ? this.rally : null)));
    }

    @Override
    public void interpolate() {
        super.interpolate();
        if (this.interpolator.values.length > 1) {
            this.baseRotation = this.interpolator.values[1];
        }
    }

    @Override
    public void move(float x, float y) {
        float dst = Mathf.dst(x, y);
        if (dst > 0.01f) {
            this.baseRotation = Mathf.slerp(this.baseRotation, Mathf.angle(x, y), this.type.baseRotateSpeed * (dst / this.type.speed));
        }
        super.move(x, y);
    }

    @Override
    public UnitState getStartState() {
        return this.attack;
    }

    @Override
    public void update() {
        super.update();
        float f = this.stuckTime = !vec.set(this.x, this.y).sub(this.lastPosition()).isZero(1.0E-4f) ? 0.0f : this.stuckTime + Time.delta();
        if (!this.velocity.isZero()) {
            this.baseRotation = Mathf.slerpDelta(this.baseRotation, this.velocity.angle(), 0.05f);
        }
        if (this.stuckTime < 1.0f) {
            this.walkTime += Time.delta();
        }
    }

    @Override
    public Weapon getWeapon() {
        return this.type.weapon;
    }

    @Override
    public void draw() {
        Draw.mixcol(Color.white, this.hitTime / 9.0f);
        float ft = Mathf.sin(this.walkTime * this.type.speed * 5.0f, 6.0f, 2.0f + this.type.hitsize / 15.0f);
        Floor floor = this.getFloorOn();
        if (floor.isLiquid) {
            Draw.color(Color.white, floor.color, 0.5f);
        }
        for (int i : Mathf.signs) {
            Draw.rect(this.type.legRegion, this.x + Angles.trnsx(this.baseRotation, ft * (float)i), this.y + Angles.trnsy(this.baseRotation, ft * (float)i), (float)(this.type.legRegion.getWidth() * i) * Draw.scl, (float)this.type.legRegion.getHeight() * Draw.scl - Mathf.clamp(ft * (float)i, 0.0f, 2.0f), this.baseRotation - 90.0f);
        }
        if (floor.isLiquid) {
            Draw.color(Color.white, floor.color, this.drownTime * 0.4f);
        } else {
            Draw.color(Color.white);
        }
        Draw.rect(this.type.baseRegion, this.x, this.y, this.baseRotation - 90.0f);
        Draw.rect(this.type.region, this.x, this.y, this.rotation - 90.0f);
        for (int i : Mathf.signs) {
            float tra = this.rotation - 90.0f;
            float trY = -this.type.weapon.getRecoil(this, i > 0) + this.type.weaponOffsetY;
            float w = (float)(-i * this.type.weapon.region.getWidth()) * Draw.scl;
            Draw.rect(this.type.weapon.region, this.x + Angles.trnsx(tra, this.getWeapon().width * (float)i, trY), this.y + Angles.trnsy(tra, this.getWeapon().width * (float)i, trY), w, (float)this.type.weapon.region.getHeight() * Draw.scl, this.rotation - 90.0f);
        }
        Draw.mixcol();
    }

    @Override
    public void behavior() {
        if (!Units.invalidateTarget(this.target, this) && this.dst(this.target) < this.getWeapon().bullet.range()) {
            this.rotate(this.angleTo(this.target));
            if (Angles.near(this.angleTo(this.target), this.rotation, 13.0f)) {
                BulletType ammo = this.getWeapon().bullet;
                Vector2 to = Predict.intercept(this, this.target, ammo.speed);
                this.getWeapon().update(this, to.x, to.y);
            }
        }
    }

    @Override
    public void updateTargeting() {
        super.updateTargeting();
        if (Units.invalidateTarget(this.target, this.team, this.x, this.y, Float.MAX_VALUE)) {
            this.target = null;
        }
        if (this.retarget()) {
            this.targetClosest();
        }
    }

    protected void patrol() {
        vec.trns(this.baseRotation, this.type.speed * Time.delta());
        this.velocity.add(GroundUnit.vec.x, GroundUnit.vec.y);
        vec.trns(this.baseRotation, this.type.hitsizeTile * 5.0f);
        Tile tile = Vars.world.tileWorld(this.x + GroundUnit.vec.x, this.y + GroundUnit.vec.y);
        if (tile == null || tile.solid() || tile.floor().drownTime > 0.0f || tile.floor().isLiquid || this.stuckTime > 10.0f) {
            this.baseRotation += (float)Mathf.sign((float)(this.id % 2) - 0.5f) * Time.delta() * 3.0f;
        }
        this.rotation = Mathf.slerpDelta(this.rotation, this.velocity.angle(), this.type.rotatespeed);
    }

    protected void circle(float circleLength) {
        if (this.target == null) {
            return;
        }
        vec.set(this.target.getX() - this.x, this.target.getY() - this.y);
        if (vec.len() < circleLength) {
            vec.rotate((circleLength - vec.len()) / circleLength * 180.0f);
        }
        vec.setLength(this.type.speed * Time.delta());
        this.velocity.add(vec);
    }

    protected void moveToCore(Pathfinder.PathTarget path) {
        Tile tile = Vars.world.tileWorld(this.x, this.y);
        if (tile == null) {
            return;
        }
        Tile targetTile = Vars.pathfinder.getTargetTile(tile, this.team, path);
        if (tile == targetTile) {
            return;
        }
        this.velocity.add(vec.trns(this.angleTo(targetTile), this.type.speed * Time.delta()));
        if (Units.invalidateTarget(this.target, this)) {
            this.rotation = Mathf.slerpDelta(this.rotation, this.baseRotation, this.type.rotatespeed);
        }
    }

    protected void moveAwayFromCore() {
        Team team;
        Team enemy = null;
        Iterator<Team> iterator = Vars.state.teams.enemiesOf(this.team).iterator();
        while (iterator.hasNext()) {
            team = iterator.next();
            if (!Vars.state.teams.isActive(team)) continue;
            enemy = team;
            break;
        }
        if (enemy == null && (iterator = Vars.state.teams.enemiesOf(this.team).iterator()).hasNext()) {
            enemy = team = iterator.next();
        }
        if (enemy == null) {
            return;
        }
        Tile tile = Vars.world.tileWorld(this.x, this.y);
        if (tile == null) {
            return;
        }
        Tile targetTile = Vars.pathfinder.getTargetTile(tile, enemy, Pathfinder.PathTarget.enemyCores);
        TileEntity core = this.getClosestCore();
        if (tile == targetTile || core == null || this.dst(core) < 120.0f) {
            return;
        }
        this.velocity.add(vec.trns(this.angleTo(targetTile), this.type.speed * Time.delta()));
        this.rotation = Mathf.slerpDelta(this.rotation, this.baseRotation, this.type.rotatespeed);
    }
}

