/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.type;

import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.arc.math.geom.Point2;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.arc.util.Interval;
import io.anuke.arc.util.Pack;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.EntityGroup;
import io.anuke.mindustry.entities.traits.HealthTrait;
import io.anuke.mindustry.entities.traits.TargetTrait;
import io.anuke.mindustry.entities.type.BaseEntity;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.SoundLoop;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Edges;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.modules.ConsumeModule;
import io.anuke.mindustry.world.modules.ItemModule;
import io.anuke.mindustry.world.modules.LiquidModule;
import io.anuke.mindustry.world.modules.PowerModule;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class TileEntity
extends BaseEntity
implements TargetTrait,
HealthTrait {
    public static final float timeToSleep = 240.0f;
    private static final ObjectSet<Tile> tmpTiles = new ObjectSet();
    public static int sleepingEntities = 0;
    public Tile tile;
    public Block block;
    public Interval timer;
    public float health;
    public float timeScale = 1.0f;
    public float timeScaleDuration;
    public PowerModule power;
    public ItemModule items;
    public LiquidModule liquids;
    public ConsumeModule cons;
    private Array<Tile> proximity = new Array(8);
    private boolean dead = false;
    private boolean sleeping;
    private float sleepTime;
    @ArcAnnotate.Nullable
    private SoundLoop sound;

    public static void onTileDamage(Tile tile, float health) {
        if (tile.entity != null) {
            tile.entity.health = health;
            if (tile.entity.damaged()) {
                Vars.indexer.notifyTileDamaged(tile.entity);
            }
        }
    }

    public static void onTileDestroyed(Tile tile) {
        if (tile.entity == null) {
            return;
        }
        tile.entity.onDeath();
    }

    public TileEntity init(Tile tile, boolean shouldAdd) {
        this.tile = tile;
        this.x = tile.drawx();
        this.y = tile.drawy();
        this.block = tile.block();
        if (this.block.activeSound != Sounds.none) {
            this.sound = new SoundLoop(this.block.activeSound, this.block.activeSoundVolume);
        }
        this.health = this.block.health;
        this.timer = new Interval(this.block.timers);
        if (shouldAdd) {
            this.add();
        }
        return this;
    }

    public float delta() {
        return Time.delta() * this.timeScale;
    }

    public void sleep() {
        this.sleepTime += Time.delta();
        if (!this.sleeping && this.sleepTime >= 240.0f) {
            this.remove();
            this.sleeping = true;
            ++sleepingEntities;
        }
    }

    public void noSleep() {
        this.sleepTime = 0.0f;
        if (this.sleeping) {
            this.add();
            this.sleeping = false;
            --sleepingEntities;
        }
    }

    public boolean isSleeping() {
        return this.sleeping;
    }

    @Override
    public boolean isDead() {
        return this.dead || this.tile.entity != this;
    }

    public void write(DataOutput stream) throws IOException {
        stream.writeShort((short)this.health);
        stream.writeByte(Pack.byteByte(this.tile.getTeamID(), this.tile.rotation()));
        if (this.items != null) {
            this.items.write(stream);
        }
        if (this.power != null) {
            this.power.write(stream);
        }
        if (this.liquids != null) {
            this.liquids.write(stream);
        }
        if (this.cons != null) {
            this.cons.write(stream);
        }
    }

    public void read(DataInput stream, byte revision) throws IOException {
        this.health = stream.readUnsignedShort();
        byte tr = stream.readByte();
        byte team = Pack.leftByte(tr);
        byte rotation = Pack.rightByte(tr);
        this.tile.setTeam(Team.all[team]);
        this.tile.rotation(rotation);
        if (this.items != null) {
            this.items.read(stream);
        }
        if (this.power != null) {
            this.power.read(stream);
        }
        if (this.liquids != null) {
            this.liquids.read(stream);
        }
        if (this.cons != null) {
            this.cons.read(stream);
        }
    }

    public byte version() {
        return 0;
    }

    public boolean collide(Bullet other) {
        return true;
    }

    public void collision(Bullet other) {
        this.block.handleBulletHit(this, other);
    }

    public void kill() {
        Call.onTileDestroyed(this.tile);
    }

    @Override
    public void damage(float damage) {
        if (this.dead) {
            return;
        }
        float preHealth = this.health;
        Call.onTileDamage(this.tile, this.health - this.block.handleDamage(this.tile, damage));
        if (this.health <= 0.0f) {
            Call.onTileDestroyed(this.tile);
        }
        if (preHealth >= this.maxHealth() - 1.0E-5f && this.health < this.maxHealth() && Vars.world != null) {
            Vars.indexer.notifyTileDamaged(this);
        }
    }

    public Tile getTile() {
        return this.tile;
    }

    public void removeFromProximity() {
        Point2[] nearby;
        this.block.onProximityRemoved(this.tile);
        for (Point2 point : nearby = Edges.getEdges(this.block.size)) {
            Tile other = Vars.world.ltile(this.tile.x + point.x, this.tile.y + point.y);
            if (other == null) continue;
            other.block().onProximityUpdate(other);
            if (other.entity == null) continue;
            other.entity.proximity.removeValue(this.tile, true);
        }
    }

    public void updateProximity() {
        tmpTiles.clear();
        this.proximity.clear();
        Point2[] nearby = Edges.getEdges(this.block.size);
        for (Point2 point : nearby) {
            Tile other = Vars.world.ltile(this.tile.x + point.x, this.tile.y + point.y);
            if (other == null || other.entity == null || !other.interactable(this.tile.getTeam())) continue;
            if (!other.entity.proximity.contains(this.tile, true)) {
                other.entity.proximity.add(this.tile);
            }
            tmpTiles.add(other);
        }
        for (Tile tile : tmpTiles) {
            this.proximity.add(tile);
        }
        this.block.onProximityAdded(this.tile);
        this.block.onProximityUpdate(this.tile);
        for (Tile other : tmpTiles) {
            other.block().onProximityUpdate(other);
        }
    }

    public Array<Tile> proximity() {
        return this.proximity;
    }

    public int config() {
        return 0;
    }

    @Override
    public void removed() {
        if (this.sound != null) {
            this.sound.stop();
        }
    }

    @Override
    public void health(float health) {
        this.health = health;
    }

    @Override
    public float health() {
        return this.health;
    }

    @Override
    public float maxHealth() {
        return this.block.health;
    }

    @Override
    public void setDead(boolean dead) {
        this.dead = dead;
    }

    @Override
    public void onDeath() {
        if (!this.dead) {
            this.dead = true;
            Events.fire(new EventType.BlockDestroyEvent(this.tile));
            this.block.breakSound.at(this.tile);
            this.block.onDestroyed(this.tile);
            Vars.world.removeBlock(this.tile);
            this.remove();
        }
    }

    @Override
    public Team getTeam() {
        return this.tile.getTeam();
    }

    @Override
    public Vector2 velocity() {
        return Vector2.ZERO;
    }

    @Override
    public void update() {
        this.timeScaleDuration -= Time.delta();
        if (this.timeScaleDuration <= 0.0f || !this.block.canOverdrive) {
            this.timeScale = 1.0f;
        }
        if (this.health <= 0.0f) {
            this.onDeath();
            return;
        }
        if (this.sound != null) {
            this.sound.update(this.x, this.y, this.block.shouldActiveSound(this.tile));
        }
        if (this.block.idleSound != Sounds.none && this.block.shouldIdleSound(this.tile)) {
            Vars.loops.play(this.block.idleSound, this, this.block.idleSoundVolume);
        }
        Block previous = this.block;
        this.block.update(this.tile);
        if (this.block == previous && this.cons != null) {
            this.cons.update();
        }
        if (this.block == previous && this.power != null) {
            this.power.graph.update();
        }
    }

    @Override
    public boolean isValid() {
        return !this.isDead() && this.tile.entity == this;
    }

    @Override
    public EntityGroup targetGroup() {
        return Vars.tileGroup;
    }

    @Override
    public String toString() {
        return "TileEntity{tile=" + this.tile + ", health=" + this.health + '}';
    }
}

