/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.type;

import io.anuke.mindustry.entities.traits.DamageTrait;
import io.anuke.mindustry.entities.traits.HealthTrait;
import io.anuke.mindustry.entities.traits.SolidTrait;
import io.anuke.mindustry.entities.type.SolidEntity;

public abstract class DestructibleEntity
extends SolidEntity
implements HealthTrait {
    public transient boolean dead;
    public float health;

    @Override
    public boolean collides(SolidTrait other) {
        return other instanceof DamageTrait;
    }

    @Override
    public void collision(SolidTrait other, float x, float y) {
        if (other instanceof DamageTrait) {
            boolean wasDead = this.isDead();
            this.onHit(other);
            this.damage(((DamageTrait)((Object)other)).damage());
            if (!wasDead && this.isDead()) {
                ((DamageTrait)((Object)other)).killed(this);
            }
        }
    }

    @Override
    public void health(float health) {
        this.health = health;
    }

    @Override
    public float health() {
        return this.health;
    }

    @Override
    public boolean isDead() {
        return this.dead;
    }

    @Override
    public void setDead(boolean dead) {
        this.dead = dead;
    }
}

