/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.type;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.arc.util.Interval;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.StatusEffects;
import io.anuke.mindustry.entities.EntityGroup;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.traits.ShooterTrait;
import io.anuke.mindustry.entities.traits.SolidTrait;
import io.anuke.mindustry.entities.traits.TargetTrait;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.entities.units.StateMachine;
import io.anuke.mindustry.entities.units.UnitCommand;
import io.anuke.mindustry.entities.units.UnitDrops;
import io.anuke.mindustry.entities.units.UnitState;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.type.StatusEffect;
import io.anuke.mindustry.type.TypeID;
import io.anuke.mindustry.type.UnitType;
import io.anuke.mindustry.type.Weapon;
import io.anuke.mindustry.ui.Cicon;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.BuildBlock;
import io.anuke.mindustry.world.blocks.defense.DeflectorWall;
import io.anuke.mindustry.world.blocks.units.CommandCenter;
import io.anuke.mindustry.world.blocks.units.UnitFactory;
import io.anuke.mindustry.world.meta.BlockFlag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class BaseUnit
extends Unit
implements ShooterTrait {
    protected static int timerIndex = 0;
    protected static final int timerTarget = timerIndex++;
    protected static final int timerTarget2 = timerIndex++;
    protected static final int timerShootLeft = timerIndex++;
    protected static final int timerShootRight = timerIndex++;
    protected boolean loaded;
    protected UnitType type;
    protected Interval timer = new Interval(5);
    protected StateMachine state = new StateMachine();
    protected TargetTrait target;
    protected int spawner = noSpawner;

    public static void onUnitDeath(BaseUnit unit) {
        if (unit == null) {
            return;
        }
        if (Vars.net.server() || !Vars.net.active()) {
            UnitDrops.dropItems(unit);
        }
        unit.onSuperDeath();
        unit.type.deathSound.at(unit);
        if (Vars.net.client()) {
            Tile tile = Vars.world.tile(unit.spawner);
            if (tile != null) {
                tile.block().unitRemoved(tile, unit);
            }
            unit.spawner = noSpawner;
        }
        Core.app.post(unit::remove);
    }

    @Override
    public float drag() {
        return this.type.drag;
    }

    @Override
    public TypeID getTypeID() {
        return this.type.typeID;
    }

    @Override
    public void onHit(SolidTrait entity) {
        if (entity instanceof Bullet && ((Bullet)entity).getOwner() instanceof DeflectorWall.DeflectorEntity && Vars.player != null && this.getTeam() != Vars.player.getTeam()) {
            Core.app.post(() -> {
                if (this.isDead()) {
                    Events.fire(EventType.Trigger.phaseDeflectHit);
                }
            });
        }
    }

    @ArcAnnotate.Nullable
    public Tile getSpawner() {
        return Vars.world.tile(this.spawner);
    }

    public boolean isCommanded() {
        return Vars.indexer.getAllied((Team)this.team, (BlockFlag)BlockFlag.comandCenter).size != 0 && Vars.indexer.getAllied((Team)this.team, (BlockFlag)BlockFlag.comandCenter).first().entity instanceof CommandCenter.CommandCenterEntity;
    }

    @ArcAnnotate.Nullable
    public UnitCommand getCommand() {
        if (this.isCommanded()) {
            return ((CommandCenter.CommandCenterEntity)Vars.indexer.getAllied((Team)this.team, (BlockFlag)BlockFlag.comandCenter).first().entity()).command;
        }
        return null;
    }

    public void onCommand(UnitCommand command) {
    }

    public void init(UnitType type, Team team) {
        if (this.type != null) {
            throw new RuntimeException("This unit is already initialized!");
        }
        this.type = type;
        this.team = team;
    }

    public UnitType getType() {
        return this.type;
    }

    public void setSpawner(Tile tile) {
        this.spawner = tile.pos();
    }

    public void rotate(float angle) {
        this.rotation = Mathf.slerpDelta(this.rotation, angle, this.type.rotatespeed);
    }

    public boolean targetHasFlag(BlockFlag flag) {
        return this.target instanceof TileEntity && ((TileEntity)this.target).tile.block().flags.contains(flag) || this.target instanceof Tile && ((Tile)this.target).block().flags.contains(flag);
    }

    public void setState(UnitState state) {
        this.state.set(state);
    }

    public boolean retarget() {
        return this.timer.get(timerTarget, 20.0f);
    }

    public void behavior() {
    }

    public void updateTargeting() {
        if (this.target == null || this.target instanceof Unit && (this.target.isDead() || this.target.getTeam() == this.team) || this.target instanceof TileEntity && ((TileEntity)this.target).tile.entity == null) {
            this.target = null;
        }
    }

    public void targetClosestAllyFlag(BlockFlag flag) {
        Tile target = Geometry.findClosest(this.x, this.y, Vars.indexer.getAllied(this.team, flag));
        if (target != null) {
            this.target = target.entity;
        }
    }

    public void targetClosestEnemyFlag(BlockFlag flag) {
        Tile target = Geometry.findClosest(this.x, this.y, Vars.indexer.getEnemy(this.team, flag));
        if (target != null) {
            this.target = target.entity;
        }
    }

    public void targetClosest() {
        TargetTrait newTarget = Units.closestTarget(this.team, this.x, this.y, Math.max(this.getWeapon().bullet.range(), this.type.range), u -> this.type.targetAir || !u.isFlying());
        if (newTarget != null) {
            this.target = newTarget;
        }
    }

    public Tile getClosest(BlockFlag flag) {
        return Geometry.findClosest(this.x, this.y, Vars.indexer.getAllied(this.team, flag));
    }

    public Tile getClosestSpawner() {
        return Geometry.findClosest(this.x, this.y, Vars.spawner.getGroundSpawns());
    }

    public TileEntity getClosestEnemyCore() {
        for (Team enemy : Vars.state.teams.enemiesOf(this.team)) {
            Tile tile = Geometry.findClosest(this.x, this.y, Vars.state.teams.get((Team)enemy).cores);
            if (tile == null) continue;
            return tile.entity;
        }
        return null;
    }

    public UnitState getStartState() {
        return null;
    }

    public boolean isBoss() {
        return this.hasEffect(StatusEffects.boss);
    }

    @Override
    public float getDamageMultipler() {
        return this.status.getDamageMultiplier() * Vars.state.rules.unitDamageMultiplier;
    }

    @Override
    public boolean isImmune(StatusEffect effect) {
        return this.type.immunities.contains(effect);
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.isAdded();
    }

    @Override
    public Interval getTimer() {
        return this.timer;
    }

    @Override
    public int getShootTimer(boolean left) {
        return left ? timerShootLeft : timerShootRight;
    }

    @Override
    public Weapon getWeapon() {
        return this.type.weapon;
    }

    @Override
    public TextureRegion getIconRegion() {
        return this.type.icon(Cicon.full);
    }

    @Override
    public int getItemCapacity() {
        return this.type.itemCapacity;
    }

    @Override
    public void interpolate() {
        super.interpolate();
        if (this.interpolator.values.length > 0) {
            this.rotation = this.interpolator.values[0];
        }
    }

    @Override
    public float maxHealth() {
        return this.type.health * Vars.state.rules.unitHealthMultiplier;
    }

    @Override
    public float mass() {
        return this.type.mass;
    }

    @Override
    public boolean isFlying() {
        return this.type.flying;
    }

    @Override
    public void update() {
        if (this.isDead()) {
            this.remove();
            return;
        }
        this.hitTime -= Time.delta();
        if (Vars.net.client()) {
            this.interpolate();
            this.status.update(this);
            return;
        }
        if (!this.isFlying() && Vars.world.tileWorld(this.x, this.y) != null && !(Vars.world.tileWorld(this.x, this.y).block() instanceof BuildBlock) && Vars.world.tileWorld(this.x, this.y).solid()) {
            this.kill();
        }
        this.avoidOthers();
        if (!(this.spawner == noSpawner || Vars.world.tile(this.spawner) != null && Vars.world.tile((int)this.spawner).entity instanceof UnitFactory.UnitFactoryEntity)) {
            this.kill();
        }
        this.updateTargeting();
        this.state.update();
        this.updateVelocityStatus();
        if (this.target != null) {
            this.behavior();
        }
        if (!this.isFlying()) {
            this.clampPosition();
        }
    }

    @Override
    public void draw() {
    }

    @Override
    public float maxVelocity() {
        return this.type.maxVelocity;
    }

    @Override
    public void removed() {
        super.removed();
        Tile tile = Vars.world.tile(this.spawner);
        if (tile != null && !Vars.net.client()) {
            tile.block().unitRemoved(tile, this);
        }
        this.spawner = noSpawner;
    }

    @Override
    public float drawSize() {
        return this.type.hitsize * 10.0f;
    }

    @Override
    public void onDeath() {
        Call.onUnitDeath(this);
    }

    @Override
    public void added() {
        this.state.set(this.getStartState());
        if (!this.loaded) {
            this.health(this.maxHealth());
        }
        if (this.isCommanded()) {
            this.onCommand(this.getCommand());
        }
    }

    @Override
    public void hitbox(Rectangle rectangle) {
        rectangle.setSize(this.type.hitsize).setCenter(this.x, this.y);
    }

    @Override
    public void hitboxTile(Rectangle rectangle) {
        rectangle.setSize(this.type.hitsizeTile).setCenter(this.x, this.y);
    }

    @Override
    public EntityGroup targetGroup() {
        return Vars.unitGroups[this.team.ordinal()];
    }

    @Override
    public byte version() {
        return 0;
    }

    @Override
    public void writeSave(DataOutput stream) throws IOException {
        super.writeSave(stream);
        stream.writeByte(this.type.id);
        stream.writeInt(this.spawner);
    }

    @Override
    public void readSave(DataInput stream, byte version) throws IOException {
        super.readSave(stream, version);
        this.loaded = true;
        byte type = stream.readByte();
        this.spawner = stream.readInt();
        this.type = (UnitType)Vars.content.getByID(ContentType.unit, type);
        this.add();
    }

    @Override
    public void write(DataOutput data) throws IOException {
        super.writeSave(data);
        data.writeByte(this.type.id);
        data.writeInt(this.spawner);
    }

    @Override
    public void read(DataInput data) throws IOException {
        float lastx = this.x;
        float lasty = this.y;
        float lastrot = this.rotation;
        super.readSave(data, this.version());
        this.type = (UnitType)Vars.content.getByID(ContentType.unit, data.readByte());
        this.spawner = data.readInt();
        this.interpolator.read(lastx, lasty, this.x, this.y, this.rotation);
        this.rotation = lastrot;
        this.x = lastx;
        this.y = lasty;
    }

    public void onSuperDeath() {
        super.onDeath();
    }
}

