/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.traits;

import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.entities.traits.MoveTrait;
import io.anuke.mindustry.entities.traits.SolidTrait;

public interface VelocityTrait
extends MoveTrait {
    public Vector2 velocity();

    default public void applyImpulse(float x, float y) {
        this.velocity().x += x / this.mass();
        this.velocity().y += y / this.mass();
    }

    default public float maxVelocity() {
        return Float.MAX_VALUE;
    }

    default public float mass() {
        return 1.0f;
    }

    default public float drag() {
        return 0.0f;
    }

    default public void updateVelocity() {
        this.velocity().scl(1.0f - this.drag() * Time.delta());
        if (this instanceof SolidTrait) {
            ((SolidTrait)this).move(this.velocity().x * Time.delta(), this.velocity().y * Time.delta());
        } else {
            this.moveBy(this.velocity().x * Time.delta(), this.velocity().y * Time.delta());
        }
    }
}

