/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.traits;

import io.anuke.mindustry.entities.traits.Entity;
import io.anuke.mindustry.entities.traits.TypeTrait;
import io.anuke.mindustry.net.Interpolator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public interface SyncTrait
extends Entity,
TypeTrait {
    default public void setNet(float x, float y) {
        this.set(x, y);
        if (this.getInterpolator() != null) {
            this.getInterpolator().target.set(x, y);
            this.getInterpolator().last.set(x, y);
            this.getInterpolator().pos.set(0.0f, 0.0f);
            this.getInterpolator().updateSpacing = 16L;
            this.getInterpolator().lastUpdated = 0L;
        }
    }

    default public void interpolate() {
        if (this.getInterpolator() == null) {
            throw new RuntimeException("This entity must have an interpolator to interpolate()!");
        }
        this.getInterpolator().update();
        this.setX(this.getInterpolator().pos.x);
        this.setY(this.getInterpolator().pos.y);
    }

    default public Interpolator getInterpolator() {
        return null;
    }

    default public boolean isSyncing() {
        return true;
    }

    public void write(DataOutput var1) throws IOException;

    public void read(DataInput var1) throws IOException;
}

