/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.traits;

import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.entities.traits.SolidTrait;

public interface HealthTrait {
    public void health(float var1);

    public float health();

    public float maxHealth();

    public boolean isDead();

    public void setDead(boolean var1);

    default public void onHit(SolidTrait entity) {
    }

    default public void onDeath() {
    }

    default public boolean damaged() {
        return this.health() < this.maxHealth() - 1.0E-4f;
    }

    default public void damage(float amount) {
        this.health(this.health() - amount);
        if (this.health() <= 0.0f && !this.isDead()) {
            this.onDeath();
            this.setDead(true);
        }
    }

    default public void clampHealth() {
        this.health(Mathf.clamp(this.health(), 0.0f, this.maxHealth()));
    }

    default public float healthf() {
        return this.health() / this.maxHealth();
    }

    default public void healBy(float amount) {
        this.health(this.health() + amount);
        this.clampHealth();
    }

    default public void heal() {
        this.health(this.maxHealth());
        this.setDead(false);
    }
}

