/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.traits;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.Queue;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.entities.traits.Entity;
import io.anuke.mindustry.entities.traits.TeamTrait;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Build;
import io.anuke.mindustry.world.Pos;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.BuildBlock;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public interface BuilderTrait
extends Entity,
TeamTrait {
    public static final float placeDistance = 220.0f;
    public static final float mineDistance = 70.0f;

    default public void updateBuilding() {
        float finalPlaceDst = Vars.state.rules.infiniteResources ? Float.MAX_VALUE : 220.0f;
        Unit unit = (Unit)((Object)this);
        BuildDataStatic.removal.clear();
        for (BuildRequest req : this.buildQueue()) {
            BuildDataStatic.removal.add(req);
        }
        this.buildQueue().clear();
        for (BuildRequest request : BuildDataStatic.removal) {
            Tile tile = Vars.world.tile(request.x, request.y);
            if (tile == null || request.breaking && tile.block() == Blocks.air || !request.breaking && (tile.rotation() == request.rotation || !request.block.rotate) && tile.block() == request.block) continue;
            this.buildQueue().addLast(request);
        }
        BuildRequest current = this.buildRequest();
        if (current == null) {
            return;
        }
        Tile tile = Vars.world.tile(current.x, current.y);
        if (this.dst(tile) > finalPlaceDst) {
            if (this.buildQueue().size > 1) {
                this.buildQueue().removeFirst();
                this.buildQueue().addLast(current);
            }
            return;
        }
        if (!(tile.block() instanceof BuildBlock)) {
            if (!current.initialized && this.canCreateBlocks() && !current.breaking && Build.validPlace(this.getTeam(), current.x, current.y, current.block, current.rotation)) {
                Call.beginPlace(this.getTeam(), current.x, current.y, current.block, current.rotation);
            } else if (!current.initialized && this.canCreateBlocks() && current.breaking && Build.validBreak(this.getTeam(), current.x, current.y)) {
                Call.beginBreak(this.getTeam(), current.x, current.y);
            } else {
                this.buildQueue().removeFirst();
                return;
            }
        }
        TileEntity core = unit.getClosestCore();
        if (tile.entity instanceof BuildBlock.BuildEntity && !current.initialized) {
            Core.app.post(() -> Events.fire(new EventType.BuildSelectEvent(tile, unit.getTeam(), this, current.breaking)));
            current.initialized = true;
        }
        if (core == null && !Vars.state.rules.infiniteResources || !(tile.entity instanceof BuildBlock.BuildEntity)) {
            return;
        }
        BuildBlock.BuildEntity entity = (BuildBlock.BuildEntity)tile.entity();
        if (entity == null) {
            return;
        }
        if (unit.dst(tile) <= finalPlaceDst) {
            unit.rotation = Mathf.slerpDelta(unit.rotation, unit.angleTo(entity), 0.4f);
        }
        if (current.breaking) {
            entity.deconstruct(unit, core, 1.0f / entity.buildCost * Time.delta() * this.getBuildPower(tile) * Vars.state.rules.buildSpeedMultiplier);
        } else if (entity.construct(unit, core, 1.0f / entity.buildCost * Time.delta() * this.getBuildPower(tile) * Vars.state.rules.buildSpeedMultiplier, current.hasConfig) && current.hasConfig) {
            Call.onTileConfig(null, tile, current.config);
        }
        current.progress = entity.progress;
    }

    public Queue<BuildRequest> buildQueue();

    public float getBuildPower(Tile var1);

    default public boolean canCreateBlocks() {
        return true;
    }

    default public void writeBuilding(DataOutput output) throws IOException {
        BuildRequest request = this.buildRequest();
        if (request != null && (request.block != null || request.breaking)) {
            output.writeByte(request.breaking ? 1 : 0);
            output.writeInt(Pos.get(request.x, request.y));
            output.writeFloat(request.progress);
            if (!request.breaking) {
                output.writeShort(request.block.id);
                output.writeByte(request.rotation);
            }
        } else {
            output.writeByte(-1);
        }
    }

    default public void readBuilding(DataInput input) throws IOException {
        this.readBuilding(input, true);
    }

    default public void readBuilding(DataInput input, boolean applyChanges) throws IOException {
        byte type;
        if (applyChanges) {
            this.buildQueue().clear();
        }
        if ((type = input.readByte()) != -1) {
            BuildRequest request;
            int position = input.readInt();
            float progress = input.readFloat();
            if (type == 1) {
                request = new BuildRequest(Pos.x(position), Pos.y(position));
            } else {
                short block = input.readShort();
                byte rotation = input.readByte();
                request = new BuildRequest(Pos.x(position), Pos.y(position), rotation, Vars.content.block(block));
            }
            request.progress = progress;
            if (applyChanges) {
                this.buildQueue().addLast(request);
            } else if (this.isBuilding()) {
                BuildRequest last = this.buildRequest();
                last.progress = progress;
                if (last.tile() != null && last.tile().entity instanceof BuildBlock.BuildEntity) {
                    ((BuildBlock.BuildEntity)last.tile().entity).progress = progress;
                }
            }
        }
    }

    default public boolean isBuilding() {
        return this.buildQueue().size != 0;
    }

    default public void clearBuilding() {
        this.buildQueue().clear();
    }

    default public void addBuildRequest(BuildRequest place) {
        this.addBuildRequest(place, true);
    }

    default public void addBuildRequest(BuildRequest place, boolean tail) {
        Tile tile;
        BuildRequest replace = null;
        for (BuildRequest request : this.buildQueue()) {
            if (request.x != place.x || request.y != place.y) continue;
            replace = request;
            break;
        }
        if (replace != null) {
            this.buildQueue().remove(replace);
        }
        if ((tile = Vars.world.tile(place.x, place.y)) != null && tile.entity instanceof BuildBlock.BuildEntity) {
            place.progress = ((BuildBlock.BuildEntity)tile.entity()).progress;
        }
        if (tail) {
            this.buildQueue().addLast(place);
        } else {
            this.buildQueue().addFirst(place);
        }
    }

    @ArcAnnotate.Nullable
    default public BuildRequest buildRequest() {
        return this.buildQueue().size == 0 ? null : this.buildQueue().first();
    }

    default public void drawBuilding() {
        if (!this.isBuilding()) {
            return;
        }
        Unit unit = (Unit)((Object)this);
        BuildRequest request = this.buildRequest();
        Tile tile = Vars.world.tile(request.x, request.y);
        if (this.dst(tile) > 220.0f && !Vars.state.isEditor()) {
            return;
        }
        Lines.stroke(1.0f, Pal.accent);
        float focusLen = 3.8f + Mathf.absin(Time.time(), 1.1f, 0.6f);
        float px = unit.x + Angles.trnsx(unit.rotation, focusLen);
        float py = unit.y + Angles.trnsy(unit.rotation, focusLen);
        float sz = (float)(8 * tile.block().size) / 2.0f;
        float ang = unit.angleTo(tile);
        BuildDataStatic.tmptr[0].set(tile.drawx() - sz, tile.drawy() - sz);
        BuildDataStatic.tmptr[1].set(tile.drawx() + sz, tile.drawy() - sz);
        BuildDataStatic.tmptr[2].set(tile.drawx() - sz, tile.drawy() + sz);
        BuildDataStatic.tmptr[3].set(tile.drawx() + sz, tile.drawy() + sz);
        Arrays.sort(BuildDataStatic.tmptr, (a, b) -> -Float.compare(Angles.angleDist(Angles.angle(unit.x, unit.y, a.x, a.y), ang), Angles.angleDist(Angles.angle(unit.x, unit.y, b.x, b.y), ang)));
        float x1 = BuildDataStatic.tmptr[0].x;
        float y1 = BuildDataStatic.tmptr[0].y;
        float x3 = BuildDataStatic.tmptr[1].x;
        float y3 = BuildDataStatic.tmptr[1].y;
        Draw.alpha(1.0f);
        Lines.line(px, py, x1, y1);
        Lines.line(px, py, x3, y3);
        Fill.circle(px, py, 1.6f + Mathf.absin(Time.time(), 0.8f, 1.5f));
        Draw.color();
    }

    public static class BuildRequest {
        public int x;
        public int y;
        public int rotation;
        @ArcAnnotate.Nullable
        public Block block;
        public boolean breaking;
        public boolean hasConfig;
        public int config;
        public int originalX;
        public int originalY;
        public int originalWidth;
        public int originalHeight;
        public float progress;
        public boolean initialized;
        public boolean worldContext = true;
        public float animScale = 0.0f;

        public BuildRequest(int x, int y, int rotation, Block block) {
            this.x = x;
            this.y = y;
            this.rotation = rotation;
            this.block = block;
            this.breaking = false;
        }

        public BuildRequest(int x, int y) {
            this.x = x;
            this.y = y;
            this.rotation = -1;
            this.block = Vars.world.tile(x, y).block();
            this.breaking = true;
        }

        public BuildRequest() {
        }

        public BuildRequest copy() {
            BuildRequest copy = new BuildRequest();
            copy.x = this.x;
            copy.y = this.y;
            copy.rotation = this.rotation;
            copy.block = this.block;
            copy.breaking = this.breaking;
            copy.hasConfig = this.hasConfig;
            copy.config = this.config;
            copy.originalX = this.originalX;
            copy.originalY = this.originalY;
            copy.progress = this.progress;
            copy.initialized = this.initialized;
            copy.animScale = this.animScale;
            return copy;
        }

        public BuildRequest original(int x, int y, int originalWidth, int originalHeight) {
            this.originalX = x;
            this.originalY = y;
            this.originalWidth = originalWidth;
            this.originalHeight = originalHeight;
            return this;
        }

        public Rectangle bounds(Rectangle rect) {
            if (this.breaking) {
                return rect.set(-100.0f, -100.0f, 0.0f, 0.0f);
            }
            return this.block.bounds(this.x, this.y, rect);
        }

        public BuildRequest set(int x, int y, int rotation, Block block) {
            this.x = x;
            this.y = y;
            this.rotation = rotation;
            this.block = block;
            this.breaking = false;
            return this;
        }

        public float drawx() {
            return (float)(this.x * 8) + this.block.offset();
        }

        public float drawy() {
            return (float)(this.y * 8) + this.block.offset();
        }

        public BuildRequest configure(int config) {
            this.config = config;
            this.hasConfig = true;
            return this;
        }

        @ArcAnnotate.Nullable
        public Tile tile() {
            return Vars.world.tile(this.x, this.y);
        }

        public String toString() {
            return "BuildRequest{x=" + this.x + ", y=" + this.y + ", rotation=" + this.rotation + ", recipe=" + this.block + ", breaking=" + this.breaking + ", progress=" + this.progress + ", initialized=" + this.initialized + '}';
        }
    }

    public static class BuildDataStatic {
        static Array<BuildRequest> removal = new Array();
        static Vector2[] tmptr = new Vector2[]{new Vector2(), new Vector2(), new Vector2(), new Vector2()};
    }
}

