/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.effect;

import io.anuke.arc.collection.IntMap;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Point2;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.pooling.Pool;
import io.anuke.arc.util.pooling.Pools;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.content.Bullets;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.content.Liquids;
import io.anuke.mindustry.content.TypeIDs;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.EntityGroup;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.effect.Fire;
import io.anuke.mindustry.entities.traits.DrawTrait;
import io.anuke.mindustry.entities.traits.SaveTrait;
import io.anuke.mindustry.entities.traits.SyncTrait;
import io.anuke.mindustry.entities.type.SolidEntity;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.type.TypeID;
import io.anuke.mindustry.world.Tile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Puddle
extends SolidEntity
implements SaveTrait,
Pool.Poolable,
DrawTrait,
SyncTrait {
    private static final IntMap<Puddle> map = new IntMap();
    private static final float maxLiquid = 70.0f;
    private static final int maxGeneration = 2;
    private static final Color tmp = new Color();
    private static final Rectangle rect = new Rectangle();
    private static final Rectangle rect2 = new Rectangle();
    private static int seeds;
    private int loadedPosition = -1;
    private float updateTime;
    private float lastRipple;
    private Tile tile;
    private Liquid liquid;
    private float amount;
    private float targetAmount;
    private float accepting;
    private byte generation;

    public static void deposit(Tile tile, Tile source, Liquid liquid, float amount) {
        Puddle.deposit(tile, source, liquid, amount, 0);
    }

    public static void deposit(Tile tile, Liquid liquid, float amount) {
        Puddle.deposit(tile, tile, liquid, amount, 0);
    }

    public static Puddle getPuddle(Tile tile) {
        return map.get(tile.pos());
    }

    private static void deposit(Tile tile, Tile source, Liquid liquid, float amount, int generation) {
        if (tile == null) {
            return;
        }
        if (tile.floor().isLiquid && !Puddle.canStayOn(liquid, tile.floor().liquidDrop)) {
            Puddle.reactPuddle(tile.floor().liquidDrop, liquid, amount, tile, (tile.worldx() + source.worldx()) / 2.0f, (tile.worldy() + source.worldy()) / 2.0f);
            Puddle p = map.get(tile.pos());
            if (generation == 0 && p != null && p.lastRipple <= Time.time() - 40.0f) {
                Effects.effect(Fx.ripple, tile.floor().liquidDrop.color, (tile.worldx() + source.worldx()) / 2.0f, (tile.worldy() + source.worldy()) / 2.0f);
                p.lastRipple = Time.time();
            }
            return;
        }
        Puddle p = map.get(tile.pos());
        if (p == null) {
            if (Vars.net.client()) {
                return;
            }
            Puddle puddle = Pools.obtain(Puddle.class, Puddle::new);
            puddle.tile = tile;
            puddle.liquid = liquid;
            puddle.amount = amount;
            puddle.generation = (byte)generation;
            puddle.set((tile.worldx() + source.worldx()) / 2.0f, (tile.worldy() + source.worldy()) / 2.0f);
            puddle.add();
            map.put(tile.pos(), puddle);
        } else if (p.liquid == liquid) {
            p.accepting = Math.max(amount, p.accepting);
            if (generation == 0 && p.lastRipple <= Time.time() - 40.0f && p.amount >= 35.0f) {
                Effects.effect(Fx.ripple, p.liquid.color, (tile.worldx() + source.worldx()) / 2.0f, (tile.worldy() + source.worldy()) / 2.0f);
                p.lastRipple = Time.time();
            }
        } else {
            p.amount += Puddle.reactPuddle(p.liquid, liquid, amount, p.tile, p.x, p.y);
        }
    }

    private static boolean canStayOn(Liquid liquid, Liquid other) {
        return liquid == Liquids.oil && other == Liquids.water;
    }

    private static float reactPuddle(Liquid dest, Liquid liquid, float amount, Tile tile, float x, float y) {
        if (dest.flammability > 0.3f && liquid.temperature > 0.7f || liquid.flammability > 0.3f && dest.temperature > 0.7f) {
            Fire.create(tile);
            if (Mathf.chance(0.006 * (double)amount)) {
                Call.createBullet(Bullets.fireball, x, y, Mathf.random(360.0f));
            }
        } else {
            if (dest.temperature > 0.7f && liquid.temperature < 0.55f) {
                if (Mathf.chance(0.5f * amount)) {
                    Effects.effect(Fx.steam, x, y);
                }
                return -0.1f * amount;
            }
            if (liquid.temperature > 0.7f && dest.temperature < 0.55f) {
                if (Mathf.chance(0.8f * amount)) {
                    Effects.effect(Fx.steam, x, y);
                }
                return -0.4f * amount;
            }
        }
        return 0.0f;
    }

    public static void onPuddleRemoved(int puddleid) {
        Vars.puddleGroup.removeByID(puddleid);
    }

    public float getFlammability() {
        return this.liquid.flammability * this.amount;
    }

    @Override
    public TypeID getTypeID() {
        return TypeIDs.puddle;
    }

    @Override
    public byte version() {
        return 0;
    }

    @Override
    public void hitbox(Rectangle rectangle) {
        rectangle.setCenter(this.x, this.y).setSize(8.0f);
    }

    @Override
    public void hitboxTile(Rectangle rectangle) {
        rectangle.setCenter(this.x, this.y).setSize(0.0f);
    }

    @Override
    public void update() {
        if (Vars.net.client()) {
            this.amount = Mathf.lerpDelta(this.amount, this.targetAmount, 0.15f);
        } else {
            float addSpeed = this.accepting > 0.0f ? 3.0f : 0.0f;
            this.amount -= Time.delta() * (1.0f - this.liquid.viscosity) / (5.0f + addSpeed);
            this.amount += this.accepting;
            this.accepting = 0.0f;
            if (this.amount >= 46.666668f && this.generation < 2) {
                float deposited = Math.min((this.amount - 46.666668f) / 4.0f, 0.3f) * Time.delta();
                for (Point2 point : Geometry.d4) {
                    Tile other = Vars.world.tile(this.tile.x + point.x, this.tile.y + point.y);
                    if (other == null || other.block() != Blocks.air) continue;
                    Puddle.deposit(other, this.tile, this.liquid, deposited, this.generation + 1);
                    this.amount -= deposited / 2.0f;
                }
            }
            this.amount = Mathf.clamp(this.amount, 0.0f, 70.0f);
            if (this.amount <= 0.0f) {
                Call.onPuddleRemoved(this.getID());
            }
        }
        if (this.amount >= 35.0f && this.updateTime <= 0.0f) {
            Units.nearby(rect.setSize(Mathf.clamp(this.amount / 46.666668f) * 10.0f).setCenter(this.x, this.y), unit -> {
                if (unit.isFlying()) {
                    return;
                }
                unit.hitbox(rect2);
                if (!rect.overlaps(rect2)) {
                    return;
                }
                unit.applyEffect(this.liquid.effect, 120.0f);
                if ((double)unit.velocity().len() > 0.1) {
                    Effects.effect(Fx.ripple, this.liquid.color, unit.x, unit.y);
                }
            });
            if (this.liquid.temperature > 0.7f && this.tile.link().entity != null && Mathf.chance(0.3 * (double)Time.delta())) {
                Fire.create(this.tile);
            }
            this.updateTime = 20.0f;
        }
        this.updateTime -= Time.delta();
    }

    @Override
    public void draw() {
        seeds = this.id;
        boolean onLiquid = this.tile.floor().isLiquid;
        float f = Mathf.clamp(this.amount / 46.666668f);
        float smag = onLiquid ? 0.8f : 0.0f;
        float sscl = 20.0f;
        Draw.color(tmp.set(this.liquid.color).shiftValue(-0.05f));
        Fill.circle(this.x + Mathf.sin(Time.time() + (float)(seeds * 532), sscl, smag), this.y + Mathf.sin(Time.time() + (float)(seeds * 53), sscl, smag), f * 8.0f);
        Angles.randLenVectors(this.id, 3, f * 6.0f, (ex, ey) -> {
            Fill.circle(this.x + ex + Mathf.sin(Time.time() + (float)(seeds * 532), sscl, smag), this.y + ey + Mathf.sin(Time.time() + (float)(seeds * 53), sscl, smag), f * 5.0f);
            ++seeds;
        });
        Draw.color();
    }

    @Override
    public float drawSize() {
        return 20.0f;
    }

    @Override
    public void writeSave(DataOutput stream) throws IOException {
        stream.writeInt(this.tile.pos());
        stream.writeFloat(this.x);
        stream.writeFloat(this.y);
        stream.writeByte(this.liquid.id);
        stream.writeFloat(this.amount);
        stream.writeByte(this.generation);
    }

    @Override
    public void readSave(DataInput stream, byte version) throws IOException {
        this.loadedPosition = stream.readInt();
        this.x = stream.readFloat();
        this.y = stream.readFloat();
        this.liquid = Vars.content.liquid(stream.readByte());
        this.amount = stream.readFloat();
        this.generation = stream.readByte();
        this.add();
    }

    @Override
    public void reset() {
        this.loadedPosition = -1;
        this.tile = null;
        this.liquid = null;
        this.amount = 0.0f;
        this.generation = 0;
        this.accepting = 0.0f;
    }

    @Override
    public void added() {
        if (this.loadedPosition != -1) {
            map.put(this.loadedPosition, this);
            this.tile = Vars.world.tile(this.loadedPosition);
        }
    }

    @Override
    public void removed() {
        if (this.tile != null) {
            map.remove(this.tile.pos());
        }
        this.reset();
    }

    @Override
    public void write(DataOutput data) throws IOException {
        data.writeFloat(this.x);
        data.writeFloat(this.y);
        data.writeByte(this.liquid.id);
        data.writeShort((short)(this.amount * 4.0f));
        data.writeInt(this.tile.pos());
    }

    @Override
    public void read(DataInput data) throws IOException {
        this.x = data.readFloat();
        this.y = data.readFloat();
        this.liquid = Vars.content.liquid(data.readByte());
        this.targetAmount = (float)data.readShort() / 4.0f;
        int pos = data.readInt();
        this.tile = Vars.world.tile(pos);
        map.put(pos, this);
    }

    @Override
    public EntityGroup targetGroup() {
        return Vars.puddleGroup;
    }
}

