/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.bullet;

import io.anuke.arc.graphics.Color;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.bullet.BasicBulletType;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.graphics.Pal;

public class MissileBulletType
extends BasicBulletType {
    protected Color trailColor = Pal.missileYellowBack;
    protected float weaveScale = 0.0f;
    protected float weaveMag = -1.0f;

    public MissileBulletType(float speed, float damage, String bulletSprite) {
        super(speed, damage, bulletSprite);
        this.backColor = Pal.missileYellowBack;
        this.frontColor = Pal.missileYellow;
        this.homingPower = 7.0f;
        this.hitSound = Sounds.explosion;
    }

    public MissileBulletType() {
        this(1.0f, 1.0f, "missile");
    }

    @Override
    public void update(Bullet b) {
        super.update(b);
        if (Mathf.chance((double)Time.delta() * 0.2)) {
            Effects.effect(Fx.missileTrail, this.trailColor, b.x, b.y, 2.0f);
        }
        if (this.weaveMag > 0.0f) {
            b.velocity().rotate(Mathf.sin(Time.time() + (float)(b.id * 4422), this.weaveScale, this.weaveMag));
        }
    }
}

