/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.bullet;

import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.BuildBlock;

public class HealBulletType
extends BulletType {
    protected float healPercent = 3.0f;

    public HealBulletType(float speed, float damage) {
        super(speed, damage);
        this.shootEffect = Fx.shootHeal;
        this.smokeEffect = Fx.hitLaser;
        this.hitEffect = Fx.hitLaser;
        this.despawnEffect = Fx.hitLaser;
        this.collidesTeam = true;
    }

    public HealBulletType() {
        this(1.0f, 1.0f);
    }

    @Override
    public boolean collides(Bullet b, Tile tile) {
        return tile.getTeam() != b.getTeam() || tile.entity.healthf() < 1.0f;
    }

    @Override
    public void draw(Bullet b) {
        Draw.color(Pal.heal);
        Lines.stroke(2.0f);
        Lines.lineAngleCenter(b.x, b.y, b.rot(), 7.0f);
        Draw.color(Color.white);
        Lines.lineAngleCenter(b.x, b.y, b.rot(), 3.0f);
        Draw.reset();
    }

    @Override
    public void hitTile(Bullet b, Tile tile) {
        super.hit(b);
        tile = tile.link();
        if (tile.entity != null && tile.getTeam() == b.getTeam() && !(tile.block() instanceof BuildBlock)) {
            Effects.effect(Fx.healBlockFull, Pal.heal, tile.drawx(), tile.drawy(), tile.block().size);
            tile.entity.healBy(this.healPercent / 100.0f * tile.entity.maxHealth());
        }
    }
}

