/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.bullet;

import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.bullet.BasicBulletType;
import io.anuke.mindustry.entities.type.Bullet;

public abstract class FlakBulletType
extends BasicBulletType {
    protected static Rectangle rect = new Rectangle();
    protected float explodeRange = 30.0f;

    public FlakBulletType(float speed, float damage) {
        super(speed, damage, "shell");
        this.splashDamage = 15.0f;
        this.splashDamageRadius = 34.0f;
        this.hitEffect = Fx.flakExplosionBig;
        this.bulletWidth = 8.0f;
        this.bulletHeight = 10.0f;
    }

    public FlakBulletType() {
        this(1.0f, 1.0f);
    }

    @Override
    public void update(Bullet b) {
        super.update(b);
        if (b.getData() instanceof Integer) {
            return;
        }
        if (b.timer.get(2, 6.0f)) {
            Units.nearbyEnemies(b.getTeam(), rect.setSize(this.explodeRange * 2.0f).setCenter(b.x, b.y), unit -> {
                if (b.getData() instanceof Float) {
                    return;
                }
                if (unit.dst(b) < this.explodeRange) {
                    b.setData(0);
                    Time.run(5.0f, () -> {
                        if (b.getData() instanceof Integer) {
                            b.time(b.lifetime());
                        }
                    });
                }
            });
        }
    }
}

