/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.bullet;

import io.anuke.arc.audio.Sound;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.content.StatusEffects;
import io.anuke.mindustry.ctype.Content;
import io.anuke.mindustry.entities.Damage;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.effect.Lightning;
import io.anuke.mindustry.entities.traits.TargetTrait;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.type.StatusEffect;
import io.anuke.mindustry.world.Tile;

public abstract class BulletType
extends Content {
    public float lifetime;
    public float speed;
    public float damage;
    public float hitSize = 4.0f;
    public float drawSize = 40.0f;
    public float drag = 0.0f;
    public boolean pierce;
    public Effects.Effect hitEffect;
    public Effects.Effect despawnEffect;
    public Effects.Effect shootEffect = Fx.shootSmall;
    public Effects.Effect smokeEffect = Fx.shootSmallSmoke;
    public Sound hitSound = Sounds.none;
    public float inaccuracy = 0.0f;
    public float ammoMultiplier = 2.0f;
    public float reloadMultiplier = 1.0f;
    public float recoil;
    public float splashDamage = 0.0f;
    public float knockback;
    public boolean hitTiles = true;
    public StatusEffect status = StatusEffects.none;
    public float statusDuration = 600.0f;
    public boolean collidesTiles = true;
    public boolean collidesTeam = false;
    public boolean collidesAir = true;
    public boolean collides = true;
    public boolean keepVelocity = true;
    public int fragBullets = 9;
    public float fragVelocityMin = 0.2f;
    public float fragVelocityMax = 1.0f;
    public BulletType fragBullet = null;
    public float splashDamageRadius = -1.0f;
    public int incendAmount = 0;
    public float incendSpread = 8.0f;
    public float incendChance = 1.0f;
    public float homingPower = 0.0f;
    public float homingRange = 50.0f;
    public int lightining;
    public int lightningLength = 5;
    public float hitShake = 0.0f;

    public BulletType(float speed, float damage) {
        this.speed = speed;
        this.damage = damage;
        this.lifetime = 40.0f;
        this.hitEffect = Fx.hitBulletSmall;
        this.despawnEffect = Fx.hitBulletSmall;
    }

    public float range() {
        return this.speed * this.lifetime * (1.0f - this.drag);
    }

    public boolean collides(Bullet bullet, Tile tile) {
        return true;
    }

    public void hitTile(Bullet b, Tile tile) {
        this.hit(b);
    }

    public void hit(Bullet b) {
        this.hit(b, b.x, b.y);
    }

    public void hit(Bullet b, float x, float y) {
        Effects.effect(this.hitEffect, x, y, b.rot());
        this.hitSound.at(b);
        Effects.shake(this.hitShake, this.hitShake, b);
        if (this.fragBullet != null) {
            for (int i = 0; i < this.fragBullets; ++i) {
                float len = Mathf.random(1.0f, 7.0f);
                float a = Mathf.random(360.0f);
                Bullet.create(this.fragBullet, b, x + Angles.trnsx(a, len), y + Angles.trnsy(a, len), a, Mathf.random(this.fragVelocityMin, this.fragVelocityMax));
            }
        }
        if (Mathf.chance(this.incendChance)) {
            Damage.createIncend(x, y, this.incendSpread, this.incendAmount);
        }
        if (this.splashDamageRadius > 0.0f) {
            Damage.damage(b.getTeam(), x, y, this.splashDamageRadius, this.splashDamage * b.damageMultiplier());
        }
    }

    public void despawned(Bullet b) {
        Effects.effect(this.despawnEffect, b.x, b.y, b.rot());
        this.hitSound.at(b);
        if (this.fragBullet != null || this.splashDamageRadius > 0.0f) {
            this.hit(b);
        }
        for (int i = 0; i < this.lightining; ++i) {
            Lightning.create(b.getTeam(), Pal.surge, this.damage, b.x, b.y, Mathf.random(360.0f), this.lightningLength);
        }
    }

    public void draw(Bullet b) {
    }

    public void init(Bullet b) {
    }

    public void update(Bullet b) {
        TargetTrait target;
        if (this.homingPower > 1.0E-4f && (target = Units.closestTarget(b.getTeam(), b.x, b.y, this.homingRange)) != null) {
            b.velocity().setAngle(Mathf.slerpDelta(b.velocity().angle(), b.angleTo(target), 0.08f));
        }
    }

    @Override
    public ContentType getContentType() {
        return ContentType.bullet;
    }
}

