/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities;

import io.anuke.arc.collection.EnumSet;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.traits.TargetTrait;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.world.Tile;

public class Units {
    private static Rectangle hitrect = new Rectangle();
    private static Unit result;
    private static float cdist;
    private static boolean boolResult;

    public static boolean canInteract(Player player, Tile tile) {
        return player == null || tile == null || tile.interactable(player.getTeam());
    }

    public static boolean invalidateTarget(TargetTrait target, Team team, float x, float y, float range) {
        return target == null || range != Float.MAX_VALUE && !target.withinDst(x, y, range) || target.getTeam() == team || !target.isValid();
    }

    public static boolean invalidateTarget(TargetTrait target, Team team, float x, float y) {
        return Units.invalidateTarget(target, team, x, y, Float.MAX_VALUE);
    }

    public static boolean invalidateTarget(TargetTrait target, Unit targeter) {
        return Units.invalidateTarget(target, targeter.getTeam(), targeter.x, targeter.y, targeter.getWeapon().bullet.range());
    }

    public static boolean anyEntities(Tile tile) {
        float size = tile.block().size * 8;
        return Units.anyEntities(tile.drawx() - size / 2.0f, tile.drawy() - size / 2.0f, size, size);
    }

    public static boolean anyEntities(float x, float y, float width, float height) {
        boolResult = false;
        Units.nearby(x, y, width, height, (Unit unit) -> {
            if (boolResult) {
                return;
            }
            if (!unit.isFlying()) {
                unit.hitbox(hitrect);
                if (hitrect.overlaps(x, y, width, height)) {
                    boolResult = true;
                }
            }
        });
        return boolResult;
    }

    public static TileEntity findDamagedTile(Team team, float x, float y) {
        Tile tile = Geometry.findClosest(x, y, Vars.indexer.getDamaged(team));
        return tile == null ? null : tile.entity;
    }

    public static TileEntity findAllyTile(Team team, float x, float y, float range, Predicate<Tile> pred) {
        return Vars.indexer.findTile(team, x, y, range, pred);
    }

    public static TileEntity findEnemyTile(Team team, float x, float y, float range, Predicate<Tile> pred) {
        if (team == Team.derelict) {
            return null;
        }
        for (Team enemy : Vars.state.teams.enemiesOf(team)) {
            TileEntity entity = Vars.indexer.findTile(enemy, x, y, range, pred, true);
            if (entity == null) continue;
            return entity;
        }
        return null;
    }

    public static TargetTrait closestTarget(Team team, float x, float y, float range) {
        return Units.closestTarget(team, x, y, range, Unit::isValid);
    }

    public static TargetTrait closestTarget(Team team, float x, float y, float range, Predicate<Unit> unitPred) {
        return Units.closestTarget(team, x, y, range, unitPred, t -> true);
    }

    public static TargetTrait closestTarget(Team team, float x, float y, float range, Predicate<Unit> unitPred, Predicate<Tile> tilePred) {
        if (team == Team.derelict) {
            return null;
        }
        Unit unit = Units.closestEnemy(team, x, y, range, unitPred);
        if (unit != null) {
            return unit;
        }
        return Units.findEnemyTile(team, x, y, range, tilePred);
    }

    public static Unit closestEnemy(Team team, float x, float y, float range, Predicate<Unit> predicate) {
        if (team == Team.derelict) {
            return null;
        }
        result = null;
        cdist = 0.0f;
        Units.nearbyEnemies(team, x - range, y - range, range * 2.0f, range * 2.0f, e -> {
            if (e.isDead() || !predicate.test((Unit)e)) {
                return;
            }
            float dst2 = Mathf.dst2(e.x, e.y, x, y);
            if (dst2 < range * range && (result == null || dst2 < cdist)) {
                result = e;
                cdist = dst2;
            }
        });
        return result;
    }

    public static Unit closest(Team team, float x, float y, float range, Predicate<Unit> predicate) {
        result = null;
        cdist = 0.0f;
        Units.nearby(team, x, y, range, (Unit e) -> {
            if (!predicate.test((Unit)e)) {
                return;
            }
            float dist = Mathf.dst2(e.x, e.y, x, y);
            if (result == null || dist < cdist) {
                result = e;
                cdist = dist;
            }
        });
        return result;
    }

    public static void nearby(Team team, float x, float y, float width, float height, Consumer<Unit> cons) {
        Vars.unitGroups[team.ordinal()].intersect(x, y, width, height, cons);
        Vars.playerGroup.intersect(x, y, width, height, player -> {
            if (player.getTeam() == team) {
                cons.accept((Unit)player);
            }
        });
    }

    public static void nearby(Team team, float x, float y, float radius, Consumer<Unit> cons) {
        Vars.unitGroups[team.ordinal()].intersect(x - radius, y - radius, radius * 2.0f, radius * 2.0f, unit -> {
            if (unit.withinDst(x, y, radius)) {
                cons.accept((Unit)unit);
            }
        });
        Vars.playerGroup.intersect(x - radius, y - radius, radius * 2.0f, radius * 2.0f, unit -> {
            if (unit.getTeam() == team && unit.withinDst(x, y, radius)) {
                cons.accept((Unit)unit);
            }
        });
    }

    public static void nearby(float x, float y, float width, float height, Consumer<Unit> cons) {
        for (Team team : Team.all) {
            Vars.unitGroups[team.ordinal()].intersect(x, y, width, height, cons);
        }
        Vars.playerGroup.intersect(x, y, width, height, cons);
    }

    public static void nearby(Rectangle rect, Consumer<Unit> cons) {
        Units.nearby(rect.x, rect.y, rect.width, rect.height, cons);
    }

    public static void nearbyEnemies(Team team, float x, float y, float width, float height, Consumer<Unit> cons) {
        EnumSet<Team> targets = Vars.state.teams.enemiesOf(team);
        for (Team other : targets) {
            Vars.unitGroups[other.ordinal()].intersect(x, y, width, height, cons);
        }
        Vars.playerGroup.intersect(x, y, width, height, player -> {
            if (targets.contains(player.getTeam())) {
                cons.accept((Unit)player);
            }
        });
    }

    public static void nearbyEnemies(Team team, Rectangle rect, Consumer<Unit> cons) {
        Units.nearbyEnemies(team, rect.x, rect.y, rect.width, rect.height, cons);
    }

    public static void all(Consumer<Unit> cons) {
        for (Team team : Team.all) {
            Vars.unitGroups[team.ordinal()].all().each(cons);
        }
        Vars.playerGroup.all().each(cons);
    }
}

