/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities;

import io.anuke.arc.collection.Array;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.QuadTree;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.EntityGroup;
import io.anuke.mindustry.entities.traits.Entity;
import io.anuke.mindustry.entities.traits.SolidTrait;
import io.anuke.mindustry.world.Tile;

public class EntityCollisions {
    private static final int r = 1;
    private static final float seg = 1.0f;
    private Rectangle tmp = new Rectangle();
    private Vector2 vector = new Vector2();
    private Vector2 l1 = new Vector2();
    private Rectangle r1 = new Rectangle();
    private Rectangle r2 = new Rectangle();
    private Array<SolidTrait> arrOut = new Array();

    public void move(SolidTrait entity, float deltax, float deltay) {
        boolean movedx = false;
        while (Math.abs(deltax) > 0.0f || !movedx) {
            movedx = true;
            this.moveDelta(entity, Math.min(Math.abs(deltax), 1.0f) * (float)Mathf.sign(deltax), 0.0f, true);
            if (Math.abs(deltax) >= 1.0f) {
                deltax -= 1.0f * (float)Mathf.sign(deltax);
                continue;
            }
            deltax = 0.0f;
        }
        boolean movedy = false;
        while (Math.abs(deltay) > 0.0f || !movedy) {
            movedy = true;
            this.moveDelta(entity, 0.0f, Math.min(Math.abs(deltay), 1.0f) * (float)Mathf.sign(deltay), false);
            if (Math.abs(deltay) >= 1.0f) {
                deltay -= 1.0f * (float)Mathf.sign(deltay);
                continue;
            }
            deltay = 0.0f;
        }
    }

    public void moveDelta(SolidTrait entity, float deltax, float deltay, boolean x) {
        Rectangle rect = this.r1;
        entity.hitboxTile(rect);
        entity.hitboxTile(this.r2);
        rect.x += deltax;
        rect.y += deltay;
        int tilex = Math.round((rect.x + rect.width / 2.0f) / 8.0f);
        int tiley = Math.round((rect.y + rect.height / 2.0f) / 8.0f);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                int wx = dx + tilex;
                int wy = dy + tiley;
                if (!EntityCollisions.solid(wx, wy) || !entity.collidesGrid(wx, wy)) continue;
                this.tmp.setSize(8.0f).setCenter(wx * 8, wy * 8);
                if (!this.tmp.overlaps(rect)) continue;
                Vector2 v = Geometry.overlap(rect, this.tmp, x);
                rect.x += v.x;
                rect.y += v.y;
            }
        }
        entity.setX(entity.getX() + rect.x - this.r2.x);
        entity.setY(entity.getY() + rect.y - this.r2.y);
    }

    public boolean overlapsTile(Rectangle rect) {
        rect.getCenter(this.vector);
        int r = 1;
        int tilex = Math.round(this.vector.x / 8.0f);
        int tiley = Math.round(this.vector.y / 8.0f);
        for (int dx = -r; dx <= r; ++dx) {
            for (int dy = -r; dy <= r; ++dy) {
                int wx = dx + tilex;
                int wy = dy + tiley;
                if (!EntityCollisions.solid(wx, wy)) continue;
                this.r2.setSize(8.0f).setCenter(wx * 8, wy * 8);
                if (!this.r2.overlaps(rect)) continue;
                return true;
            }
        }
        return false;
    }

    public <T extends Entity> void updatePhysics(EntityGroup<T> group) {
        QuadTree tree = group.tree();
        tree.clear();
        for (Entity entity : group.all()) {
            if (!(entity instanceof SolidTrait)) continue;
            SolidTrait s = (SolidTrait)entity;
            s.lastPosition().set(s.getX(), s.getY());
            tree.insert(s);
        }
    }

    private static boolean solid(int x, int y) {
        Tile tile = Vars.world.tile(x, y);
        return tile != null && tile.solid();
    }

    private void checkCollide(Entity entity, Entity other) {
        SolidTrait a = (SolidTrait)entity;
        SolidTrait b = (SolidTrait)other;
        a.hitbox(this.r1);
        b.hitbox(this.r2);
        this.r1.x += a.lastPosition().x - a.getX();
        this.r1.y += a.lastPosition().y - a.getY();
        this.r2.x += b.lastPosition().x - b.getX();
        this.r2.y += b.lastPosition().y - b.getY();
        float vax = a.getX() - a.lastPosition().x;
        float vay = a.getY() - a.lastPosition().y;
        float vbx = b.getX() - b.lastPosition().x;
        float vby = b.getY() - b.lastPosition().y;
        if (a != b && a.collides(b) && b.collides(a)) {
            boolean collide;
            this.l1.set(a.getX(), a.getY());
            boolean bl = collide = this.r1.overlaps(this.r2) || this.collide(this.r1.x, this.r1.y, this.r1.width, this.r1.height, vax, vay, this.r2.x, this.r2.y, this.r2.width, this.r2.height, vbx, vby, this.l1);
            if (collide) {
                a.collision(b, this.l1.x, this.l1.y);
                b.collision(a, this.l1.x, this.l1.y);
            }
        }
    }

    private boolean collide(float x1, float y1, float w1, float h1, float vx1, float vy1, float x2, float y2, float w2, float h2, float vx2, float vy2, Vector2 out) {
        float yInvExit;
        float yInvEntry;
        float xInvExit;
        float xInvEntry;
        float px = vx1;
        float py = vy1;
        vx1 -= vx2;
        vy1 -= vy2;
        if (vx1 > 0.0f) {
            xInvEntry = x2 - (x1 + w1);
            xInvExit = x2 + w2 - x1;
        } else {
            xInvEntry = x2 + w2 - x1;
            xInvExit = x2 - (x1 + w1);
        }
        if (vy1 > 0.0f) {
            yInvEntry = y2 - (y1 + h1);
            yInvExit = y2 + h2 - y1;
        } else {
            yInvEntry = y2 + h2 - y1;
            yInvExit = y2 - (y1 + h1);
        }
        float xEntry = xInvEntry / vx1;
        float xExit = xInvExit / vx1;
        float yEntry = yInvEntry / vy1;
        float yExit = yInvExit / vy1;
        float entryTime = Math.max(xEntry, yEntry);
        float exitTime = Math.min(xExit, yExit);
        if (entryTime > exitTime || xExit < 0.0f || yExit < 0.0f || xEntry > 1.0f || yEntry > 1.0f) {
            return false;
        }
        float dx = x1 + w1 / 2.0f + px * entryTime;
        float dy = y1 + h1 / 2.0f + py * entryTime;
        out.set(dx, dy);
        return true;
    }

    public void collideGroups(EntityGroup<?> groupa, EntityGroup<?> groupb) {
        for (Entity entity : groupa.all()) {
            if (!(entity instanceof SolidTrait)) continue;
            SolidTrait solid = (SolidTrait)entity;
            solid.hitbox(this.r1);
            this.r1.x += solid.lastPosition().x - solid.getX();
            this.r1.y += solid.lastPosition().y - solid.getY();
            solid.hitbox(this.r2);
            this.r2.merge(this.r1);
            this.arrOut.clear();
            groupb.tree().getIntersect(this.arrOut, this.r2);
            for (SolidTrait sc : this.arrOut) {
                sc.hitbox(this.r1);
                if (!this.r2.overlaps(this.r1)) continue;
                this.checkCollide(entity, sc);
            }
        }
    }
}

