/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.editor;

import io.anuke.arc.function.Consumer;
import io.anuke.arc.scene.ui.TextButton;
import io.anuke.arc.scene.ui.TextField;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.maps.Map;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;

public class MapSaveDialog
extends FloatingDialog {
    private TextField field = new TextField();
    private Consumer<String> listener;

    public MapSaveDialog(Consumer<String> cons) {
        super("$editor.savemap");
        this.listener = cons;
        Vars.platform.addDialog(this.field);
        this.shown(() -> {
            this.cont.clear();
            this.cont.label(() -> {
                Map map = Vars.maps.byName(this.field.getText());
                if (map != null) {
                    if (map.custom) {
                        return "$editor.overwrite";
                    }
                    return "$editor.failoverwrite";
                }
                return "";
            }).colspan(2);
            this.cont.row();
            this.cont.add("$editor.mapname").padRight(14.0f);
            this.cont.add(this.field).size(220.0f, 48.0f);
        });
        this.buttons.defaults().size(200.0f, 50.0f).pad(2.0f);
        this.buttons.addButton("$cancel", this::hide);
        TextButton button = new TextButton("$save");
        button.clicked(() -> {
            if (!this.invalid()) {
                cons.accept(this.field.getText());
                this.hide();
            }
        });
        button.setDisabled(this::invalid);
        this.buttons.add(button);
    }

    public void save() {
        if (!this.invalid()) {
            this.listener.accept(this.field.getText());
        } else {
            Vars.ui.showErrorMessage("$editor.failoverwrite");
        }
    }

    public void setFieldText(String text) {
        this.field.setText(text);
    }

    private boolean invalid() {
        if (this.field.getText().isEmpty()) {
            return true;
        }
        Map map = Vars.maps.byName(this.field.getText());
        return map != null && !map.custom;
    }
}

