/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.editor;

import io.anuke.arc.function.IntPositionConsumer;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.editor.MapEditor;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;

public class MapResizeDialog
extends FloatingDialog {
    private static final int minSize = 50;
    private static final int maxSize = 500;
    private static final int increment = 50;
    int width;
    int height;

    public MapResizeDialog(MapEditor editor, IntPositionConsumer cons) {
        super("$editor.resizemap");
        this.shown(() -> {
            this.cont.clear();
            this.width = editor.width();
            this.height = editor.height();
            Table table = new Table();
            for (boolean w : Mathf.booleans) {
                table.add(w ? "$width" : "$height").padRight(8.0f);
                table.defaults().height(60.0f).padTop(8.0f);
                table.addButton("<", () -> {
                    if (w) {
                        this.width = MapResizeDialog.move(this.width, -1);
                    } else {
                        this.height = MapResizeDialog.move(this.height, -1);
                    }
                }).size(60.0f);
                table.table(Tex.button, t -> t.label(() -> (w ? this.width : this.height) + "")).width(200.0f);
                table.addButton(">", () -> {
                    if (w) {
                        this.width = MapResizeDialog.move(this.width, 1);
                    } else {
                        this.height = MapResizeDialog.move(this.height, 1);
                    }
                }).size(60.0f);
                table.row();
            }
            this.cont.row();
            this.cont.add(table);
        });
        this.buttons.defaults().size(200.0f, 50.0f);
        this.buttons.addButton("$cancel", this::hide);
        this.buttons.addButton("$ok", () -> {
            cons.accept(this.width, this.height);
            this.hide();
        });
    }

    static int move(int value, int direction) {
        return Mathf.clamp((value / 50 + direction) * 50, 50, 500);
    }
}

