/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.editor;

import io.anuke.arc.function.Consumer;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.ui.ButtonGroup;
import io.anuke.arc.scene.ui.ScrollPane;
import io.anuke.arc.scene.ui.TextButton;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Scaling;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.maps.Map;
import io.anuke.mindustry.ui.BorderImage;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;

public class MapLoadDialog
extends FloatingDialog {
    private Map selected = null;

    public MapLoadDialog(Consumer<Map> loader) {
        super("$editor.loadmap");
        this.shown(this::rebuild);
        TextButton button = new TextButton("$load");
        button.setDisabled(() -> this.selected == null);
        button.clicked(() -> {
            if (this.selected != null) {
                loader.accept(this.selected);
                this.hide();
            }
        });
        this.buttons.defaults().size(200.0f, 50.0f);
        this.buttons.addButton("$cancel", this::hide);
        this.buttons.add(button);
    }

    public void rebuild() {
        this.cont.clear();
        if (Vars.maps.all().size > 0) {
            this.selected = Vars.maps.all().first();
        }
        ButtonGroup<TextButton> group = new ButtonGroup<TextButton>();
        int maxcol = 3;
        int i = 0;
        Table table = new Table();
        table.defaults().size(200.0f, 90.0f).pad(4.0f);
        table.margin(10.0f);
        ScrollPane pane = new ScrollPane((Element)table, Styles.horizontalPane);
        pane.setFadeScrollBars(false);
        for (Map map : Vars.maps.all()) {
            TextButton button = new TextButton(map.name(), Styles.togglet);
            button.add(new BorderImage(map.safeTexture(), 2.0f).setScaling(Scaling.fit)).size(64.0f);
            button.getCells().reverse();
            button.clicked(() -> {
                this.selected = map;
            });
            button.getLabelCell().grow().left().padLeft(5.0f);
            group.add(button);
            table.add(button);
            if (++i % maxcol != 0) continue;
            table.row();
        }
        if (Vars.maps.all().size == 0) {
            table.add("$maps.none").center();
        } else {
            this.cont.add("$editor.loadmap");
        }
        this.cont.row();
        this.cont.add(pane);
    }
}

