/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.editor;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.StringMap;
import io.anuke.arc.scene.ui.TextArea;
import io.anuke.arc.scene.ui.TextField;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.editor.MapEditor;
import io.anuke.mindustry.editor.MapGenerateDialog;
import io.anuke.mindustry.editor.WaveInfoDialog;
import io.anuke.mindustry.game.Rules;
import io.anuke.mindustry.io.JsonIO;
import io.anuke.mindustry.maps.filters.GenerateFilter;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.dialogs.CustomRulesDialog;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;

public class MapInfoDialog
extends FloatingDialog {
    private final MapEditor editor;
    private final WaveInfoDialog waveInfo;
    private final MapGenerateDialog generate;
    private final CustomRulesDialog ruleInfo = new CustomRulesDialog();

    public MapInfoDialog(MapEditor editor) {
        super("$editor.mapinfo");
        this.editor = editor;
        this.waveInfo = new WaveInfoDialog(editor);
        this.generate = new MapGenerateDialog(editor, false);
        this.addCloseButton();
        this.shown(this::setup);
    }

    private void setup() {
        this.cont.clear();
        StringMap tags = this.editor.getTags();
        this.cont.pane((Table t) -> {
            t.add("$editor.name").padRight(8.0f).left();
            t.defaults().padTop(15.0f);
            TextField name = t.addField(tags.get("name", ""), text -> tags.put("name", text)).size(400.0f, 55.0f).get();
            name.setMessageText("$unknown");
            t.row();
            t.add("$editor.description").padRight(8.0f).left();
            TextArea description = t.addArea(tags.get("description", ""), Styles.areaField, text -> tags.put("description", text)).size(400.0f, 140.0f).get();
            t.row();
            t.add("$editor.author").padRight(8.0f).left();
            TextField author = t.addField(tags.get("author", Core.settings.getString("mapAuthor", "")), text -> {
                tags.put("author", text);
                Core.settings.put("mapAuthor", text);
                Core.settings.save();
            }).size(400.0f, 55.0f).get();
            author.setMessageText("$unknown");
            t.row();
            t.add("$editor.rules").padRight(8.0f).left();
            t.addButton("$edit", () -> {
                this.ruleInfo.show(Vars.state.rules, () -> {
                    Vars.state.rules = new Rules();
                    return Vars.state.rules;
                });
                this.hide();
            }).left().width(200.0f);
            t.row();
            t.add("$editor.waves").padRight(8.0f).left();
            t.addButton("$edit", () -> {
                this.waveInfo.show();
                this.hide();
            }).left().width(200.0f);
            t.row();
            t.add("$editor.generation").padRight(8.0f).left();
            t.addButton("$edit", () -> {
                this.generate.show(Vars.maps.readFilters(this.editor.getTags().get("genfilters", "")), (Array<GenerateFilter> filters) -> this.editor.getTags().put("genfilters", JsonIO.write(filters)));
                this.hide();
            }).left().width(200.0f);
            name.change();
            description.change();
            author.change();
            Vars.platform.addDialog(name, 50);
            Vars.platform.addDialog(author, 50);
            Vars.platform.addDialog(description, 1000);
            t.margin(16.0f);
        });
    }
}

