/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.editor;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.StringMap;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Pixmap;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.scene.Action;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.actions.Actions;
import io.anuke.arc.scene.event.ClickListener;
import io.anuke.arc.scene.event.Touchable;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.style.TextureRegionDrawable;
import io.anuke.arc.scene.ui.Button;
import io.anuke.arc.scene.ui.ButtonGroup;
import io.anuke.arc.scene.ui.Dialog;
import io.anuke.arc.scene.ui.ImageButton;
import io.anuke.arc.scene.ui.Label;
import io.anuke.arc.scene.ui.ScrollPane;
import io.anuke.arc.scene.ui.Slider;
import io.anuke.arc.scene.ui.TextButton;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.arc.util.Disposable;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.Structs;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.Tmp;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.editor.EditorTool;
import io.anuke.mindustry.editor.MapEditor;
import io.anuke.mindustry.editor.MapGenerateDialog;
import io.anuke.mindustry.editor.MapInfoDialog;
import io.anuke.mindustry.editor.MapLoadDialog;
import io.anuke.mindustry.editor.MapResizeDialog;
import io.anuke.mindustry.editor.MapView;
import io.anuke.mindustry.game.Gamemode;
import io.anuke.mindustry.game.Rules;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.game.Teams;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.io.JsonIO;
import io.anuke.mindustry.io.MapIO;
import io.anuke.mindustry.maps.Map;
import io.anuke.mindustry.ui.Cicon;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.OverlayFloor;
import io.anuke.mindustry.world.blocks.Rock;
import io.anuke.mindustry.world.blocks.storage.CoreBlock;

public class MapEditorDialog
extends Dialog
implements Disposable {
    public final MapEditor editor;
    private MapView view;
    private MapInfoDialog infoDialog;
    private MapLoadDialog loadDialog;
    private MapResizeDialog resizeDialog;
    private MapGenerateDialog generateDialog;
    private ScrollPane pane;
    private FloatingDialog menu;
    private Rules lastSavedRules;
    private boolean saved = false;
    private boolean shownWithMap = false;
    private Array<Block> blocksOut = new Array();

    public MapEditorDialog() {
        super("");
        this.background(Styles.black);
        this.editor = new MapEditor();
        this.view = new MapView(this.editor);
        this.infoDialog = new MapInfoDialog(this.editor);
        this.generateDialog = new MapGenerateDialog(this.editor, true);
        this.menu = new FloatingDialog("$menu");
        this.menu.addCloseButton();
        float swidth = 180.0f;
        this.menu.cont.table((Table t) -> {
            t.defaults().size(swidth, 60.0f).padBottom(5.0f).padRight(5.0f).padLeft(5.0f);
            t.addImageTextButton("$editor.savemap", Icon.floppy16Small, this::save);
            t.addImageTextButton("$editor.mapinfo", Icon.pencilSmall, () -> {
                this.infoDialog.show();
                this.menu.hide();
            });
            t.row();
            t.addImageTextButton("$editor.generate", Icon.editorSmall, () -> {
                this.generateDialog.show(this.generateDialog::applyToEditor);
                this.menu.hide();
            });
            t.addImageTextButton("$editor.resize", Icon.resizeSmall, () -> {
                this.resizeDialog.show();
                this.menu.hide();
            });
            t.row();
            t.addImageTextButton("$editor.import", Icon.loadMapSmall, () -> {
                Object[] objectArray = new Object[12];
                objectArray[0] = "$editor.importmap";
                objectArray[1] = "$editor.importmap.description";
                objectArray[2] = Icon.loadMap;
                objectArray[3] = this.loadDialog::show;
                objectArray[4] = "$editor.importfile";
                objectArray[5] = "$editor.importfile.description";
                objectArray[6] = Icon.file;
                objectArray[7] = () -> Vars.platform.showFileChooser(true, "msav", file -> Vars.ui.loadAnd(() -> Vars.maps.tryCatchMapError(() -> {
                    if (MapIO.isImage(file)) {
                        Vars.ui.showInfo("$editor.errorimage");
                    } else {
                        this.editor.beginEdit(MapIO.createMap(file, true));
                    }
                })));
                objectArray[8] = "$editor.importimage";
                objectArray[9] = "$editor.importimage.description";
                objectArray[10] = Icon.fileImage;
                objectArray[11] = () -> Vars.platform.showFileChooser(true, "png", file -> Vars.ui.loadAnd(() -> {
                    try {
                        Pixmap pixmap = new Pixmap((FileHandle)file);
                        this.editor.beginEdit(pixmap);
                        pixmap.dispose();
                    }
                    catch (Exception e) {
                        Vars.ui.showException("$editor.errorload", e);
                        Log.err(e);
                    }
                }));
                this.createDialog("$editor.import", objectArray);
            });
            t.addImageTextButton("$editor.export", Icon.saveMapSmall, () -> {
                if (!Vars.ios) {
                    Vars.platform.showFileChooser(false, "msav", file -> Vars.ui.loadAnd(() -> {
                        try {
                            if (!this.editor.getTags().containsKey("name")) {
                                this.editor.getTags().put("name", file.nameWithoutExtension());
                            }
                            MapIO.writeMap(file, this.editor.createMap((FileHandle)file));
                        }
                        catch (Exception e) {
                            Vars.ui.showException("$editor.errorsave", e);
                            Log.err(e);
                        }
                    }));
                } else {
                    Vars.ui.loadAnd(() -> {
                        try {
                            FileHandle result = Core.files.local(this.editor.getTags().get("name", "unknown") + "." + "msav");
                            MapIO.writeMap(result, this.editor.createMap(result));
                            Vars.platform.shareFile(result);
                        }
                        catch (Exception e) {
                            Vars.ui.showException("$editor.errorsave", e);
                            Log.err(e);
                        }
                    });
                }
            });
        });
        this.menu.cont.row();
        if (Vars.steam) {
            this.menu.cont.addImageTextButton("$editor.publish.workshop", Icon.linkSmall, () -> {
                Map builtin = Vars.maps.all().find((T m) -> m.name().equals(this.editor.getTags().get("name", "").trim()));
                if (this.editor.getTags().containsKey("steamid") && builtin != null && !builtin.custom) {
                    Vars.platform.viewListingID((String)this.editor.getTags().get("steamid"));
                    return;
                }
                Map map = this.save();
                if (this.editor.getTags().containsKey("steamid") && map != null) {
                    Vars.platform.viewListing(map);
                    return;
                }
                if (map == null) {
                    return;
                }
                if (map.tags.get("description", "").length() < 4) {
                    Vars.ui.showErrorMessage("$editor.nodescription");
                    return;
                }
                if (!Structs.contains(Gamemode.all, g -> g.valid(map))) {
                    Vars.ui.showErrorMessage("$map.nospawn");
                    return;
                }
                Vars.platform.publish(map);
            }).padTop(-3.0f).size(swidth * 2.0f + 10.0f, 60.0f).update((T b) -> b.setText(this.editor.getTags().containsKey("steamid") ? (((String)this.editor.getTags().get("author")).equals(Vars.player.name) ? "$workshop.listing" : "$view.workshop") : "$editor.publish.workshop"));
            this.menu.cont.row();
        }
        this.menu.cont.addImageTextButton("$editor.ingame", Icon.arrowSmall, this::playtest).padTop(!Vars.steam ? -3.0f : 1.0f).size(swidth * 2.0f + 10.0f, 60.0f);
        this.menu.cont.row();
        this.menu.cont.addImageTextButton("$quit", Icon.backSmall, () -> {
            this.tryExit();
            this.menu.hide();
        }).size(swidth * 2.0f + 10.0f, 60.0f);
        this.resizeDialog = new MapResizeDialog(this.editor, (x, y) -> {
            if (this.editor.width() != x || this.editor.height() != y) {
                Vars.ui.loadAnd(() -> this.editor.resize(x, y));
            }
        });
        this.loadDialog = new MapLoadDialog(map -> Vars.ui.loadAnd(() -> {
            try {
                this.editor.beginEdit((Map)map);
            }
            catch (Exception e) {
                Vars.ui.showException("$editor.errorload", e);
                Log.err(e);
            }
        }));
        this.setFillParent(true);
        this.clearChildren();
        this.margin(0.0f);
        this.update(() -> {
            if (Core.scene.getKeyboardFocus() instanceof Dialog && Core.scene.getKeyboardFocus() != this) {
                return;
            }
            if (Core.scene != null && Core.scene.getKeyboardFocus() == this) {
                this.doInput();
            }
        });
        this.shown(() -> {
            this.saved = true;
            if (!Core.settings.getBool("landscape")) {
                Vars.platform.beginForceLandscape();
            }
            this.editor.clearOp();
            Core.scene.setScrollFocus(this.view);
            if (!this.shownWithMap) {
                Vars.logic.reset();
                Vars.state.rules = new Rules();
                this.editor.beginEdit(200, 200);
            }
            this.shownWithMap = false;
            Time.runTask(10.0f, Vars.platform::updateRPC);
        });
        this.hidden(() -> {
            this.editor.clearOp();
            Vars.platform.updateRPC();
            if (!Core.settings.getBool("landscape")) {
                Vars.platform.endForceLandscape();
            }
        });
        this.shown(this::build);
    }

    public void resumeEditing() {
        Vars.state.set(GameState.State.menu);
        this.shownWithMap = true;
        this.show();
        Vars.state.rules = this.lastSavedRules == null ? new Rules() : this.lastSavedRules;
        this.lastSavedRules = null;
        this.editor.renderer().updateAll();
    }

    private void playtest() {
        this.menu.hide();
        Vars.ui.loadAnd(() -> {
            this.lastSavedRules = Vars.state.rules;
            this.hide();
            Vars.state.teams = new Teams();
            Vars.player.reset();
            Vars.state.rules = Gamemode.editor.apply(this.lastSavedRules.copy());
            Vars.state.rules.zone = null;
            Vars.world.setMap(new Map(StringMap.of("name", "Editor Playtesting", "width", this.editor.width(), "height", this.editor.height())));
            Vars.world.endMapLoad();
            for (int x = 0; x < Vars.world.width(); ++x) {
                for (int y = 0; y < Vars.world.height(); ++y) {
                    Tile tile = Vars.world.rawTile(x, y);
                    if (tile.entity == null) continue;
                    tile.entity.add();
                }
            }
            Vars.player.set((float)(Vars.world.width() * 8) / 2.0f, (float)(Vars.world.height() * 8) / 2.0f);
            Vars.player.setDead(false);
            Vars.logic.play();
        });
    }

    @ArcAnnotate.Nullable
    public Map save() {
        boolean isEditor = Vars.state.rules.editor;
        Vars.state.rules.editor = false;
        String name = this.editor.getTags().get("name", "").trim();
        this.editor.getTags().put("rules", JsonIO.write(Vars.state.rules));
        this.editor.getTags().remove("width");
        this.editor.getTags().remove("height");
        Vars.player.dead = true;
        Map returned = null;
        if (name.isEmpty()) {
            this.infoDialog.show();
            Core.app.post(() -> Vars.ui.showErrorMessage("$editor.save.noname"));
        } else {
            Map map = Vars.maps.all().find((T m) -> m.name().equals(name));
            if (map != null && !map.custom) {
                this.handleSaveBuiltin(map);
            } else {
                returned = Vars.maps.saveMap(this.editor.getTags());
                Vars.ui.showInfoFade("$editor.saved");
            }
        }
        this.menu.hide();
        this.saved = true;
        Vars.state.rules.editor = isEditor;
        return returned;
    }

    protected void handleSaveBuiltin(Map map) {
        Vars.ui.showErrorMessage("$editor.save.overwrite");
    }

    private void createDialog(String title, Object ... arguments) {
        FloatingDialog dialog = new FloatingDialog(title);
        float h = 90.0f;
        dialog.cont.defaults().size(360.0f, h).padBottom(5.0f).padRight(5.0f).padLeft(5.0f);
        for (int i = 0; i < arguments.length; i += 4) {
            String name = (String)arguments[i];
            String description = (String)arguments[i + 1];
            Drawable iconname = (Drawable)arguments[i + 2];
            Runnable listenable = (Runnable)arguments[i + 3];
            TextButton button = dialog.cont.addButton(name, () -> {
                listenable.run();
                dialog.hide();
                this.menu.hide();
            }).left().margin(0.0f).get();
            button.clearChildren();
            button.addImage(iconname).padLeft(10.0f);
            button.table((Table t) -> {
                t.add(name).growX().wrap();
                t.row();
                t.add(description).color(Color.gray).growX().wrap();
            }).growX().pad(10.0f).padLeft(5.0f);
            button.row();
            dialog.cont.row();
        }
        dialog.addCloseButton();
        dialog.show();
    }

    @Override
    public Dialog show() {
        return super.show(Core.scene, Actions.sequence((Action)Actions.alpha(1.0f)));
    }

    @Override
    public void hide() {
        super.hide(Actions.sequence((Action)Actions.alpha(0.0f)));
    }

    @Override
    public void dispose() {
        this.editor.renderer().dispose();
    }

    public void beginEditMap(FileHandle file) {
        Vars.ui.loadAnd(() -> {
            try {
                this.shownWithMap = true;
                this.editor.beginEdit(MapIO.createMap(file, true));
                this.show();
            }
            catch (Exception e) {
                Log.err(e);
                Vars.ui.showException("$editor.errorload", e);
            }
        });
    }

    public MapView getView() {
        return this.view;
    }

    public MapGenerateDialog getGenerateDialog() {
        return this.generateDialog;
    }

    public void resetSaved() {
        this.saved = false;
    }

    public boolean hasPane() {
        return Core.scene.getScrollFocus() == this.pane || Core.scene.getKeyboardFocus() != this;
    }

    public void build() {
        float size = 60.0f;
        this.clearChildren();
        this.table((Table cont) -> {
            cont.left();
            cont.table((Table mid) -> {
                mid.top();
                Table tools = new Table().top();
                ButtonGroup group = new ButtonGroup();
                Table[] lastTable = new Table[]{null};
                Consumer<EditorTool> addTool = tool -> {
                    ImageButton button = new ImageButton(Core.atlas.drawable("icon-" + tool.name() + "-small"), Styles.clearTogglei);
                    button.clicked(() -> {
                        this.view.setTool((EditorTool)((Object)((Object)((Object)tool))));
                        if (lastTable[0] != null) {
                            lastTable[0].remove();
                        }
                    });
                    button.update(() -> button.setChecked(this.view.getTool() == tool));
                    group.add(button);
                    if (tool.altModes.length > 0) {
                        button.clicked((ClickListener l) -> {
                            if (!Vars.mobile) {
                                l.setButton(KeyCode.MOUSE_RIGHT);
                            }
                        }, (ClickListener e) -> {
                            if (Vars.mobile && e.getTapCount() < 2) {
                                return;
                            }
                            if (lastTable[0] != null) {
                                lastTable[0].remove();
                            }
                            Table table = new Table(Styles.black9);
                            table.defaults().size(300.0f, 70.0f);
                            for (int i = 0; i < tool.altModes.length; ++i) {
                                int mode = i;
                                String name = tool.altModes[i];
                                table.addButton((Button b) -> {
                                    b.left();
                                    b.marginLeft(6.0f);
                                    b.setStyle(Styles.clearTogglet);
                                    b.add(Core.bundle.get("toolmode." + name)).left();
                                    b.row();
                                    b.add(Core.bundle.get("toolmode." + name + ".description")).color(Color.lightGray).left();
                                }, () -> {
                                    tool.mode = tool.mode == mode ? -1 : mode;
                                    table.remove();
                                }).update((T b) -> b.setChecked(tool.mode == mode));
                                table.row();
                            }
                            table.update(() -> {
                                Vector2 v = button.localToStageCoordinates(Tmp.v1.setZero());
                                table.setPosition(v.x, v.y, 10);
                                if (!this.isShown()) {
                                    table.remove();
                                    lastTable[0] = null;
                                }
                            });
                            table.pack();
                            table.act(Core.graphics.getDeltaTime());
                            this.addChild(table);
                            lastTable[0] = table;
                        });
                    }
                    Label mode = new Label("");
                    mode.setColor(Pal.remove);
                    mode.update(() -> mode.setText(tool.mode == -1 ? "" : "M" + (tool.mode + 1) + " "));
                    mode.setAlignment(20, 20);
                    mode.touchable(Touchable.disabled);
                    tools.stack(button, mode);
                };
                tools.defaults().size(size, size);
                tools.addImageButton((Drawable)Icon.menuLargeSmall, Styles.cleari, this.menu::show);
                ImageButton grid = tools.addImageButton((Drawable)Icon.gridSmall, Styles.clearTogglei, () -> this.view.setGrid(!this.view.isGrid())).get();
                addTool.accept(EditorTool.zoom);
                tools.row();
                ImageButton undo = tools.addImageButton((Drawable)Icon.undoSmall, Styles.cleari, this.editor::undo).get();
                ImageButton redo = tools.addImageButton((Drawable)Icon.redoSmall, Styles.cleari, this.editor::redo).get();
                addTool.accept(EditorTool.pick);
                tools.row();
                undo.setDisabled(() -> !this.editor.canUndo());
                redo.setDisabled(() -> !this.editor.canRedo());
                undo.update(() -> undo.getImage().setColor(undo.isDisabled() ? Color.gray : Color.white));
                redo.update(() -> redo.getImage().setColor(redo.isDisabled() ? Color.gray : Color.white));
                grid.update(() -> grid.setChecked(this.view.isGrid()));
                addTool.accept(EditorTool.line);
                addTool.accept(EditorTool.pencil);
                addTool.accept(EditorTool.eraser);
                tools.row();
                addTool.accept(EditorTool.fill);
                addTool.accept(EditorTool.spray);
                ImageButton rotate = tools.addImageButton((Drawable)Icon.arrow16Small, Styles.cleari, () -> {
                    this.editor.rotation = (this.editor.rotation + 1) % 4;
                }).get();
                rotate.getImage().update(() -> {
                    rotate.getImage().setRotation(this.editor.rotation * 90);
                    rotate.getImage().setOrigin(1);
                });
                tools.row();
                tools.table(Tex.underline, t -> t.add("$editor.teams")).colspan(3).height(40.0f).width(size * 3.0f + 3.0f).padBottom(3.0f);
                tools.row();
                ButtonGroup<ImageButton> teamgroup = new ButtonGroup<ImageButton>();
                int i = 0;
                for (Team team : Team.all) {
                    ImageButton button = new ImageButton((Drawable)Tex.whiteui, Styles.clearTogglePartiali);
                    button.margin(4.0f);
                    button.getImageCell().grow();
                    button.getStyle().imageUpColor = team.color;
                    button.clicked(() -> {
                        this.editor.drawTeam = team;
                    });
                    button.update(() -> button.setChecked(this.editor.drawTeam == team));
                    teamgroup.add(button);
                    tools.add(button);
                    if (i++ % 3 != 2) continue;
                    tools.row();
                }
                mid.add(tools).top().padBottom(-6.0f);
                mid.row();
                mid.table(Tex.underline, t -> {
                    Slider slider = new Slider(0.0f, MapEditor.brushSizes.length - 1, 1.0f, false);
                    slider.moved(f -> {
                        this.editor.brushSize = MapEditor.brushSizes[(int)f];
                    });
                    for (int j = 0; j < MapEditor.brushSizes.length; ++j) {
                        if (MapEditor.brushSizes[j] != this.editor.brushSize) continue;
                        slider.setValue(j);
                    }
                    t.top();
                    t.add("$editor.brush");
                    t.row();
                    t.add(slider).width(size * 3.0f - 20.0f).padTop(4.0f);
                }).padTop(5.0f).growX().top();
            }).margin(0.0f).left().growY();
            cont.table((Table t) -> t.add(this.view).grow()).grow();
            cont.table(this::addBlockSelection).right().growY();
        }).grow();
    }

    private void doInput() {
        int i;
        if (Core.input.ctrl()) {
            for (i = 0; i < this.view.getTool().altModes.length + 1; ++i) {
                if (!Core.input.keyTap(KeyCode.valueOf("NUM_" + (i + 1)))) continue;
                this.view.getTool().mode = i - 1;
            }
        } else {
            for (i = 0; i < EditorTool.values().length; ++i) {
                if (!Core.input.keyTap(KeyCode.valueOf("NUM_" + (i + 1)))) continue;
                this.view.setTool(EditorTool.values()[i]);
                break;
            }
        }
        if (Core.input.keyTap(KeyCode.ESCAPE) && !this.menu.isShown()) {
            this.menu.show();
        }
        if (Core.input.keyTap(KeyCode.R)) {
            this.editor.rotation = Mathf.mod(this.editor.rotation + 1, 4);
        }
        if (Core.input.keyTap(KeyCode.E)) {
            this.editor.rotation = Mathf.mod(this.editor.rotation - 1, 4);
        }
        if (Core.input.ctrl()) {
            if (Core.input.keyTap(KeyCode.Z)) {
                this.editor.undo();
            }
            if (Core.input.keyTap(KeyCode.T)) {
                for (int x = 0; x < this.editor.width(); ++x) {
                    for (int y = 0; y < this.editor.height(); ++y) {
                        Tile tile = this.editor.tile(x, y);
                        if (tile.block().breakable && tile.block() instanceof Rock) {
                            tile.setBlock(Blocks.air);
                            this.editor.renderer().updatePoint(x, y);
                        }
                        if (tile.overlay() == Blocks.air || tile.overlay() == Blocks.spawn) continue;
                        tile.setOverlay(Blocks.air);
                        this.editor.renderer().updatePoint(x, y);
                    }
                }
                this.editor.flushOp();
            }
            if (Core.input.keyTap(KeyCode.Y)) {
                this.editor.redo();
            }
            if (Core.input.keyTap(KeyCode.S)) {
                this.save();
            }
            if (Core.input.keyTap(KeyCode.G)) {
                this.view.setGrid(!this.view.isGrid());
            }
        }
    }

    private void tryExit() {
        if (!this.saved) {
            Vars.ui.showConfirm("$confirm", "$editor.unsaved", this::hide);
        } else {
            this.hide();
        }
    }

    private void addBlockSelection(Table table) {
        Table content = new Table();
        this.pane = new ScrollPane((Element)content);
        this.pane.setFadeScrollBars(false);
        this.pane.setOverscroll(true, false);
        this.pane.exited(() -> {
            if (this.pane.hasScroll()) {
                Core.scene.setScrollFocus(this.view);
            }
        });
        ButtonGroup<ImageButton> group = new ButtonGroup<ImageButton>();
        int i = 0;
        this.blocksOut.clear();
        this.blocksOut.addAll(Vars.content.blocks());
        this.blocksOut.sort((b1, b2) -> {
            int core = -Boolean.compare(b1 instanceof CoreBlock, b2 instanceof CoreBlock);
            if (core != 0) {
                return core;
            }
            int synth = Boolean.compare(b1.synthetic(), b2.synthetic());
            if (synth != 0) {
                return synth;
            }
            int ore = Boolean.compare(b1 instanceof OverlayFloor, b2 instanceof OverlayFloor);
            if (ore != 0) {
                return ore;
            }
            return Integer.compare(b1.id, b2.id);
        });
        for (Block block : this.blocksOut) {
            TextureRegion region = block.icon(Cicon.medium);
            if (!Core.atlas.isFound(region)) continue;
            ImageButton button = new ImageButton((Drawable)Tex.whiteui, Styles.clearTogglei);
            button.getStyle().imageUp = new TextureRegionDrawable(region);
            button.clicked(() -> {
                this.editor.drawBlock = block;
            });
            button.resizeImage(32.0f);
            button.update(() -> button.setChecked(this.editor.drawBlock == block));
            group.add(button);
            content.add(button).size(50.0f);
            if (++i % 4 != 0) continue;
            content.row();
        }
        ((ImageButton)group.getButtons().get(2)).setChecked(true);
        table.table(Tex.underline, extra -> extra.labelWrap(() -> this.editor.drawBlock.localizedName).width(200.0f).center()).growX();
        table.row();
        table.add(this.pane).growY().fillX();
    }
}

