/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.editor;

import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.editor.DrawOperation;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.gen.TileOp;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.Floor;
import io.anuke.mindustry.world.blocks.OverlayFloor;
import io.anuke.mindustry.world.modules.ConsumeModule;
import io.anuke.mindustry.world.modules.ItemModule;
import io.anuke.mindustry.world.modules.LiquidModule;
import io.anuke.mindustry.world.modules.PowerModule;

public class EditorTile
extends Tile {
    public EditorTile(int x, int y, int floor, int overlay, int wall) {
        super(x, y, floor, overlay, wall);
    }

    @Override
    public void setFloor(Floor type) {
        if (Vars.state.is(GameState.State.playing)) {
            super.setFloor(type);
            return;
        }
        if (type instanceof OverlayFloor) {
            if (!this.floor.isLiquid) {
                this.setOverlayID(type.id);
            }
            return;
        }
        if (this.floor == type && this.overlayID() == 0) {
            return;
        }
        if (this.overlayID() != 0) {
            this.op(DrawOperation.OpType.overlay, this.overlayID());
        }
        if (this.floor != type) {
            this.op(DrawOperation.OpType.floor, this.floor.id);
        }
        super.setFloor(type);
    }

    @Override
    public void setBlock(Block type) {
        if (Vars.state.is(GameState.State.playing)) {
            super.setBlock(type);
            return;
        }
        if (this.block == type) {
            return;
        }
        this.op(DrawOperation.OpType.block, this.block.id);
        if (this.rotation != 0) {
            this.op(DrawOperation.OpType.rotation, this.rotation);
        }
        if (this.team != 0) {
            this.op(DrawOperation.OpType.team, this.team);
        }
        super.setBlock(type);
    }

    @Override
    public void setBlock(Block type, Team team, int rotation) {
        if (Vars.state.is(GameState.State.playing)) {
            super.setBlock(type, team, rotation);
            return;
        }
        this.setBlock(type);
        this.setTeam(team);
        this.rotation(rotation);
    }

    @Override
    public void setTeam(Team team) {
        if (Vars.state.is(GameState.State.playing)) {
            super.setTeam(team);
            return;
        }
        if (this.getTeamID() == team.ordinal()) {
            return;
        }
        this.op(DrawOperation.OpType.team, this.getTeamID());
        super.setTeam(team);
    }

    @Override
    public void rotation(int rotation) {
        if (Vars.state.is(GameState.State.playing)) {
            super.rotation(rotation);
            return;
        }
        if (rotation == this.rotation()) {
            return;
        }
        this.op(DrawOperation.OpType.rotation, this.rotation());
        super.rotation(rotation);
    }

    @Override
    public void setOverlay(Block overlay) {
        this.setOverlayID(overlay.id);
    }

    @Override
    public void setOverlayID(short overlay) {
        if (Vars.state.is(GameState.State.playing)) {
            super.setOverlayID(overlay);
            return;
        }
        if (this.overlayID() == overlay) {
            return;
        }
        this.op(DrawOperation.OpType.overlay, this.overlay.id);
        super.setOverlayID(overlay);
    }

    @Override
    protected void preChanged() {
        if (Vars.state.is(GameState.State.playing)) {
            super.preChanged();
            return;
        }
        super.setTeam(Team.derelict);
    }

    @Override
    protected void changed() {
        Block block;
        if (Vars.state.is(GameState.State.playing)) {
            super.changed();
            return;
        }
        this.entity = null;
        if (this.block == null) {
            this.block = Blocks.air;
        }
        if (this.floor == null) {
            this.floor = (Floor)Blocks.air;
        }
        if ((block = this.block()).hasEntity()) {
            this.entity = block.newEntity().init(this, false);
            this.entity.cons = new ConsumeModule(this.entity);
            if (block.hasItems) {
                this.entity.items = new ItemModule();
            }
            if (block.hasLiquids) {
                this.entity.liquids = new LiquidModule();
            }
            if (block.hasPower) {
                this.entity.power = new PowerModule();
            }
        }
    }

    private void op(DrawOperation.OpType type, short value) {
        Vars.ui.editor.editor.addTileOp(TileOp.get(this.x, this.y, (byte)type.ordinal(), value));
    }
}

