/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.editor;

import io.anuke.arc.collection.LongArray;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.editor.MapEditor;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.gen.TileOp;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.Floor;

public class DrawOperation {
    private MapEditor editor;
    private LongArray array = new LongArray();

    public DrawOperation(MapEditor editor) {
        this.editor = editor;
    }

    public boolean isEmpty() {
        return this.array.isEmpty();
    }

    public void addOperation(long op) {
        this.array.add(op);
    }

    public void undo() {
        for (int i = this.array.size - 1; i >= 0; --i) {
            this.updateTile(i);
        }
    }

    public void redo() {
        for (int i = 0; i < this.array.size; ++i) {
            this.updateTile(i);
        }
    }

    private void updateTile(int i) {
        long l = this.array.get(i);
        this.array.set(i, TileOp.get(TileOp.x(l), TileOp.y(l), TileOp.type(l), this.getTile(this.editor.tile(TileOp.x(l), TileOp.y(l)), TileOp.type(l))));
        this.setTile(this.editor.tile(TileOp.x(l), TileOp.y(l)), TileOp.type(l), TileOp.value(l));
    }

    short getTile(Tile tile, byte type) {
        if (type == OpType.floor.ordinal()) {
            return tile.floorID();
        }
        if (type == OpType.block.ordinal()) {
            return tile.blockID();
        }
        if (type == OpType.rotation.ordinal()) {
            return tile.rotation();
        }
        if (type == OpType.team.ordinal()) {
            return tile.getTeamID();
        }
        if (type == OpType.overlay.ordinal()) {
            return tile.overlayID();
        }
        throw new IllegalArgumentException("Invalid type.");
    }

    void setTile(Tile tile, byte type, short to) {
        this.editor.load(() -> {
            if (type == OpType.floor.ordinal()) {
                tile.setFloor((Floor)Vars.content.block(to));
            } else if (type == OpType.block.ordinal()) {
                Block block = Vars.content.block(to);
                tile.setBlock(block, tile.getTeam(), tile.rotation());
            } else if (type == OpType.rotation.ordinal()) {
                tile.rotation(to);
            } else if (type == OpType.team.ordinal()) {
                tile.setTeam(Team.all[to]);
            } else if (type == OpType.overlay.ordinal()) {
                tile.setOverlayID(to);
            }
        });
        this.editor.renderer().updatePoint(tile.x, tile.y);
    }

    public static enum OpType {
        floor,
        block,
        rotation,
        team,
        overlay;

    }

    class TileOpStruct {
        short x;
        short y;
        byte type;
        short value;

        TileOpStruct() {
        }
    }
}

